/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.compat.Compat;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.MagicData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.SwimData;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.TreasureRestData;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    protected PlayerMixin(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    public void dragonSurvival$disableSuffocationDamage(DamageSource source, CallbackInfoReturnable<Boolean> callback) {
        if (ServerConfig.disableDragonSuffocation.booleanValue() && source == this.damageSources().inWall() && DragonStateProvider.isDragon((Entity)this)) {
            callback.setReturnValue((Object)true);
        }
    }

    @WrapOperation(method={"getDigSpeed"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onGround()Z")})
    private boolean dragonSurvival$disablePenalty(Player instance, Operation<Boolean> original) {
        if (SwimData.getData(instance).canSwimIn(instance.getMaxHeightFluidType())) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @Inject(method={"isImmobile"}, at={@At(value="HEAD")}, cancellable=true)
    private void dragonSurvival$preventMovement(CallbackInfoReturnable<Boolean> callback) {
        MagicData data;
        if (!(this.isDeadOrDying() || this.isSleeping() || (data = MagicData.getData((Player)this)).getCurrentlyCasting() == null || data.getCurrentlyCasting().value().activation().canMoveWhileCasting())) {
            callback.setReturnValue((Object)true);
        }
    }

    @ModifyReturnValue(method={"isSleepingLongEnough"}, at={@At(value="RETURN")})
    public boolean dragonSurvival$isSleepingLongEnough(boolean isSleepingLongEnough) {
        if (isSleepingLongEnough) {
            return true;
        }
        Player player = (Player)this;
        return DragonStateProvider.isDragon((Entity)player) && TreasureRestData.getData(player).canSleep();
    }

    @ModifyReturnValue(method={"canPlayerFitWithinBlocksAndEntitiesWhen"}, at={@At(value="RETURN")})
    private boolean dragonSurvival$checkDragonHitbox(boolean returnValue, @Local(argsOnly=true) Pose pose) {
        Player self = (Player)this;
        if (DragonStateProvider.isDragon((Entity)self) && !Compat.hasModelSwap(self)) {
            return DragonSizeHandler.canPoseFit(self, pose);
        }
        return returnValue;
    }

    @ModifyExpressionValue(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSwimming()Z")})
    private boolean dragonSurvival$consideredSwimmingEvenWhenGroundedInWater(boolean isSwimming) {
        if (isSwimming) {
            return true;
        }
        Player self = (Player)this;
        return DragonStateProvider.isDragon((Entity)self) && DragonEntity.isConsideredSwimmingForAnimation(self);
    }
}

