/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.HunterOmenHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAdvancementTriggers;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Shadow
    public boolean increaseProfessionLevelOnUpdate;
    @Shadow
    public int updateMerchantTimer;

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/trading/MerchantOffers;isEmpty()Z", shift=At.Shift.BY, by=2)})
    private void dragonSurvival$displayPillageInfo(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> callback, @Local boolean hasNoOffers) {
        if (hasNoOffers && player.hasEffect(DSEffects.HUNTER_OMEN)) {
            player.displayClientMessage((Component)Component.translatable((String)EntityStateHandler.CANNOT_PILLAGE), true);
        }
    }

    @Inject(method={"startTrading"}, at={@At(value="HEAD")}, cancellable=true)
    private void dragonSurvival$preventTradingWithMarkedPlayers(Player player, CallbackInfo callback) {
        if (player.hasEffect(DSEffects.HUNTER_OMEN)) {
            if (EntityStateHandler.cannotPillageProfession((Villager)this)) {
                player.displayClientMessage((Component)Component.translatable((String)EntityStateHandler.CANNOT_PILLAGE), true);
                callback.cancel();
                return;
            }
            EntityStateHandler handler = (EntityStateHandler)this.getData((Supplier)DSDataAttachments.ENTITY_HANDLER);
            if (handler.pillageCooldown == 0) {
                List<ItemStack> loot;
                this.setVillagerXp(this.getVillagerXp() + ServerConfig.pillageXPGain);
                if (this.shouldIncreaseLevel()) {
                    this.updateMerchantTimer = 40;
                    this.increaseProfessionLevelOnUpdate = true;
                }
                if ((loot = HunterOmenHandler.generateVillagerLoot(this, player.level(), null, false)).isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)EntityStateHandler.PILLAGE_UNSUCCESSFUL), true);
                } else {
                    loot.forEach(arg_0 -> ((Inventory)player.getInventory()).add(arg_0));
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        DSAdvancementTriggers.STEAL_FROM_VILLAGER.get().trigger(serverPlayer);
                    }
                }
                this.setLastHurtByMob((LivingEntity)player);
                this.makeSound(this.getHurtSound(this.damageSources().generic()));
                player.level().broadcastEntityEvent((Entity)this, (byte)13);
                handler.setPillageCooldown();
                handler.sync((Entity)this, null);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)EntityStateHandler.PILLAGE_ON_COOLDOWN, (Object[])new Object[]{Functions.ticksToSeconds(handler.pillageCooldown)}), true);
                this.setUnhappy();
            }
            callback.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void dragonSurvival$tickPillagedTimer(CallbackInfo callback) {
        this.getExistingData((Supplier)DSDataAttachments.ENTITY_HANDLER).ifPresent(handler -> {
            handler.pillageCooldown = Math.max(0, handler.pillageCooldown - 1);
        });
    }

    @Inject(method={"customServerAiStep"}, at={@At(value="TAIL")})
    private void dragonSurvival$triggerSweatEvent(CallbackInfo callback) {
        Villager villager = (Villager)this;
        if (villager.isNoAi()) {
            return;
        }
        villager.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(entities -> entities.findClosest(player -> HunterOmenHandler.avoidPlayer((LivingEntity)villager, player))).ifPresent(player -> {
            if ((double)villager.getRandom().nextInt(100) < villager.distanceToSqr((Entity)player)) {
                return;
            }
            villager.level().broadcastEntityEvent((Entity)villager, (byte)42);
        });
    }

    @Shadow
    public abstract boolean shouldIncreaseLevel();

    @Shadow
    public abstract int getVillagerXp();

    @Shadow
    public abstract void setVillagerXp(int var1);

    @Shadow
    public abstract void setLastHurtByMob(@Nullable LivingEntity var1);

    @Shadow
    protected abstract SoundEvent getHurtSound(@NotNull DamageSource var1);

    @Shadow
    protected abstract void setUnhappy();
}

