/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEnchantments;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.DSMapDecorationTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.LangKey;
import by.dragonsurvivalteam.dragonsurvival.util.EnchantmentUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public class DSTrades {
    public static final DeferredRegister<PoiType> POI_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"dragonsurvival");
    public static final DeferredRegister<VillagerProfession> PROFESSION_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"dragonsurvival");
    public static final Holder<PoiType> DRAGON_RIDER_POI = POI_REGISTRY.register("dragon_rider_poi", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((Block)DSBlocks.DRAGON_RIDER_WORKBENCH.get()).getStateDefinition().getPossibleStates()), 1, 1));
    @Translation(type=Translation.Type.VILLAGER_PROFESSION, comments={"Dragon Rider"})
    public static final Holder<VillagerProfession> DRAGON_RIDER_PROFESSION = PROFESSION_REGISTRY.register("dragon_rider", () -> new VillagerProfession("dragon_rider", holder -> holder.value() == DRAGON_RIDER_POI.value(), poiTypeHolder -> poiTypeHolder.value() == DRAGON_RIDER_POI.value(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.VILLAGER_WORK_ARMORER));
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> LEADER_TRADES = new Int2ObjectOpenHashMap();
    public static final TagKey<Structure> ON_DRAGON_HUNTERS_CASTLE_MAPS = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)DragonSurvival.res("on_dragon_hunter_maps"));

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades;
        if (event.getType() == DRAGON_RIDER_PROFESSION.value()) {
            trades = event.getTrades();
            ((List)trades.get(1)).add(new EnchantBookForEmeralds(DSEnchantments.UNBREAKABLE_SPIRIT, 10));
            ((List)trades.get(2)).add(new EnchantBookForEmeralds(DSEnchantments.COMBAT_RECOVERY, 20));
            ((List)trades.get(3)).add(new EnchantBookForEmeralds(DSEnchantments.AERODYNAMIC_MASTERY, 20));
            ((List)trades.get(4)).add(new EnchantBookForEmeralds(DSEnchantments.SACRED_SCALES, 20));
            ((List)trades.get(5)).add(new ItemTrade(new ItemStack((ItemLike)Items.EMERALD, 32), new ItemStack(DSItems.LIGHT_KEY, 1), 12, 35));
            ArrayList LEADER_TRADES_LEVEL_1 = Lists.newArrayList((Object[])new VillagerTrades.ItemListing[]{new ItemTrade(new ItemStack(DSItems.DRAGON_HEART_SHARD, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 1.0f, 5), new ItemTrade(new ItemStack((ItemLike)Items.EMERALD, 12), new ItemStack(DSItems.PARTISAN, 1), 1, 1.0f, 5)});
            ArrayList LEADER_TRADES_LEVEL_2 = Lists.newArrayList((Object[])new VillagerTrades.ItemListing[]{new ItemTrade(new ItemStack(DSItems.WEAK_DRAGON_HEART, 1), new ItemStack((ItemLike)Items.EMERALD, 1), 16, 1.0f, 10)});
            ArrayList LEADER_TRADES_LEVEL_3 = Lists.newArrayList((Object[])new VillagerTrades.ItemListing[]{new ItemTrade(new ItemStack((ItemLike)Items.EMERALD, 32), new ItemStack(DSItems.HUNTER_KEY, 1), 16, 1.0f, 35)});
            ArrayList LEADER_TRADES_LEVEL_4 = Lists.newArrayList((Object[])new VillagerTrades.ItemListing[]{new ItemTrade(new ItemStack(DSItems.ELDER_DRAGON_HEART, 1), new ItemStack((ItemLike)Items.EMERALD, 12), 12, 1.0f, 25)});
            ArrayList LEADER_TRADES_LEVEL_5 = Lists.newArrayList((Object[])new VillagerTrades.ItemListing[]{new EnchantBookForEmeralds(DSEnchantments.DRAGONSBANE, 15), new EnchantBookForEmeralds(DSEnchantments.BOLAS, 15)});
            LEADER_TRADES.put(1, (Object)LEADER_TRADES_LEVEL_1.toArray(new VillagerTrades.ItemListing[0]));
            LEADER_TRADES.put(2, (Object)LEADER_TRADES_LEVEL_2.toArray(new VillagerTrades.ItemListing[0]));
            LEADER_TRADES.put(3, (Object)LEADER_TRADES_LEVEL_3.toArray(new VillagerTrades.ItemListing[0]));
            LEADER_TRADES.put(4, (Object)LEADER_TRADES_LEVEL_4.toArray(new VillagerTrades.ItemListing[0]));
            LEADER_TRADES.put(5, (Object)LEADER_TRADES_LEVEL_5.toArray(new VillagerTrades.ItemListing[0]));
        }
        if (event.getType() == VillagerProfession.CARTOGRAPHER) {
            trades = event.getTrades();
            ((List)trades.get(2)).add(new TreasureMapForEmeralds(15, ON_DRAGON_HUNTERS_CASTLE_MAPS, LangKey.ITEM_KINGDOM_EXPLORER_MAP, DSMapDecorationTypes.DRAGON_HUNTER, 16, 30));
        }
    }

    static class EnchantBookForEmeralds
    implements VillagerTrades.ItemListing {
        private final ResourceKey<Enchantment> enchantment;
        private final int villagerXp;
        private final int minLevel;
        private final int maxLevel;

        public EnchantBookForEmeralds(ResourceKey<Enchantment> enchantment, int villagerExperience) {
            this(enchantment, villagerExperience, 0, Integer.MAX_VALUE);
        }

        public EnchantBookForEmeralds(ResourceKey<Enchantment> enchantment, int villagerExperience, int minLevel, int maxLevel) {
            this.enchantment = enchantment;
            this.villagerXp = villagerExperience;
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public MerchantOffer getOffer(@NotNull Entity trader, @NotNull RandomSource random) {
            Holder.Reference<Enchantment> enchantment = EnchantmentUtils.getHolder(this.enchantment);
            if (enchantment == null) {
                DragonSurvival.LOGGER.warn("Enchantment [{}] is not present - cannot create proper trade offer", (Object)this.enchantment.location());
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), Optional.empty(), Items.BOOK.getDefaultInstance(), 1, 0, 1.0f);
            }
            int minLevel = Math.max(((Enchantment)enchantment.value()).getMinLevel(), this.minLevel);
            int maxLevel = Math.min(((Enchantment)enchantment.value()).getMaxLevel(), this.maxLevel);
            int level = Mth.nextInt((RandomSource)random, (int)minLevel, (int)maxLevel);
            ItemStack book = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, level));
            int cost = 2 + random.nextInt(5 + level * 10) + 3 * level;
            if (enchantment.is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
                cost *= 2;
            }
            if (cost > 64) {
                cost = 64;
            }
            return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, cost), Optional.of(new ItemCost((ItemLike)Items.BOOK)), book, 12, this.villagerXp, 0.2f);
        }
    }

    public static class ItemTrade
    implements VillagerTrades.ItemListing {
        private final ItemCost item;
        private final ItemStack result;
        private final int maxUses;
        private final float priceMultiplier;
        private final int xp;

        public ItemTrade(ItemStack item, ItemStack result, int maxUses, int xp) {
            this.item = new ItemCost((ItemLike)item.getItem(), item.getCount());
            this.result = result;
            this.maxUses = maxUses;
            this.priceMultiplier = 0.0f;
            this.xp = xp;
        }

        public ItemTrade(ItemStack item, ItemStack result, int maxUses, float priceMultiplier, int xp) {
            this.item = new ItemCost((ItemLike)item.getItem(), item.getCount());
            this.result = result;
            this.maxUses = maxUses;
            this.priceMultiplier = priceMultiplier;
            this.xp = xp;
        }

        @Nullable
        public MerchantOffer getOffer(@NotNull Entity entity, @NotNull RandomSource random) {
            return new MerchantOffer(this.item, Optional.empty(), this.result, this.maxUses, this.xp, this.priceMultiplier);
        }
    }

    public static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final TagKey<Structure> destination;
        private final String displayName;
        private final Holder<MapDecorationType> destinationType;
        private final int maxUses;
        private final int villagerXp;

        public TreasureMapForEmeralds(int pEmeraldCost, TagKey<Structure> pDestination, String pDisplayName, Holder<MapDecorationType> pDestinationType, int pMaxUses, int pVillagerXp) {
            this.emeraldCost = pEmeraldCost;
            this.destination = pDestination;
            this.displayName = pDisplayName;
            this.destinationType = pDestinationType;
            this.maxUses = pMaxUses;
            this.villagerXp = pVillagerXp;
        }

        @Nullable
        public MerchantOffer getOffer(Entity trader, @NotNull RandomSource random) {
            Level level = trader.level();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)level;
            BlockPos blockpos = serverlevel.findNearestMapStructure(this.destination, trader.blockPosition(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.create((Level)serverlevel, (int)blockpos.getX(), (int)blockpos.getZ(), (byte)2, (boolean)true, (boolean)true);
                MapItem.renderBiomePreviewMap((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.addTargetDecoration((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", this.destinationType);
                itemstack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)this.displayName));
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.emeraldCost), Optional.of(new ItemCost((ItemLike)Items.COMPASS)), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }
}

