/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.ManaCost;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Activation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Animations;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Notification;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Sound;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record ChanneledActivation(Optional<LevelBasedValue> initialManaCost, Optional<ManaCost> continuousManaCost, Optional<LevelBasedValue> castTime, Optional<LevelBasedValue> cooldown, Notification notification, boolean canMoveWhileCasting, Optional<Sound> sound, Optional<Animations> animations) implements Activation
{
    public static final MapCodec<ChanneledActivation> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.optionalFieldOf("initial_mana_cost").forGetter(ChanneledActivation::initialManaCost), (App)ManaCost.CODEC.validate(cost -> cost.manaCostType() == ManaCost.ManaCostType.TICKING ? DataResult.success((Object)cost) : DataResult.error(() -> "Channeled activation only supports [ticking] continuous mana cost")).optionalFieldOf("continuous_mana_cost").forGetter(ChanneledActivation::continuousManaCost), (App)LevelBasedValue.CODEC.optionalFieldOf("cast_time").forGetter(ChanneledActivation::castTime), (App)LevelBasedValue.CODEC.optionalFieldOf("cooldown").forGetter(ChanneledActivation::cooldown), (App)Notification.CODEC.optionalFieldOf("notification", (Object)Notification.DEFAULT).forGetter(ChanneledActivation::notification), (App)Codec.BOOL.optionalFieldOf("can_move_while_casting", (Object)true).forGetter(ChanneledActivation::canMoveWhileCasting), (App)Sound.CODEC.optionalFieldOf("sound").forGetter(ChanneledActivation::sound), (App)Animations.CODEC.optionalFieldOf("animations").forGetter(ChanneledActivation::animations)).apply((Applicative)instance, ChanneledActivation::new));

    @Override
    public float getInitialManaCost(int level) {
        return this.initialManaCost.map(cost -> Float.valueOf(cost.calculate(level))).orElseGet(() -> Float.valueOf(Activation.super.getInitialManaCost(level))).floatValue();
    }

    @Override
    public int getCastTime(int level) {
        return this.castTime.map(time -> (int)time.calculate(level)).orElseGet(() -> Activation.super.getCastTime(level));
    }

    @Override
    public int getCooldown(int level) {
        return this.cooldown.map(cooldown -> (int)cooldown.calculate(level)).orElseGet(() -> Activation.super.getCooldown(level));
    }

    @Override
    public Activation.Type type() {
        return Activation.Type.CHANNELED;
    }

    @Override
    public MapCodec<? extends Activation> codec() {
        return CODEC;
    }
}

