/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Activation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Animations;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Notification;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Sound;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record SimpleActivation(Optional<LevelBasedValue> initialManaCost, Optional<LevelBasedValue> castTime, Optional<LevelBasedValue> cooldown, Notification notification, boolean canMoveWhileCasting, Optional<Sound> sound, Optional<Animations> animations) implements Activation
{
    public static final MapCodec<SimpleActivation> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.optionalFieldOf("initial_mana_cost").forGetter(SimpleActivation::initialManaCost), (App)LevelBasedValue.CODEC.optionalFieldOf("cast_time").forGetter(SimpleActivation::castTime), (App)LevelBasedValue.CODEC.optionalFieldOf("cooldown").forGetter(SimpleActivation::cooldown), (App)Notification.CODEC.optionalFieldOf("notification", (Object)Notification.DEFAULT).forGetter(SimpleActivation::notification), (App)Codec.BOOL.optionalFieldOf("can_move_while_casting", (Object)true).forGetter(SimpleActivation::canMoveWhileCasting), (App)Sound.CODEC.validate(sound -> sound.looping().isPresent() ? DataResult.error(() -> "Simple activation does not support [looping] sounds") : DataResult.success((Object)sound)).optionalFieldOf("sound").forGetter(SimpleActivation::sound), (App)Animations.CODEC.validate(animations -> animations.looping().isPresent() ? DataResult.error(() -> "Simple activation does not support [looping] animations") : DataResult.success((Object)animations)).optionalFieldOf("animations").forGetter(SimpleActivation::animations)).apply((Applicative)instance, SimpleActivation::new));

    @Override
    public float getInitialManaCost(int level) {
        return this.initialManaCost.map(cost -> Float.valueOf(cost.calculate(level))).orElseGet(() -> Float.valueOf(Activation.super.getInitialManaCost(level))).floatValue();
    }

    @Override
    public int getCastTime(int level) {
        return this.castTime.map(time -> (int)time.calculate(level)).orElseGet(() -> Activation.super.getCastTime(level));
    }

    @Override
    public int getCooldown(int level) {
        return this.cooldown.map(cooldown -> (int)cooldown.calculate(level)).orElseGet(() -> Activation.super.getCooldown(level));
    }

    @Override
    public Activation.Type type() {
        return Activation.Type.SIMPLE;
    }

    @Override
    public MapCodec<? extends Activation> codec() {
        return CODEC;
    }
}

