/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.common_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.block_effects.AbilityBlockEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public record RunFunctionEffect(ResourceLocation function) implements AbilityEntityEffect,
AbilityBlockEffect
{
    public static final MapCodec<RunFunctionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("function").forGetter(RunFunctionEffect::function)).apply((Applicative)instance, RunFunctionEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        MinecraftServer server = dragon.serverLevel().getServer();
        ServerFunctionManager manager = server.getFunctions();
        manager.get(this.function).ifPresent(source -> {
            CommandSourceStack stack = server.createCommandSourceStack().withPermission(2).withSuppressedOutput().withEntity(target).withLevel(dragon.serverLevel()).withPosition(target.position()).withRotation(target.getRotationVector());
            manager.execute(source, stack);
        });
    }

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, BlockPos position, @Nullable Direction direction) {
        MinecraftServer server = dragon.serverLevel().getServer();
        ServerFunctionManager manager = server.getFunctions();
        manager.get(this.function).ifPresent(source -> {
            CommandSourceStack stack = server.createCommandSourceStack().withPermission(2).withSuppressedOutput().withLevel(dragon.serverLevel()).withPosition(position.getCenter());
            if (direction != null) {
                Vector3f rotation = new Vector3f();
                new Matrix4f().set((Quaternionfc)direction.getRotation()).getEulerAnglesZYX(rotation);
                stack.withRotation(new Vec2(rotation.x(), rotation.y()));
            }
            manager.execute(source, stack);
        });
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        return List.of();
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }

    @Override
    public MapCodec<? extends AbilityBlockEffect> blockCodec() {
        return CODEC;
    }
}

