/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.EffectModification;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record EffectModificationEffect(List<EffectModification> modifications) implements AbilityEntityEffect
{
    public static final MapCodec<EffectModificationEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EffectModification.CODEC.listOf().fieldOf("modifications").forGetter(EffectModificationEffect::modifications)).apply((Applicative)instance, EffectModificationEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            this.modifications.forEach(modification -> modification.apply(dragon, ability, (Entity)livingEntity));
        }
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity entity, boolean isAutoRemoval) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.modifications.forEach(modification -> {
                if (!isAutoRemoval || modification.shouldRemoveAutomatically()) {
                    modification.remove((Entity)livingEntity);
                }
            });
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (EffectModification modification : this.modifications) {
            components.add(modification.getDescription(ability.level()));
        }
        return components;
    }

    public static List<AbilityEntityEffect> only(EffectModification modification) {
        return List.of(new EffectModificationEffect(List.of(modification)));
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

