/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.common.codecs.PotionData;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record PotionEffect(PotionData potion) implements AbilityEntityEffect
{
    public static final MapCodec<PotionEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PotionData.CODEC.fieldOf("potion").forGetter(PotionEffect::potion)).apply((Applicative)instance, PotionEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        this.potion.apply(dragon, ability.level(), target);
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        return this.potion.getDescription(ability.level());
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability, Entity entity, boolean isAutoRemoval) {
        if (isAutoRemoval) {
            return;
        }
        this.potion.remove(dragon, entity);
    }

    public static List<AbilityEntityEffect> only(PotionData potion) {
        return List.of(new PotionEffect(potion));
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

