/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.ItemData;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record SmeltItemEffect(Optional<ItemPredicate> itemPredicate, Optional<LevelBasedValue> progress, boolean dropsExperience) implements AbilityEntityEffect
{
    @Translation(comments={"\u00a76\u25a0 Smelts items\u00a7r %s as fast as a furnace"})
    private static final String CUSTOM_SPEED = Translation.Type.GUI.wrap("smelting_effect.custom_speed");
    @Translation(comments={"\u00a76\u25a0 Smelts items\u00a7r at the speed of a furnace"})
    private static final String FURNACE_SPEED = Translation.Type.GUI.wrap("smelting_effect.furnace_speed");
    @Translation(comments={"\u00a76\u25a0 Smelts items\u00a7r instantly"})
    private static final String INSTANT = Translation.Type.GUI.wrap("smelting_effect.instant");
    public static final MapCodec<SmeltItemEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemPredicate.CODEC.optionalFieldOf("item_predicate").forGetter(SmeltItemEffect::itemPredicate), (App)LevelBasedValue.CODEC.optionalFieldOf("progress").forGetter(SmeltItemEffect::progress), (App)Codec.BOOL.optionalFieldOf("grants_experience", (Object)true).forGetter(SmeltItemEffect::dropsExperience)).apply((Applicative)instance, SmeltItemEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (!(target instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)target;
        ItemStack stack = itemEntity.getItem();
        if (this.itemPredicate.map(predicate -> !predicate.test(stack)).orElse(false).booleanValue()) {
            return;
        }
        RecipeHolder recipe = dragon.level().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), dragon.level()).orElse(null);
        if (recipe == null || ((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)dragon.registryAccess()).isEmpty()) {
            return;
        }
        if (this.progress.isPresent()) {
            ItemData data = (ItemData)itemEntity.getData(DSDataAttachments.ITEM);
            data.smeltingProgress += (double)this.progress.get().calculate(ability.level());
            data.smeltingTime = ((SmeltingRecipe)recipe.value()).getCookingTime() * stack.getCount();
            if (data.smeltingProgress < data.smeltingTime) {
                return;
            }
            data.smeltingProgress = 0.0;
        }
        ItemStack result = ((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)dragon.registryAccess());
        itemEntity.setItem(result.copyWithCount(result.getCount() * stack.getCount()));
        if (!this.dropsExperience) {
            return;
        }
        float experience = ((SmeltingRecipe)recipe.value()).getExperience() * (float)stack.getCount();
        if (experience > 0.0f) {
            dragon.giveExperiencePoints((int)experience);
        }
    }

    @Override
    public List<MutableComponent> getDescription(Player dragon, DragonAbilityInstance ability) {
        if (this.progress.isPresent()) {
            double progress = this.progress.get().calculate(ability.level());
            if (progress == 1.0) {
                return List.of(Component.translatable((String)FURNACE_SPEED));
            }
            return List.of(Component.translatable((String)CUSTOM_SPEED, (Object[])new Object[]{DSColors.dynamicValue(NumberFormat.getPercentInstance().format(progress))}));
        }
        return List.of(Component.translatable((String)INSTANT));
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

