/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects;

import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.entity_effects.AbilityEntityEffect;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record UseItemOnLivingEntityEffect(ItemStack item, LevelBasedValue probability, Optional<Holder<SoundEvent>> sound, Optional<EntityPredicate> validEntities) implements AbilityEntityEffect
{
    public static final MapCodec<UseItemOnLivingEntityEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(UseItemOnLivingEntityEffect::item), (App)LevelBasedValue.CODEC.fieldOf("probability").forGetter(UseItemOnLivingEntityEffect::probability), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(UseItemOnLivingEntityEffect::sound), (App)EntityPredicate.CODEC.optionalFieldOf("valid_entities").forGetter(UseItemOnLivingEntityEffect::validEntities)).apply((Applicative)instance, UseItemOnLivingEntityEffect::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability, Entity target) {
        if (target instanceof LivingEntity) {
            InteractionResult ir;
            LivingEntity livingEntity = (LivingEntity)target;
            if (dragon.getRandom().nextDouble() > (double)this.probability().calculate(ability.level())) {
                return;
            }
            if ((double)this.probability.calculate(ability.level()) < dragon.getRandom().nextDouble()) {
                return;
            }
            ServerLevel level = dragon.serverLevel();
            if ((this.validEntities.isEmpty() || this.validEntities.get().matches(level, dragon.position(), target)) && (ir = this.item.getItem().interactLivingEntity(this.item, (Player)dragon, livingEntity, InteractionHand.MAIN_HAND)).consumesAction()) {
                this.sound.ifPresent(soundHolder -> dragon.level().playSound(null, target, (SoundEvent)soundHolder.value(), SoundSource.BLOCKS, 1.0f, 1.0f));
            }
        }
    }

    @Override
    public MapCodec<? extends AbilityEntityEffect> entityCodec() {
        return CODEC;
    }
}

