/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting;

import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.lang.DSLanguageProvider;
import com.mojang.serialization.Codec;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public enum TargetingMode implements StringRepresentable
{
    ALL("all"),
    ALLIES("allies"),
    ALLIES_AND_SELF("allies_and_self"),
    NON_ALLIES("non_allies"),
    NON_ENEMIES("non_enemies"),
    NEUTRAL("neutral"),
    ENEMIES("enemies"),
    ITEMS("items"),
    ALL_EXCEPT_SELF("all_except_self");

    @Translation(key="player_targeting_handling", type=Translation.Type.CONFIGURATION, comments={"Determines how players are handled for the initial targeting of abilities", "The flags can be combined, e.g. '3' combines the flags '1' and '2'", "0: No special handling (players are allies on the same team, otherwise they count as 'neutral')", "1: They are always considered as 'ally'", "2: They are always considered as 'enemy' (unless they're on the same team without friendly fire enabled)", "4: Enabled Friendly fire on a team no longer flags players as 'enemy'"})
    @ConfigOption(side=ConfigSide.SERVER, category={"abilities"}, key="player_targeting_handling")
    public static int PLAYER_FLAG;
    public static final Codec<TargetingMode> CODEC;
    private final String name;
    private static final int ALWAYS_ALLY = 1;
    private static final int ALWAYS_ENEMY = 2;
    private static final int SAFE_IN_TEAM = 4;

    private TargetingMode(String name) {
        this.name = name;
    }

    public boolean isEntityRelevant(Player player, Entity target) {
        if (this == ALL) {
            return true;
        }
        if (player == target) {
            return this == ALLIES_AND_SELF || this == NON_ENEMIES;
        }
        if (target instanceof ItemEntity) {
            return this == ITEMS;
        }
        if (this.isFriendly(player, target)) {
            return this == ALLIES_AND_SELF || this == ALLIES || this == NON_ENEMIES || this == ALL_EXCEPT_SELF;
        }
        if (this.isEnemy(player, target)) {
            return this == ENEMIES || this == NON_ALLIES || this == ALL_EXCEPT_SELF;
        }
        return this == NEUTRAL || this == NON_ALLIES || this == NON_ENEMIES || this == ALL_EXCEPT_SELF;
    }

    private boolean isFriendly(Player player, Entity target) {
        if (target instanceof Player && (PLAYER_FLAG & 1) != 0) {
            return true;
        }
        return target.isAlliedTo((Entity)player);
    }

    private boolean isEnemy(Player player, Entity target) {
        Mob mob;
        if (target instanceof Enemy || target.getType().getCategory() == MobCategory.MONSTER) {
            return true;
        }
        if (target instanceof Mob && (mob = (Mob)target).getTarget() == player) {
            return true;
        }
        if (target instanceof Player) {
            Player otherPlayer = (Player)target;
            if ((PLAYER_FLAG & 2) != 0) {
                boolean canHarmPlayer = player.canHarmPlayer(otherPlayer);
                if (!canHarmPlayer) {
                    return false;
                }
                return !player.isAlliedTo((Entity)otherPlayer) || (PLAYER_FLAG & 4) == 0;
            }
        }
        return false;
    }

    public Component translation() {
        return DSLanguageProvider.enumValue(this);
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        PLAYER_FLAG = 0;
        CODEC = StringRepresentable.fromEnum(TargetingMode::values);
    }
}

