/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.body;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modifier;
import by.dragonsurvivalteam.dragonsurvival.registry.DSAttributes;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.DragonBody;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmoteSet;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmoteSets;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;

public class DragonBodies {
    @Translation.Translations(value={@Translation(type=Translation.Type.BODY_DESCRIPTION, comments={"\u00a76\u25a0 Central Type\u00a7r", "\u25a0 Inhabitants of all biomes, and the most common type of dragon. They are the most balanced type of dragon, having no particular strengths or weaknesses."}), @Translation(type=Translation.Type.BODY, comments={"Center"}), @Translation(type=Translation.Type.BODY_WINGS, comments={"Show wings"}), @Translation(type=Translation.Type.BODY_WINGS_DESCRIPTION, comments={"Show wings"})})
    public static final ResourceKey<DragonBody> CENTER = DragonBodies.key("center");
    @Translation.Translations(value={@Translation(type=Translation.Type.BODY_DESCRIPTION, comments={"\u00a76\u25a0 Eastern Type\u00a7r", "\u25a0 Adapted to life in caves, they lack large wings, reducing the effectiveness of their levitation magic, but they are still excellent swimmers. They have a larger supply of mana, and natural armor."}), @Translation(type=Translation.Type.BODY, comments={"East"}), @Translation(type=Translation.Type.BODY_WINGS, comments={"Show wings"}), @Translation(type=Translation.Type.BODY_WINGS_DESCRIPTION, comments={"Show wings"})})
    public static final ResourceKey<DragonBody> EAST = DragonBodies.key("east");
    @Translation.Translations(value={@Translation(type=Translation.Type.BODY_DESCRIPTION, comments={"\u00a76\u25a0 Northern Type\u00a7r", "\u25a0 Perfect travelers, conquering water, lava and air. They are slower on the ground and weaker physically, but are magically adept and excel at swimming. Their flat bodies allow them to go places other dragons cannot."}), @Translation(type=Translation.Type.BODY, comments={"North"}), @Translation(type=Translation.Type.BODY_WINGS, comments={"Show wings"}), @Translation(type=Translation.Type.BODY_WINGS_DESCRIPTION, comments={"Show wings"})})
    public static final ResourceKey<DragonBody> NORTH = DragonBodies.key("north");
    @Translation.Translations(value={@Translation(type=Translation.Type.BODY_DESCRIPTION, comments={"\u00a76\u25a0 Southern Type\u00a7r", "\u25a0 They are adapted to life on the plains, capable of running swiftly, and leaping high into the air. The special structure of their paws gives them many advantages on the ground, and they are physically strong, but they will struggle at flight and swimming."}), @Translation(type=Translation.Type.BODY, comments={"South"}), @Translation(type=Translation.Type.BODY_WINGS, comments={"Show wings"}), @Translation(type=Translation.Type.BODY_WINGS_DESCRIPTION, comments={"Show wings"})})
    public static final ResourceKey<DragonBody> SOUTH = DragonBodies.key("south");
    @Translation.Translations(value={@Translation(type=Translation.Type.BODY_DESCRIPTION, comments={"\u00a76\u25a0 Western Type\u00a7r", "\u25a0 Conquerors of mountain and sky, they are unrivalled in their element, but are rather clumsy on the ground."}), @Translation(type=Translation.Type.BODY, comments={"West"}), @Translation(type=Translation.Type.BODY_WINGS, comments={"Show wings"}), @Translation(type=Translation.Type.BODY_WINGS_DESCRIPTION, comments={"Show wings"})})
    public static final ResourceKey<DragonBody> WEST = DragonBodies.key("west");
    private static final DragonBody.MountingOffsets DEFAULT_MOUNTING_OFFSETS = DragonBody.MountingOffsets.of(new Vec3(0.0, -0.15, -0.5), new Vec3(0.0, 0.05, -0.5), new Vec3(0.0, -0.25, -0.5));

    public static void registerBodies(BootstrapContext<DragonBody> context) {
        context.register(CENTER, (Object)new DragonBody(true, Optional.empty(), List.of(Modifier.constant(DSAttributes.FLIGHT_SPEED, 0.2f, AttributeModifier.Operation.ADD_VALUE)), false, DragonBody.DEFAULT_MODEL, new DragonBody.TextureSize(512, 512), DragonSurvival.res("dragon_center"), Optional.of(DragonSurvival.res("textures/gui/custom/body/center/default.png")), List.of("WingLeft", "WingRight", "SmallWingLeft", "SmallWingRight"), (Holder<DragonEmoteSet>)context.lookup(DragonEmoteSet.REGISTRY).getOrThrow(DragonEmoteSets.DEFAULT_EMOTES), DragonBody.ScalingProportions.of(0.6, 2.0, 1.8, 1.0, 1.0), 0.83333333, Optional.of(DEFAULT_MOUNTING_OFFSETS), Optional.of(DragonBody.BackpackOffsets.of(Vec3.ZERO, Vec3.ZERO, new Vec3(0.9, 0.9, 0.9))), -3.0));
        context.register(EAST, (Object)new DragonBody(true, Optional.empty(), List.of(Modifier.constant((Holder<Attribute>)Attributes.ARMOR, 2.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.ATTACK_DAMAGE, -1.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, -1.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, 2.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.GRAVITY, 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), Modifier.constant((Holder<Attribute>)Attributes.JUMP_STRENGTH, 0.1f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), Modifier.constant((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, 0.5f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.MANA, 2.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.FLIGHT_SPEED, -0.2f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.FLIGHT_STAMINA_COST, -0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)), true, DragonBody.DEFAULT_MODEL, new DragonBody.TextureSize(512, 512), DragonSurvival.res("dragon_east"), Optional.of(DragonSurvival.res("textures/gui/custom/body/east/default.png")), List.of("WingLeft", "WingRight", "SmallWingLeft", "SmallWingRight"), (Holder<DragonEmoteSet>)context.lookup(DragonEmoteSet.REGISTRY).getOrThrow(DragonEmoteSets.DEFAULT_EMOTES), DragonBody.ScalingProportions.of(0.6, 2.0, 1.8, 1.0, 1.0), 0.83333333, Optional.of(DEFAULT_MOUNTING_OFFSETS), Optional.of(DragonBody.BackpackOffsets.of(new Vec3(0.0, -6.5, 0.0), Vec3.ZERO, new Vec3(0.9, 0.9, 0.9))), -3.0));
        context.register(NORTH, (Object)new DragonBody(true, Optional.empty(), List.of(Modifier.constant((Holder<Attribute>)Attributes.ATTACK_DAMAGE, -0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), Modifier.constant((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, -0.5f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.MOVEMENT_SPEED, -0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), Modifier.constant((Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, 1.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, 0.8f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.MANA, 2.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.FLIGHT_STAMINA_COST, -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)), true, DragonBody.DEFAULT_MODEL, new DragonBody.TextureSize(512, 512), DragonSurvival.res("dragon_north"), Optional.of(DragonSurvival.res("textures/gui/custom/body/north/default.png")), List.of("WingLeft", "WingRight", "SmallWingLeft", "SmallWingRight"), (Holder<DragonEmoteSet>)context.lookup(DragonEmoteSet.REGISTRY).getOrThrow(DragonEmoteSets.DEFAULT_EMOTES), DragonBody.ScalingProportions.of(0.6, 1.1, 0.99, 1.0, 1.0), 0.5, Optional.of(DEFAULT_MOUNTING_OFFSETS), Optional.of(DragonBody.BackpackOffsets.of(Vec3.ZERO, Vec3.ZERO, new Vec3(0.85, 0.85, 0.85))), 8.0));
        context.register(SOUTH, (Object)new DragonBody(true, Optional.empty(), List.of(Modifier.constant((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 0.5f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.GRAVITY, 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), Modifier.constant((Holder<Attribute>)Attributes.JUMP_STRENGTH, 0.2f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.MOVEMENT_SPEED, 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), Modifier.constant((Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, 2.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, -0.2f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.FLIGHT_SPEED, -0.2f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.FLIGHT_STAMINA_COST, -0.5f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)), true, DragonBody.DEFAULT_MODEL, new DragonBody.TextureSize(512, 512), DragonSurvival.res("dragon_south"), Optional.of(DragonSurvival.res("textures/gui/custom/body/south/default.png")), List.of("WingLeft", "WingRight", "SmallWingLeft", "SmallWingRight"), (Holder<DragonEmoteSet>)context.lookup(DragonEmoteSet.REGISTRY).getOrThrow(DragonEmoteSets.DEFAULT_EMOTES), DragonBody.ScalingProportions.of(0.6, 2.0, 1.8, 1.0, 1.0), 0.83333333, Optional.of(DEFAULT_MOUNTING_OFFSETS), Optional.of(DragonBody.BackpackOffsets.of(new Vec3(0.0, -6.5, 0.0), Vec3.ZERO, new Vec3(0.9, 0.9, 0.9))), -3.0));
        context.register(WEST, (Object)new DragonBody(true, Optional.empty(), List.of(Modifier.constant((Holder<Attribute>)Attributes.ATTACK_KNOCKBACK, 0.5f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, 0.15f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)Attributes.MOVEMENT_SPEED, -0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), Modifier.constant((Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, 1.0f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, -0.2f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.FLIGHT_SPEED, 0.2f, AttributeModifier.Operation.ADD_VALUE), Modifier.constant(DSAttributes.FLIGHT_STAMINA_COST, 1.0f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)), false, DragonBody.DEFAULT_MODEL, new DragonBody.TextureSize(512, 512), DragonSurvival.res("dragon_west"), Optional.of(DragonSurvival.res("textures/gui/custom/body/west/default.png")), List.of("WingLeft", "WingRight", "SmallWingLeft", "SmallWingRight"), (Holder<DragonEmoteSet>)context.lookup(DragonEmoteSet.REGISTRY).getOrThrow(DragonEmoteSets.DEFAULT_EMOTES), DragonBody.ScalingProportions.of(0.6, 2.0, 1.8, 1.0, 1.0), 0.83333333, Optional.of(DEFAULT_MOUNTING_OFFSETS), Optional.of(DragonBody.BackpackOffsets.of(new Vec3(0.0, 3.2, 0.0), Vec3.ZERO, new Vec3(0.9, 0.9, 0.9))), -3.0));
    }

    public static ResourceKey<DragonBody> key(ResourceLocation location) {
        return ResourceKey.create(DragonBody.REGISTRY, (ResourceLocation)location);
    }

    private static ResourceKey<DragonBody> key(String path) {
        return DragonBodies.key(DragonSurvival.res(path));
    }
}

