/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public record DragonEmote(String animationKey, Optional<String> translationOverride, double speed, int duration, boolean loops, boolean blend, boolean locksHead, boolean locksTail, boolean thirdPerson, boolean canMove, Optional<Sound> sound) {
    public static final double DEFAULT_SPEED = 1.0;
    public static final int NO_DURATION = -1;
    public static final Codec<DragonEmote> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("animation_key").forGetter(DragonEmote::animationKey), (App)Codec.STRING.optionalFieldOf("translation_override").forGetter(DragonEmote::translationOverride), (App)Codec.DOUBLE.optionalFieldOf("speed", (Object)1.0).forGetter(DragonEmote::speed), (App)Codec.INT.optionalFieldOf("duration", (Object)-1).forGetter(DragonEmote::duration), (App)Codec.BOOL.optionalFieldOf("loops", (Object)false).forGetter(DragonEmote::loops), (App)Codec.BOOL.optionalFieldOf("blend", (Object)false).forGetter(DragonEmote::blend), (App)Codec.BOOL.optionalFieldOf("locks_head", (Object)false).forGetter(DragonEmote::locksHead), (App)Codec.BOOL.optionalFieldOf("locks_tail", (Object)false).forGetter(DragonEmote::locksTail), (App)Codec.BOOL.optionalFieldOf("third_person", (Object)false).forGetter(DragonEmote::thirdPerson), (App)Codec.BOOL.optionalFieldOf("can_move", (Object)false).forGetter(DragonEmote::canMove), (App)Sound.CODEC.optionalFieldOf("sound").forGetter(DragonEmote::sound)).apply((Applicative)instance, DragonEmote::new));
    public static final StreamCodec<ByteBuf, DragonEmote> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public Component name() {
        return Component.translatable((String)Translation.Type.EMOTE.wrap(this.translationOverride.orElse(this.animationKey)));
    }

    public String key() {
        return this.translationOverride.orElse(this.animationKey);
    }

    public record Sound(SoundEvent soundEvent, float volume, float pitch, int interval) {
        public static final float DEFAULT_VOLUME = 1.0f;
        public static final float DEFAULT_PITCH = 1.0f;
        public static final Codec<Sound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("sound_event").forGetter(Sound::soundEvent), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(Sound::volume), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(Sound::pitch), (App)Codec.INT.fieldOf("interval").forGetter(Sound::interval)).apply((Applicative)instance, Sound::new));

        public void playSound(Player player) {
            player.level().playLocalSound(player.position().x, player.position().y, player.position().z, this.soundEvent, SoundSource.PLAYERS, this.volume, this.pitch, false);
        }
    }

    public static class Builder {
        private String animationKey;
        private String translationOverride;
        private double speed = 1.0;
        private int duration = -1;
        private Sound sound;
        private boolean loops;
        private boolean blend;
        private boolean locksHead;
        private boolean locksTail;
        private boolean thirdPerson;
        private boolean canMove;

        public static Builder of(String animationKey) {
            return Builder.of(animationKey, null);
        }

        public static Builder of(String animationKey, String translationOverride) {
            Builder builder = new Builder();
            builder.animationKey = animationKey;
            builder.translationOverride = translationOverride;
            return builder;
        }

        public Builder speed(double speed) {
            this.speed = speed;
            return this;
        }

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder sound(SoundEvent sound, int interval) {
            return this.sound(sound, interval, 1.0f, 1.0f);
        }

        public Builder sound(SoundEvent sound, int interval, float volume, float pitch) {
            this.sound = new Sound(sound, volume, pitch, interval);
            return this;
        }

        public Builder loops() {
            this.loops = true;
            return this;
        }

        public Builder blend() {
            this.blend = true;
            return this;
        }

        public Builder locksHead() {
            this.locksHead = true;
            return this;
        }

        public Builder locksTail() {
            this.locksTail = true;
            return this;
        }

        public Builder thirdPerson() {
            this.thirdPerson = true;
            return this;
        }

        public Builder canMove() {
            this.canMove = true;
            return this;
        }

        public DragonEmote build() {
            return new DragonEmote(this.animationKey, Optional.ofNullable(this.translationOverride), this.speed, this.duration, this.loops, this.blend, this.locksHead, this.locksTail, this.thirdPerson, this.canMove, Optional.ofNullable(this.sound));
        }
    }
}

