/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Condition;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncAddPenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncRemovePenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.DSDataAttachments;
import by.dragonsurvivalteam.dragonsurvival.registry.attachments.PenaltySupply;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyEffect;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.PenaltyTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.penalty.SupplyTrigger;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@EventBusSubscriber
public record DragonPenalty(Optional<ResourceLocation> icon, Optional<LootItemCondition> condition, PenaltyEffect effect, PenaltyTrigger trigger) {
    public static final Codec<DragonPenalty> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf("icon").forGetter(DragonPenalty::icon), (App)LootItemCondition.DIRECT_CODEC.optionalFieldOf("condition").forGetter(DragonPenalty::condition), (App)PenaltyEffect.CODEC.fieldOf("effect").forGetter(DragonPenalty::effect), (App)PenaltyTrigger.CODEC.fieldOf("trigger").forGetter(DragonPenalty::trigger)).apply((Applicative)instance, DragonPenalty::new));
    public static final ResourceKey<Registry<DragonPenalty>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("dragon_penalty"));
    public static final Codec<Holder<DragonPenalty>> CODEC = RegistryFixedCodec.create(REGISTRY);

    public void apply(ServerPlayer dragon, Holder<DragonPenalty> penalty) {
        PenaltySupply penaltySupply = (PenaltySupply)dragon.getData(DSDataAttachments.PENALTY_SUPPLY);
        PenaltyTrigger penaltyTrigger = this.trigger;
        if (penaltyTrigger instanceof SupplyTrigger) {
            int resistanceTime;
            SupplyTrigger supplyTrigger = (SupplyTrigger)penaltyTrigger;
            AttributeInstance resistance = dragon.getAttribute(supplyTrigger.attributeToUseAsBase());
            int n = resistanceTime = resistance != null ? (int)resistance.getValue() : 0;
            if (penaltySupply.getMaxSupply(supplyTrigger.supplyType()) != resistanceTime) {
                float currentSupply = penaltySupply.hasSupply(supplyTrigger.supplyType()) ? penaltySupply.getRawSupply(supplyTrigger.supplyType()) : (float)resistanceTime;
                penaltySupply.initialize(supplyTrigger.supplyType(), resistanceTime, supplyTrigger.reductionRate(), supplyTrigger.regenerationRate(), currentSupply);
                PacketDistributor.sendToPlayer((ServerPlayer)dragon, (CustomPacketPayload)new SyncAddPenaltySupply(supplyTrigger.supplyType(), resistanceTime, supplyTrigger.reductionRate(), supplyTrigger.regenerationRate(), currentSupply), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (this.trigger.matches(dragon, this.condition.map(condition -> condition.test((Object)Condition.penaltyContext(dragon))).orElse(true))) {
            this.effect.apply(dragon, penalty);
        }
    }

    public void remove(ServerPlayer dragon) {
        PenaltySupply supply = (PenaltySupply)dragon.getData(DSDataAttachments.PENALTY_SUPPLY);
        PenaltyTrigger penaltyTrigger = this.trigger;
        if (penaltyTrigger instanceof SupplyTrigger) {
            SupplyTrigger supplyTrigger = (SupplyTrigger)penaltyTrigger;
            supply.remove(supplyTrigger.supplyType());
            PacketDistributor.sendToPlayer((ServerPlayer)dragon, (CustomPacketPayload)new SyncRemovePenaltySupply(supplyTrigger.supplyType()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public MutableComponent getDescription(Player dragon) {
        MutableComponent description = this.trigger.getDescription(dragon);
        if (description.getContents() == PlainTextContents.EMPTY) {
            return description;
        }
        return this.effect.getDescription().append((Component)description);
    }

    @SubscribeEvent
    public static void register(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(REGISTRY, DIRECT_CODEC, DIRECT_CODEC);
    }
}

