/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.GrowthItem;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.MiscCodecs;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modifier;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ModifierType;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.AttributeModifierSupplier;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.stage.DragonStages;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public record DragonStage(boolean isDefault, MiscCodecs.Bounds growthRange, int ticksUntilGrown, List<Modifier> modifiers, List<GrowthItem> growthItems, Optional<EntityPredicate> isNaturalGrowthStopped, Optional<MiscCodecs.DestructionData> destructionData) implements AttributeModifierSupplier
{
    public static final ResourceKey<Registry<DragonStage>> REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)DragonSurvival.res("dragon_stage"));
    public static final Codec<DragonStage> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_default", (Object)false).forGetter(DragonStage::isDefault), (App)MiscCodecs.bounds().fieldOf("growth_range").forGetter(DragonStage::growthRange), (App)ExtraCodecs.intRange((int)1, (int)Functions.daysToTicks(365.0)).fieldOf("ticks_until_grown").forGetter(DragonStage::ticksUntilGrown), (App)Modifier.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(DragonStage::modifiers), (App)GrowthItem.CODEC.listOf().optionalFieldOf("growth_items", List.of()).forGetter(DragonStage::growthItems), (App)EntityPredicate.CODEC.optionalFieldOf("is_natural_growth_stopped").forGetter(DragonStage::isNaturalGrowthStopped), (App)MiscCodecs.DestructionData.CODEC.optionalFieldOf("destruction_data").forGetter(DragonStage::destructionData)).apply((Applicative)instance, instance.stable(DragonStage::new)));
    public static final Codec<Holder<DragonStage>> CODEC = RegistryFixedCodec.create(REGISTRY);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DragonStage>> STREAM_CODEC = ByteBufCodecs.holderRegistry(REGISTRY);
    @Nullable
    private static HolderSet<DragonStage> defaultStages;
    private static double minGrowth;
    private static double maxGrowth;

    public static void update(RegistryAccess access) {
        Pair<Double, Double> sizes = DragonStage.calculateGrowthBounds((HolderLookup.Provider)access);
        minGrowth = (Double)sizes.getFirst();
        maxGrowth = (Double)sizes.getSecond();
        defaultStages = null;
        DragonStage.validate(access);
    }

    private static void validate(RegistryAccess access) {
        boolean areBuiltInLevelsValid = true;
        StringBuilder builtInCheck = new StringBuilder("The following required built-in dragon levels are missing:");
        areBuiltInLevelsValid = areBuiltInLevelsValid && DragonStage.isValid(builtInCheck, (HolderLookup.Provider)access, DragonStages.newborn);
        areBuiltInLevelsValid = areBuiltInLevelsValid && DragonStage.isValid(builtInCheck, (HolderLookup.Provider)access, DragonStages.young);
        boolean bl = areBuiltInLevelsValid = areBuiltInLevelsValid && DragonStage.isValid(builtInCheck, (HolderLookup.Provider)access, DragonStages.adult);
        if (!areBuiltInLevelsValid) {
            throw new IllegalStateException(builtInCheck.toString());
        }
        StringBuilder validationError = new StringBuilder("The following stages are incorrectly defined:");
        AtomicBoolean areStagesValid = new AtomicBoolean(true);
        ResourceHelper.keys((HolderLookup.Provider)access, REGISTRY).forEach(key -> {
            Holder.Reference stage = ResourceHelper.get((HolderLookup.Provider)access, key).get();
            if (((DragonStage)stage.value()).destructionData().isPresent()) {
                MiscCodecs.DestructionData destructionData = ((DragonStage)stage.value()).destructionData().get();
                if (destructionData.blockDestructionGrowth() > ((DragonStage)stage.value()).growthRange().max() || destructionData.blockDestructionGrowth() < ((DragonStage)stage.value()).growthRange().min()) {
                    validationError.append("\n- Block destruction growth of [").append(key.location()).append("] is not within the bounds of the dragon stage");
                    areStagesValid.set(false);
                }
                if (destructionData.crushingGrowth() > ((DragonStage)stage.value()).growthRange().max() || destructionData.crushingGrowth() < ((DragonStage)stage.value()).growthRange().min()) {
                    validationError.append("\n- Crushing growth of [").append(key.location()).append("] is not within the bounds of the dragon stage");
                    areStagesValid.set(false);
                }
            }
        });
        HolderSet<DragonStage> defaultStages = DragonStage.getDefaultStages((HolderLookup.Provider)access);
        HolderSet.Direct sortedDefaultStages = HolderSet.direct(defaultStages.stream().sorted(Comparator.comparingDouble(stage -> ((DragonStage)stage.value()).growthRange().min())).toList());
        if (!DragonStage.areStagesConnected((HolderSet<DragonStage>)sortedDefaultStages, validationError, true)) {
            areStagesValid.set(false);
        }
        if (!areStagesValid.get()) {
            throw new IllegalStateException(validationError.toString());
        }
    }

    public static boolean areStagesConnected(HolderSet<DragonStage> sortedStages, StringBuilder error, boolean isForDefaultStages) {
        for (int i = 0; i < sortedStages.size() - 1; ++i) {
            if (((DragonStage)sortedStages.get(i).value()).growthRange().max() == ((DragonStage)sortedStages.get(i + 1).value()).growthRange().min()) continue;
            error.append(isForDefaultStages ? "\n- Default stages [" : "\n- Stages [").append(sortedStages.get(i).getRegisteredName()).append("] and [").append(sortedStages.get(i + 1).getRegisteredName()).append("] are not connected");
            return false;
        }
        return true;
    }

    private static boolean isValid(StringBuilder builder, @Nullable HolderLookup.Provider provider, ResourceKey<DragonStage> stageKey) {
        Optional<Holder.Reference<DragonStage>> optional = ResourceHelper.get(provider, stageKey);
        if (optional.isPresent()) {
            return true;
        }
        builder.append("\n- ").append(stageKey.location());
        return false;
    }

    public double ticksToGrowth(int ticks) {
        return (this.growthRange().max() - this.growthRange().min()) / (double)this.ticksUntilGrown() * (double)ticks;
    }

    public double getProgress(double growth) {
        return (growth - this.growthRange().min()) / (this.growthRange().max() - this.growthRange().min());
    }

    @SubscribeEvent
    public static void register(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(REGISTRY, DIRECT_CODEC, DIRECT_CODEC);
    }

    public static Component translatableName(ResourceKey<DragonStage> dragonStage) {
        return Component.translatable((String)Translation.Type.STAGE.wrap(dragonStage.location()));
    }

    public double getBoundedGrowth(double growth) {
        return Math.clamp(growth, this.growthRange().min(), this.growthRange().max());
    }

    public static MiscCodecs.Bounds getBounds() {
        return new MiscCodecs.Bounds(minGrowth, maxGrowth);
    }

    public static double getStartingGrowth(HolderSet<DragonStage> stages) {
        return stages.stream().min(Comparator.comparingDouble(stage -> ((DragonStage)stage.value()).growthRange().min())).map(stage -> ((DragonStage)stage.value()).growthRange().min()).orElse(-1.0);
    }

    public static Holder<DragonStage> get(HolderSet<DragonStage> stages, double growth) {
        Holder smallest = null;
        Holder largest = null;
        for (Holder stage : stages) {
            if (((DragonStage)stage.value()).growthRange().matches(growth) && ((DragonStage)stage.value()).growthRange().max() != growth) {
                return stage;
            }
            if (smallest == null || ((DragonStage)stage.value()).growthRange().min() < ((DragonStage)smallest.value()).growthRange().min()) {
                smallest = stage;
            }
            if (largest != null && !(((DragonStage)stage.value()).growthRange().min() > ((DragonStage)largest.value()).growthRange().min())) continue;
            largest = stage;
        }
        if (growth <= ((DragonStage)smallest.value()).growthRange().min()) {
            return smallest;
        }
        return largest;
    }

    public static Holder<DragonStage> get(@Nullable HolderLookup.Provider provider, double growth) {
        double fallbackDifference = Double.MAX_VALUE;
        Holder.Reference<DragonStage> fallback = null;
        for (Holder.Reference<DragonStage> level : ResourceHelper.all(provider, REGISTRY)) {
            if (((DragonStage)level.value()).growthRange().matches(growth)) {
                return level;
            }
            double difference = Math.abs(((DragonStage)level.value()).growthRange().min() - growth);
            if (fallback != null && !(difference < fallbackDifference)) continue;
            fallbackDifference = difference;
            fallback = level;
        }
        if (fallback != null) {
            DragonSurvival.LOGGER.warn("No matching dragon level found for growth [{}] - using [{}] as fallback", (Object)growth, (Object)fallback.getRegisteredName());
            return fallback;
        }
        throw new IllegalStateException("There is no valid dragon level for the supplied growth [" + growth + "]");
    }

    private static Pair<Double, Double> calculateGrowthBounds(@Nullable HolderLookup.Provider provider) {
        DragonStage smallest = null;
        DragonStage largest = null;
        for (Holder.Reference<DragonStage> level : ResourceHelper.all(provider, REGISTRY)) {
            if (smallest == null || ((DragonStage)level.value()).growthRange().min() < smallest.growthRange().min()) {
                smallest = (DragonStage)level.value();
            }
            if (largest != null && !(((DragonStage)level.value()).growthRange().max() > largest.growthRange().max())) continue;
            largest = (DragonStage)level.value();
        }
        return Pair.of((Object)smallest.growthRange.min(), (Object)largest.growthRange.max());
    }

    public static HolderSet<DragonStage> getDefaultStages(@Nullable HolderLookup.Provider provider) {
        if (defaultStages == null) {
            defaultStages = HolderSet.direct(ResourceHelper.all(provider, REGISTRY).stream().filter(stage -> ((DragonStage)stage.value()).isDefault()).toList());
        }
        return defaultStages;
    }

    public String getTimeToGrowFormattedWithPercentage(double percentage, double size, boolean isGrowing) {
        Object ageInformation = NumberFormat.getPercentInstance().format(percentage);
        if (!isGrowing) {
            return (String)ageInformation + " (\u00a74--:--:--\u00a7r)";
        }
        double sizeToTicks = (this.growthRange().max() - this.growthRange().min()) / (double)this.ticksUntilGrown();
        double missingSize = this.growthRange().max() - size;
        Functions.Time time = Functions.Time.fromTicks((int)(missingSize / sizeToTicks));
        if (time.hasTime()) {
            ageInformation = (String)ageInformation + " (" + time.format() + ")";
        }
        return ageInformation;
    }

    public String getTimeToGrowFormatted(boolean growthStopped) {
        if (growthStopped) {
            return "\u00a74--:--:--\u00a7r";
        }
        Functions.Time time = Functions.Time.fromTicks(this.ticksUntilGrown());
        return time.format();
    }

    @Override
    public ModifierType getModifierType() {
        return ModifierType.DRAGON_STAGE;
    }
}

