/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.SyncComplete;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public class ServerPlayerStatusSync {
    private static final int SYNC_RATE = Functions.secondsToTicks(600.0);

    @SubscribeEvent
    public static void onServerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (!player.isAddedToLevel() || !player.isAlive()) {
            return;
        }
        DragonStateHandler data = DragonStateProvider.getData(player);
        if (data.isDragon() && player.tickCount >= data.lastSync + SYNC_RATE) {
            data.lastSync = player.tickCount;
            PacketDistributor.sendToPlayersTrackingEntity((Entity)player, (CustomPacketPayload)new SyncComplete(player.getId(), data.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

