/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.client.models.DragonModel;
import by.dragonsurvivalteam.dragonsurvival.mixins.client.AnimationControllerAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.loading.object.BakedAnimations;

public class AnimationUtils {
    private static final float MS_FOR_60FPS = 16.666668f;

    public static <E extends GeoAnimatable> void setAnimationSpeed(double speed, double currentAnimationTick, AnimationController<E> controller) {
        if (speed == controller.getAnimationSpeed()) {
            return;
        }
        if (controller.getCurrentAnimation() != null) {
            double distance = currentAnimationTick - ((AnimationControllerAccessor)controller).dragonSurvival$getTickOffset();
            ((AnimationControllerAccessor)controller).dragonSurvival$setTickOffset(currentAnimationTick - distance * (controller.getAnimationSpeed() / speed));
            controller.setAnimationSpeed(speed);
        }
    }

    public static boolean isAnimationPlaying(AnimationController<?> controller, RawAnimation animation) {
        String animationName = ((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName();
        return controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animation().name().equals(animationName);
    }

    public static double getMovementSpeed(LivingEntity of) {
        return Math.sqrt(Math.pow(of.getX() - of.xo, 2.0) + Math.pow(of.getZ() - of.zo, 2.0));
    }

    public static float getDeltaTickFor60FPS() {
        float deltaTick = Minecraft.getInstance().getTimer().getRealtimeDeltaTicks();
        return deltaTick / (16.666668f / Minecraft.getInstance().level.tickRateManager().millisecondsPerTick());
    }

    public static float getDeltaSeconds() {
        return Minecraft.getInstance().getTimer().getRealtimeDeltaTicks() * Minecraft.getInstance().level.tickRateManager().millisecondsPerTick() / 1000.0f;
    }

    public static boolean doesAnimationExist(Player player, String animation) {
        BakedAnimations bakedAnimations = (BakedAnimations)GeckoLibCache.getBakedAnimations().get(DragonModel.getAnimationResource(player));
        if (bakedAnimations == null) {
            return false;
        }
        return bakedAnimations.getAnimation(animation) != null;
    }

    public static boolean doesAnimationExist(Player player, RawAnimation animation) {
        assert (animation.getAnimationStages().size() == 1);
        return AnimationUtils.doesAnimationExist(player, ((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName());
    }

    public static double animationDuration(Player player, String animation) {
        if (!AnimationUtils.doesAnimationExist(player, animation)) {
            return 0.0;
        }
        return ((BakedAnimations)GeckoLibCache.getBakedAnimations().get(DragonModel.getAnimationResource(player))).getAnimation(animation).length();
    }

    public static double animationDuration(Player player, RawAnimation animation) {
        assert (animation.getAnimationStages().size() == 1);
        return AnimationUtils.animationDuration(player, ((RawAnimation.Stage)animation.getAnimationStages().getFirst()).animationName());
    }
}

