/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvival;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.Modifier;
import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.util.DSColors;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.Tags;
import software.bernie.geckolib.util.RenderUtil;

public class Functions {
    public static int daysToTicks(double days) {
        return Functions.hoursToTicks(days) * 24;
    }

    public static int hoursToTicks(double hours) {
        return Functions.minutesToTicks(hours) * 60;
    }

    public static int minutesToTicks(double minutes) {
        return Functions.secondsToTicks(minutes) * 60;
    }

    public static int secondsToTicks(double seconds) {
        return (int)(seconds * 20.0);
    }

    public static double ticksToHours(int ticks) {
        return Functions.ticksToMinutes(ticks) / 60.0;
    }

    public static double ticksToMinutes(int ticks) {
        return Functions.ticksToSeconds(ticks) / 60.0;
    }

    public static double ticksToSeconds(int ticks) {
        return (double)ticks / 20.0;
    }

    public static boolean chance(Player player, int chance) {
        return Functions.chance(player.getRandom(), chance);
    }

    public static boolean chance(RandomSource random, int chance) {
        return 1 + random.nextInt(100) < chance;
    }

    public static float angleDifference(float a, float b) {
        return Mth.wrapDegrees((float)(b - a));
    }

    public static double angleDifference(double a, double b) {
        return Mth.wrapDegrees((double)(b - a));
    }

    public static double limitAngleDelta(double value, double center, double halfRange) {
        if (halfRange <= 0.0) {
            return Mth.wrapDegrees((double)center);
        }
        if (halfRange >= 180.0) {
            return Mth.wrapDegrees((double)value);
        }
        double delta = Functions.angleDifference(center, value);
        delta = Math.clamp(delta, -halfRange, halfRange);
        return center + delta;
    }

    public static double limitAngleDeltaSoft(double value, double center, double halfRange, double pullCoeff) {
        pullCoeff = Math.clamp(pullCoeff, 0.0, 1.0);
        double targetAngle = Functions.limitAngleDelta(value, center, halfRange);
        return RenderUtil.lerpYaw((double)pullCoeff, (double)value, (double)targetAngle);
    }

    public static double lerpAngleAwayFrom(double t, double start, double end, double avoidAngle) {
        boolean flipDir;
        if (Math.abs(Mth.wrapDegrees((double)(avoidAngle - end))) < 1.0E-4) {
            return RenderUtil.lerpYaw((double)t, (double)start, (double)end);
        }
        start = Mth.wrapDegrees((double)start);
        end = Mth.wrapDegrees((double)end);
        double diff = Mth.wrapDegrees((double)(end - start));
        double avoidDiff = Mth.wrapDegrees((double)(avoidAngle - start));
        boolean bl = flipDir = Math.signum(diff) == Math.signum(avoidDiff) && Math.abs(diff) > Math.abs(avoidDiff);
        if (flipDir) {
            diff = Math.copySign(360.0 - Math.abs(diff), -diff);
        }
        return Mth.wrapDegrees((double)(start + diff * t));
    }

    public static double inverseLerp(double value, double start, double end) {
        return (value - start) / (end - start);
    }

    public static double inverseLerpClamped(double value, double start, double end) {
        return Math.clamp(Functions.inverseLerp(value, start, end), 0.0, 1.0);
    }

    public static double inverseLerpClampedSafe(double value, double start, double end) {
        return start - end == 0.0 ? 0.0 : Functions.inverseLerpClamped(value, start, end);
    }

    public static double deadzoneNormalized(double value, double deadzone, double maxRange) {
        return Math.copySign(Functions.inverseLerpClamped(Math.abs(value), deadzone, maxRange), value);
    }

    public static ListTag newDoubleList(double ... pNumbers) {
        ListTag listtag = new ListTag();
        for (double d0 : pNumbers) {
            listtag.add((Object)DoubleTag.valueOf((double)d0));
        }
        return listtag;
    }

    public static int wrap(int value, int min, int max) {
        return value < min ? max : (value > max ? min : value);
    }

    public static double getSunPosition(Entity entity) {
        float sunAngle = entity.level().getSunAngle(1.0f);
        float angleTarget = sunAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
        sunAngle += (angleTarget - sunAngle) * 0.2f;
        return Mth.cos((float)sunAngle);
    }

    public static double calculateAttributeValue(AttributeInstance instance, double level, List<AttributeModifier> attributeModifiers, List<Modifier> modifiers) {
        double amount;
        ArrayList<Double> addition = new ArrayList<Double>();
        ArrayList<Double> multiplyBase = new ArrayList<Double>();
        ArrayList<Double> multiplyTotal = new ArrayList<Double>();
        for (AttributeModifier attributeModifier : attributeModifiers) {
            switch (attributeModifier.operation()) {
                case ADD_VALUE: {
                    addition.add(attributeModifier.amount());
                    break;
                }
                case ADD_MULTIPLIED_BASE: {
                    multiplyBase.add(attributeModifier.amount());
                    break;
                }
                case ADD_MULTIPLIED_TOTAL: {
                    multiplyTotal.add(attributeModifier.amount());
                }
            }
        }
        for (Modifier modifier : modifiers) {
            switch (modifier.operation()) {
                case ADD_VALUE: {
                    addition.add(modifier.calculate(level));
                    break;
                }
                case ADD_MULTIPLIED_BASE: {
                    multiplyBase.add(modifier.calculate(level));
                    break;
                }
                case ADD_MULTIPLIED_TOTAL: {
                    multiplyTotal.add(modifier.calculate(level));
                }
            }
        }
        double calculationBase = instance.getBaseValue();
        Iterator iterator = addition.iterator();
        while (iterator.hasNext()) {
            double amount2 = (Double)iterator.next();
            calculationBase += amount2;
        }
        double result = calculationBase;
        Iterator iterator2 = multiplyBase.iterator();
        while (iterator2.hasNext()) {
            amount = (Double)iterator2.next();
            result += calculationBase * amount;
        }
        iterator2 = multiplyTotal.iterator();
        while (iterator2.hasNext()) {
            amount = (Double)iterator2.next();
            result *= 1.0 + amount;
        }
        return ((Attribute)instance.getAttribute().value()).sanitizeValue(result);
    }

    public static <T> MutableComponent translateHolderSet(HolderSet<T> set, Translation.Type type) {
        return Functions.translateHolderSet(set, (Holder<T> entry) -> type.wrap(entry.getKey().location()));
    }

    public static <T> MutableComponent translateHolderSet(HolderSet<T> set, Function<Holder<T>, String> translationKey) {
        if (set instanceof HolderSet.Named) {
            HolderSet.Named named = (HolderSet.Named)set;
            return DSColors.dynamicValue(Component.translatable((String)Tags.getTagTranslationKey((TagKey)named.key())));
        }
        MutableComponent list = null;
        for (Holder entry : set) {
            MutableComponent name = DSColors.dynamicValue(Component.translatable((String)translationKey.apply((Holder<Holder>)entry)));
            if (list == null) {
                list = name;
                continue;
            }
            list.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.GRAY)).append((Component)name);
        }
        return Objects.requireNonNullElse(list, Component.empty());
    }

    public static NumberFormat getFormat(int decimals) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(decimals);
        return format;
    }

    public static int lerpColor(List<Integer> colors) {
        return Functions.lerpColor(colors, 0.0);
    }

    public static int lerpColor(List<Integer> colors, double offset) {
        if (colors.isEmpty()) {
            return -1;
        }
        if (colors.size() == 1) {
            return colors.getFirst();
        }
        float timer = (float)((double)DragonSurvival.PROXY.getTimer() + offset);
        if (timer > 1.0f) {
            timer -= 1.0f;
        }
        float sizeIndex = timer * (float)colors.size();
        int currentIndex = (int)(Math.floor(sizeIndex) % (double)colors.size());
        int nextIndex = (currentIndex + 1) % colors.size();
        return FastColor.ARGB32.lerp((float)(sizeIndex - (float)currentIndex), (int)DSColors.withAlpha(colors.get(currentIndex), 255.0f), (int)DSColors.withAlpha(colors.get(nextIndex), 255.0f));
    }

    public static <T extends Enum<T>> T getEnum(Class<T> type, String name) {
        try {
            return Enum.valueOf(type, name);
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            return (T)((Enum[])type.getEnumConstants())[0];
        }
    }

    public static <T extends Enum<T>> T cycleEnum(T type) {
        Class<T> declaringClass;
        Enum[] values;
        int ordinal = type.ordinal();
        ordinal = ordinal == (values = (Enum[])(declaringClass = type.getDeclaringClass()).getEnumConstants()).length - 1 ? 0 : ++ordinal;
        return (T)values[ordinal];
    }

    public static void logOrThrow(String message) {
        if (!FMLLoader.isProduction()) {
            throw new IllegalStateException(message);
        }
        DragonSurvival.LOGGER.error(message);
    }

    public record Time(int hours, int minutes, int seconds) {
        private static final NumberFormat FORMAT = NumberFormat.getInstance();

        public static Time fromTicks(int ticks) {
            int hours = (int)Functions.ticksToHours(ticks);
            int minutes = (int)Functions.ticksToMinutes(ticks - Functions.hoursToTicks(hours));
            int seconds = (int)Functions.ticksToSeconds(ticks - Functions.hoursToTicks(hours) - Functions.minutesToTicks(minutes));
            return new Time(hours, minutes, seconds);
        }

        public boolean hasTime() {
            return this.hours != 0 || this.minutes != 0 || this.seconds != 0;
        }

        public String format() {
            return this.format(this.hours) + ":" + this.format(this.minutes) + ":" + this.format(this.seconds);
        }

        public String format(int number) {
            return FORMAT.format(Math.abs(number));
        }

        static {
            FORMAT.setMinimumIntegerDigits(2);
        }
    }
}

