/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util.proxy;

import by.dragonsurvivalteam.dragonsurvival.client.DragonSurvivalClient;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRenderer;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.FollowEntitySound;
import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayer;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.common.codecs.ability.animation.AnimationType;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.body.emotes.DragonEmote;
import by.dragonsurvivalteam.dragonsurvival.util.proxy.Proxy;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
implements Proxy {
    private final Map<ResourceLocation, TickableSoundInstance> soundInstances = new HashMap<ResourceLocation, TickableSoundInstance>();

    @Override
    @Nullable
    public Player getLocalPlayer() {
        return Minecraft.getInstance().player;
    }

    @Override
    @Nullable
    public Level getLocalLevel() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player != null ? player.level() : null;
    }

    @Override
    public void playSoundAtEyeLevel(Player player, SoundEvent event) {
        Vec3 pos = player.getEyePosition(Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        SimpleSoundInstance sound = new SimpleSoundInstance(event, SoundSource.PLAYERS, 1.0f, 1.0f, SoundInstance.createUnseededRandom(), pos.x, pos.y, pos.z);
        Minecraft.getInstance().getSoundManager().playDelayed((SoundInstance)sound, 0);
    }

    @Override
    public void queueTickingSound(ResourceLocation id, SoundEvent soundEvent, SoundSource soundSource, Entity entity) {
        FollowEntitySound sound = new FollowEntitySound(soundEvent, soundSource, entity);
        TickableSoundInstance previousSound = this.soundInstances.put(id, (TickableSoundInstance)sound);
        if (previousSound != null) {
            Minecraft.getInstance().getSoundManager().stop((SoundInstance)previousSound);
        }
        Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)sound);
    }

    @Override
    public void stopTickingSound(ResourceLocation id) {
        TickableSoundInstance instance = this.soundInstances.remove(id);
        if (instance != null) {
            Minecraft.getInstance().getSoundManager().stop((SoundInstance)instance);
        }
    }

    @Override
    public void setCurrentAbilityAnimation(Player player, Pair<AbilityAnimation, AnimationType> animation) {
        DragonEntity dragon = ClientDragonRenderer.getDragon(player);
        if (dragon == null) {
            return;
        }
        dragon.setCurrentAbilityAnimation(animation);
    }

    @Override
    public void stopEmote(Player player, DragonEmote emote) {
        DragonEntity dragon = ClientDragonRenderer.getDragon(player);
        if (dragon == null) {
            return;
        }
        dragon.stopEmote(emote);
    }

    @Override
    public void beginPlayingEmote(Player player, DragonEmote emote) {
        DragonEntity dragon = ClientDragonRenderer.getDragon(player);
        if (dragon == null) {
            return;
        }
        dragon.beginPlayingEmote(emote);
    }

    @Override
    public void stopAllEmotes(Player player) {
        DragonEntity dragon = ClientDragonRenderer.getDragon(player);
        if (dragon == null) {
            return;
        }
        dragon.stopAllEmotes();
    }

    @Override
    public boolean isPlayingEmote(Player player, DragonEmote emote) {
        DragonEntity dragon = ClientDragonRenderer.getDragon(player);
        if (dragon == null) {
            return false;
        }
        return dragon.isPlayingEmote(emote);
    }

    @Override
    public float getTimer() {
        return DragonSurvivalClient.timer;
    }

    @Override
    public float getPartialTick() {
        return ClientDragonRenderer.partialTick;
    }

    @Override
    public boolean isOnRenderThread() {
        return RenderSystem.isOnRenderThread();
    }

    @Override
    public boolean isFakePlayer(Player player) {
        if (Proxy.super.isFakePlayer(player)) {
            return true;
        }
        return player instanceof FakeClientPlayer;
    }

    @Override
    @Nullable
    public RegistryAccess getAccess() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            return level.registryAccess();
        }
        return null;
    }

    @Override
    public boolean isMining(Player player) {
        return Minecraft.getInstance().gameMode != null && Minecraft.getInstance().gameMode.isDestroying();
    }

    @Override
    public boolean dragonRenderingWasCancelled(Player player) {
        DragonEntity dragon = ClientDragonRenderer.getDragon(player);
        if (dragon == null) {
            return false;
        }
        return dragon.renderingWasCancelled;
    }
}

