/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.block.blockentity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.turtleboi.ancientcurses.block.ModBlocks;
import net.turtleboi.ancientcurses.block.entity.CursedAltarBlockEntity;
import net.turtleboi.ancientcurses.block.entity.ModBlockEntities;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.CameraShakeS2C;
import net.turtleboi.ancientcurses.network.packets.SyncTrialDataS2C;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;
import net.turtleboi.ancientcurses.trials.PlayerTrialData;
import net.turtleboi.ancientcurses.util.ModTags;
import org.jetbrains.annotations.Nullable;

public class CursedAltarBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = BaseEntityBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final List<BlockPos> SOUL_TORCH_OFFSETS = BlockPos.m_121886_((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(p_207914_ -> Math.abs(p_207914_.m_123341_()) == 2 || Math.abs(p_207914_.m_123343_()) == 2).map(BlockPos::m_7949_).toList();

    public CursedAltarBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (!level.m_5776_()) {
            return;
        }
        for (BlockPos offset : SOUL_TORCH_OFFSETS) {
            double particleZ;
            double particleY;
            double particleX;
            BlockPos torchPos = pos.m_121955_((Vec3i)offset);
            BlockState torchState = level.m_8055_(torchPos);
            if (random.m_188503_(16) != 0 || !this.isSoulTorch(level, torchPos)) continue;
            if (torchState.m_60713_(Blocks.f_50140_)) {
                Direction direction = (Direction)torchState.m_61143_((Property)WallTorchBlock.f_58119_);
                Direction oppositeDirection = direction.m_122424_();
                particleX = (double)torchPos.m_123341_() + 0.5 + 0.27 * (double)oppositeDirection.m_122429_();
                particleY = (double)torchPos.m_123342_() + 0.7;
                particleZ = (double)torchPos.m_123343_() + 0.5 + 0.27 * (double)oppositeDirection.m_122431_();
            } else {
                particleX = (double)torchPos.m_123341_() + 0.5;
                particleY = (double)torchPos.m_123342_() + 0.7;
                particleZ = (double)torchPos.m_123343_() + 0.5;
            }
            double altarX = (double)pos.m_123341_() + 0.5;
            double altarY = (double)pos.m_123342_() + 1.0;
            double altarZ = (double)pos.m_123343_() + 0.5;
            double velocityX = (altarX - particleX) * 0.05;
            double velocityY = (altarY - particleY) * 0.05;
            double velocityZ = (altarZ - particleZ) * 0.05;
            level.m_7106_((ParticleOptions)ParticleTypes.f_235898_, particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
        }
    }

    private boolean isSoulTorch(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)ModBlocks.SCONCED_SOUL_TORCH.get()) || level.m_8055_(pos).m_60713_((Block)ModBlocks.SCONCED_WALL_SOUL_TORCH.get());
    }

    private void convertSoulTorches(CursedAltarBlockEntity altarEntity, Level level) {
        BlockPos altarPos = altarEntity.m_58899_();
        for (BlockPos offset : SOUL_TORCH_OFFSETS) {
            BlockState cursedTorchState;
            BlockPos torchPos = altarPos.m_121955_((Vec3i)offset);
            if (!this.isSoulTorch(level, torchPos)) continue;
            BlockState torchState = level.m_8055_(torchPos);
            if (torchState.m_60734_() instanceof WallTorchBlock) {
                Direction direction = (Direction)torchState.m_61143_((Property)WallTorchBlock.f_58119_);
                cursedTorchState = (BlockState)((Block)ModBlocks.SCONCED_WALL_CURSED_TORCH.get()).m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)direction);
            } else {
                cursedTorchState = ((Block)ModBlocks.SCONCED_CURSED_TORCH.get()).m_49966_();
            }
            level.m_7731_(torchPos, cursedTorchState, 3);
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.CURSED_FLAME_PARTICLE.get()), (double)torchPos.m_123341_() + 0.5, (double)torchPos.m_123342_() + 0.7, (double)torchPos.m_123343_() + 0.5, 20, 0.05, 0.05, 0.05, 0.01);
            serverLevel.m_6263_(null, (double)torchPos.m_123341_() + 0.5, (double)torchPos.m_123342_() + 0.7, (double)torchPos.m_123343_() + 0.5, SoundEvents.f_11923_, SoundSource.HOSTILE, 0.25f, 0.5f);
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof CursedAltarBlockEntity) {
            CursedAltarBlockEntity altarEntity = (CursedAltarBlockEntity)blockEntity;
            for (int i = 0; i < altarEntity.itemStackHandler.getSlots(); ++i) {
                ItemStack stack = altarEntity.itemStackHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack.m_41777_());
                altarEntity.itemStackHandler.setStackInSlot(i, ItemStack.f_41583_);
            }
            for (Player player : level.m_6907_()) {
                BlockPos playerAltarPos = PlayerTrialData.getCurrentAltarPos(player);
                if (playerAltarPos == null || !playerAltarPos.equals((Object)pos)) continue;
                PlayerTrialData.resetAltarAtPos(player, playerAltarPos);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof CursedAltarBlockEntity) {
            CursedAltarBlockEntity altarEntity = (CursedAltarBlockEntity)blockEntity;
            if (altarEntity.isAnimating()) {
                return InteractionResult.FAIL;
            }
            if (PlayerTrialData.isPlayerCursed(player)) {
                return InteractionResult.FAIL;
            }
            if (PlayerTrialData.getCurrentAltarPos(player) != null && !Objects.equals(PlayerTrialData.getCurrentAltarPos(player), altarEntity.m_58899_())) {
                return InteractionResult.FAIL;
            }
            if (altarEntity.hasPlayerCompletedTrial(player)) {
                this.rewardPlayer(player, altarEntity, level, pos);
                if (player.m_6144_() && altarEntity.canPlayerUse(player)) {
                    for (int i = 2; i >= 0; --i) {
                        ItemStack gem = altarEntity.getGemInSlot(i);
                        if (gem.m_41619_()) continue;
                        if (player.m_150109_().m_36054_(gem)) {
                            altarEntity.setGemInSlot(i, ItemStack.f_41583_);
                            altarEntity.m_6596_();
                        } else {
                            this.ejectItemsTowardPlayer(level, pos, player, Collections.singletonList(gem));
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else if (altarEntity.canPlayerUse(player)) {
                    ItemStack heldItem = player.m_21120_(hand);
                    if (this.isPreciousGem(heldItem)) {
                        for (int i = 0; i < 3; ++i) {
                            if (!altarEntity.getGemInSlot(i).m_41619_()) continue;
                            altarEntity.setGemInSlot(i, heldItem.m_41620_(1));
                            altarEntity.m_6596_();
                            return InteractionResult.SUCCESS;
                        }
                    }
                    ItemStack gemSlot0 = altarEntity.getGemInSlot(0);
                    ItemStack gemSlot1 = altarEntity.getGemInSlot(1);
                    ItemStack gemSlot2 = altarEntity.getGemInSlot(2);
                    if (!gemSlot0.m_41619_() && gemSlot0.m_150930_(gemSlot1.m_41720_()) && gemSlot0.m_150930_(gemSlot2.m_41720_()) && !gemSlot0.m_204117_(ModTags.Items.MAJOR_GEMS)) {
                        altarEntity.startAnimation();
                        level.m_7260_(pos, state, state, 3);
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                if (!altarEntity.hasPlayerCompletedTrial(player) && altarEntity.canPlayerUse(player)) {
                    this.convertSoulTorches(altarEntity, level);
                    ModNetworking.sendToPlayer(new CameraShakeS2C(0.125f, 1000), (ServerPlayer)player);
                    this.startTrial(player, altarEntity);
                    return InteractionResult.SUCCESS;
                }
                if (!altarEntity.hasPlayerCompletedTrial(player) && !altarEntity.canPlayerUse(player)) {
                    return InteractionResult.FAIL;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void startTrial(Player player, CursedAltarBlockEntity altarEntity) {
        if (altarEntity.hasPlayerCompletedTrial(player)) {
            return;
        }
        MobEffect randomCurse = CursedAltarBlockEntity.getRandomCurse();
        int randomAmplifier = CursedAltarBlockEntity.getRandomAmplifier(player);
        BlockPos playerPos = player.m_20183_();
        Level level = player.m_9236_();
        level.m_5594_(null, playerPos, SoundEvents.f_11880_, SoundSource.AMBIENT, 1.0f, 0.25f);
        level.m_5594_(null, playerPos, (SoundEvent)SoundEvents.f_12325_.get(), SoundSource.AMBIENT, 1.0f, 0.5f);
        altarEntity.cursePlayer(player, randomCurse, randomAmplifier);
    }

    private boolean isPreciousGem(ItemStack itemStack) {
        return itemStack.m_204117_(ModTags.Items.PRECIOUS_GEMS);
    }

    private void rewardPlayer(Player player, CursedAltarBlockEntity altarEntity, Level level, BlockPos pos) {
        int amplifier = PlayerTrialData.getCurseAmplifier(player);
        if (altarEntity.hasCollectedReward(player)) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ModNetworking.sendToPlayer(new CameraShakeS2C(0.125f, 1000), (ServerPlayer)player);
            this.rewardPlayerWithLootTable(player, amplifier, level, pos);
            ModNetworking.sendToPlayer(new SyncTrialDataS2C("None", "", 0, 0, 0L, 0L, "", 0, 0), (ServerPlayer)player);
            PlayerTrialData.clearCurseAmplifier(player);
            altarEntity.markRewardCollected(player);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, (double)altarEntity.m_58899_().m_123341_() + 0.5, (double)(altarEntity.m_58899_().m_123342_() + 1), (double)altarEntity.m_58899_().m_123343_() + 0.5, (SoundEvent)SoundEvents.f_12377_.get(), SoundSource.AMBIENT, 1.0f, 0.5f);
            serverLevel.m_6263_(null, (double)altarEntity.m_58899_().m_123341_() + 0.5, (double)(altarEntity.m_58899_().m_123342_() + 1), (double)altarEntity.m_58899_().m_123343_() + 0.5, SoundEvents.f_12496_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    private void rewardPlayerWithLootTable(Player player, int pAmplifier, Level level, BlockPos pos) {
        int maxRolls;
        int minRolls;
        ResourceLocation[] lootTableLocations = new ResourceLocation[]{new ResourceLocation("ancientcurses", "amplifier_0"), new ResourceLocation("ancientcurses", "amplifier_1"), new ResourceLocation("ancientcurses", "amplifier_2")};
        int lootIndex = Math.min(pAmplifier, lootTableLocations.length - 1);
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        LootTable lootTable = (LootTable)serverLevel.m_7654_().m_278653_().m_278789_(LootDataType.f_278413_, lootTableLocations[lootIndex]);
        if (lootTable == null) {
            return;
        }
        Random random = new Random();
        if (pAmplifier == 0) {
            minRolls = 3;
            maxRolls = 5;
        } else if (pAmplifier == 1) {
            minRolls = 2;
            maxRolls = 3;
        } else {
            minRolls = 1;
            maxRolls = 1;
        }
        int rollCount = random.nextInt(maxRolls - minRolls + 1) + minRolls;
        ArrayList<ItemStack> totalGeneratedLoot = new ArrayList<ItemStack>();
        for (int i = 0; i < rollCount; ++i) {
            LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_());
            LootParams lootParams = lootParamsBuilder.m_287235_(LootContextParamSets.f_81411_);
            ObjectArrayList generatedLoot = lootTable.m_287195_(lootParams);
            totalGeneratedLoot.addAll((Collection<ItemStack>)generatedLoot);
        }
        ResourceLocation[] gemLootLocations = new ResourceLocation[]{new ResourceLocation("ancientcurses", "ancient_gems"), new ResourceLocation("ancientcurses", "perfect_gems"), new ResourceLocation("ancientcurses", "polished_gems"), new ResourceLocation("ancientcurses", "broken_gems")};
        int[][] lootChances = new int[][]{{0, 0, 10, 100}, {0, 10, 75, 100}, {10, 66, 100, 100}};
        int ampIndex = Math.min(pAmplifier, lootChances.length - 1);
        for (int tier = 0; tier < gemLootLocations.length; ++tier) {
            LootParams.Builder gemLootParamsBuilder;
            LootParams gemLootParams;
            ObjectArrayList gemLoot;
            ResourceLocation gemLootLocation = gemLootLocations[tier];
            LootTable gemLootTable = (LootTable)serverLevel.m_7654_().m_278653_().m_278789_(LootDataType.f_278413_, gemLootLocation);
            if (gemLootTable == null) continue;
            int gemLootChance = lootChances[ampIndex][tier];
            if (random.nextInt(100) >= gemLootChance || (gemLoot = gemLootTable.m_287195_(gemLootParams = (gemLootParamsBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_())).m_287235_(LootContextParamSets.f_81411_))).isEmpty()) continue;
            totalGeneratedLoot.add((ItemStack)gemLoot.get(0));
            break;
        }
        for (ItemStack item : totalGeneratedLoot) {
            if (item.m_41619_()) continue;
            this.ejectItemsTowardPlayer(level, pos, player, Collections.singletonList(item));
        }
    }

    private void ejectItemsTowardPlayer(Level level, BlockPos pos, Player player, List<ItemStack> items) {
        for (ItemStack item : items) {
            if (item.m_41619_()) continue;
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, item.m_41777_());
            double dX = player.m_20185_() - (double)pos.m_123341_();
            double dY = player.m_20186_() + (double)player.m_20192_() - ((double)pos.m_123342_() + 1.5);
            double dZ = player.m_20189_() - (double)pos.m_123343_();
            double velocityFactor = 0.1;
            itemEntity.m_20334_(dX * velocityFactor, dY * velocityFactor, dZ * velocityFactor);
            level.m_7967_((Entity)itemEntity);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CursedAltarBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.f_46443_) {
            return CursedAltarBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CURSED_ALTAR_BE.get()), CursedAltarBlockEntity::bookAnimationTick);
        }
        return CursedAltarBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.CURSED_ALTAR_BE.get()), CursedAltarBlockEntity::serverTick);
    }
}

