/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import net.turtleboi.ancientcurses.block.entity.ModBlockEntities;
import net.turtleboi.ancientcurses.effect.ModEffects;
import net.turtleboi.ancientcurses.item.ModItems;
import net.turtleboi.ancientcurses.trials.EliminationTrial;
import net.turtleboi.ancientcurses.trials.FetchTrial;
import net.turtleboi.ancientcurses.trials.PlayerTrialData;
import net.turtleboi.ancientcurses.trials.SurvivalTrial;
import net.turtleboi.ancientcurses.trials.Trial;
import net.turtleboi.ancientcurses.trials.TrialRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursedAltarBlockEntity
extends BlockEntity {
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final Map<UUID, Trial> playerTrials = new HashMap<UUID, Trial>();
    private final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private boolean isAnimating = false;
    private long animationStartTime = 0L;
    private static final Map<Item, Item> gemUpgradeMap = new HashMap<Item, Item>();
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            CursedAltarBlockEntity.this.m_6596_();
            if (CursedAltarBlockEntity.this.f_58857_ != null && !((CursedAltarBlockEntity)CursedAltarBlockEntity.this).f_58857_.f_46443_) {
                CursedAltarBlockEntity.this.f_58857_.m_7260_(CursedAltarBlockEntity.this.m_58899_(), CursedAltarBlockEntity.this.m_58900_(), CursedAltarBlockEntity.this.m_58900_(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.m_41613_() > 1) {
                stack.m_41764_(1);
            }
            return super.insertItem(slot, stack, simulate);
        }
    };

    public CursedAltarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.CURSED_ALTAR_BE.get(), pPos, pBlockState);
    }

    public static void bookAnimationTick(Level pLevel, BlockPos pPos, BlockState pState, CursedAltarBlockEntity pBlockEntity) {
        float v5;
        pBlockEntity.oOpen = pBlockEntity.open;
        pBlockEntity.oRot = pBlockEntity.rot;
        Player v1 = pLevel.m_45924_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 3.0, false);
        if (v1 != null) {
            double v2 = v1.m_20185_() - ((double)pPos.m_123341_() + 0.5);
            double v3 = v1.m_20189_() - ((double)pPos.m_123343_() + 0.5);
            pBlockEntity.tRot = (float)Mth.m_14136_((double)v3, (double)v2);
            pBlockEntity.open += 0.1f;
            if (pBlockEntity.open < 0.5f || RANDOM.m_188503_(40) == 0) {
                float v4 = pBlockEntity.flipT;
                do {
                    pBlockEntity.flipT += (float)(RANDOM.m_188503_(4) - RANDOM.m_188503_(4));
                } while (v4 == pBlockEntity.flipT);
            }
        } else {
            pBlockEntity.tRot += 0.02f;
            pBlockEntity.open -= 0.1f;
        }
        while (pBlockEntity.rot >= (float)Math.PI) {
            pBlockEntity.rot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.rot < (float)(-Math.PI)) {
            pBlockEntity.rot += (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot >= (float)Math.PI) {
            pBlockEntity.tRot -= (float)Math.PI * 2;
        }
        while (pBlockEntity.tRot < (float)(-Math.PI)) {
            pBlockEntity.tRot += (float)Math.PI * 2;
        }
        for (v5 = pBlockEntity.tRot - pBlockEntity.rot; v5 >= (float)Math.PI; v5 -= (float)Math.PI * 2) {
        }
        while (v5 < (float)(-Math.PI)) {
            v5 += (float)Math.PI * 2;
        }
        pBlockEntity.rot += v5 * 0.4f;
        pBlockEntity.open = Mth.m_14036_((float)pBlockEntity.open, (float)0.0f, (float)1.0f);
        ++pBlockEntity.time;
        pBlockEntity.oFlip = pBlockEntity.flip;
        float v6 = (pBlockEntity.flipT - pBlockEntity.flip) * 0.4f;
        v6 = Mth.m_14036_((float)v6, (float)-0.2f, (float)0.2f);
        pBlockEntity.flipA += (v6 - pBlockEntity.flipA) * 0.9f;
        pBlockEntity.flip += pBlockEntity.flipA;
    }

    public void startAnimation() {
        this.isAnimating = true;
        this.setAnimationStartTime(System.currentTimeMillis());
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void stopAnimation() {
        this.isAnimating = false;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    public void setAnimationStartTime(Long startTime) {
        this.getPersistentData().m_128356_("AnimationStartTime", startTime.longValue());
    }

    public long getAnimationStartTime() {
        return this.getPersistentData().m_128454_("AnimationStartTime");
    }

    public ItemStack getGemInSlot(int slot) {
        return this.itemStackHandler.getStackInSlot(slot);
    }

    public void setGemInSlot(int slot, ItemStack stack) {
        this.itemStackHandler.setStackInSlot(slot, stack);
    }

    public boolean canPlayerUse(Player player) {
        long lastUseTime;
        long timePassed;
        UUID playerUUID = player.m_20148_();
        if (PlayerTrialData.isPlayerCursed(player)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long cooldownTime = 250L;
        if (this.playerCooldowns.containsKey(playerUUID) && (timePassed = currentTime - (lastUseTime = this.playerCooldowns.get(playerUUID).longValue())) < cooldownTime) {
            long timeRemaining = cooldownTime - timePassed;
            return false;
        }
        this.playerCooldowns.put(playerUUID, currentTime);
        return true;
    }

    public void cursePlayer(Player player, MobEffect curse, int curseAmplifier) {
        BlockPos altarPos = this.m_58899_();
        UUID playerUUID = player.m_20148_();
        Random random = new Random();
        int minMultiple = 180;
        int maxMultiple = 240;
        int range = maxMultiple - minMultiple + 1;
        int randomMultiple = random.nextInt(range) + minMultiple;
        int calculatedDuration = randomMultiple * 20;
        int curseDuration = calculatedDuration * (curseAmplifier + 1);
        Trial trial = this.createTrialForCurse(player, curse, curseDuration, curseAmplifier);
        this.addPlayerTrial(playerUUID, trial);
        PlayerTrialData.setCurseEffect(player, curse);
        PlayerTrialData.setCurseAmplifier(player, curseAmplifier);
        PlayerTrialData.setCurrentAltarPos(player, altarPos);
        String trialType = trial.getType();
        TrialRecord trialRecord = new TrialRecord(altarPos, trialType, false, false);
        PlayerTrialData.addOrUpdateTrialRecord(player, trialRecord);
        player.m_7292_(new MobEffectInstance(curse, trial instanceof SurvivalTrial ? curseDuration : -1, curseAmplifier, false, false, true));
        trial.trackProgress(player);
    }

    public boolean hasPlayerCompletedTrial(Player player) {
        BlockPos altarPos = this.m_58899_();
        boolean completed = PlayerTrialData.hasCompletedTrial(player, altarPos);
        return completed;
    }

    public void setPlayerTrialCompleted(Player player) {
        UUID playerUUID = player.m_20148_();
        Trial trial = this.playerTrials.get(playerUUID);
        if (trial != null) {
            BlockPos altarPos = this.m_58899_();
            PlayerTrialData.setTrialCompleted(player, this.m_58899_());
            trial.setCompleted(true);
            this.m_6596_();
        }
    }

    public boolean hasCollectedReward(Player player) {
        BlockPos altarPos = this.m_58899_();
        return PlayerTrialData.hasCollectedReward(player, altarPos);
    }

    public void markRewardCollected(Player player) {
        PlayerTrialData.setRewardCollected(player, this.m_58899_());
        PlayerTrialData.clearCurrentAltarPos(player);
        this.m_6596_();
    }

    public Trial getPlayerTrial(UUID playerUUID) {
        return this.playerTrials.get(playerUUID);
    }

    public void addPlayerTrial(UUID playerUUID, Trial trial) {
        this.playerTrials.put(playerUUID, trial);
    }

    public void removePlayerTrial(UUID playerUUID) {
        this.playerTrials.remove(playerUUID);
    }

    public void removePlayerFromTrial(Player player) {
        UUID playerUUID = player.m_20148_();
        Trial trial = this.playerTrials.get(playerUUID);
        if (trial != null && !trial.isTrialCompleted(player)) {
            this.removePlayerTrial(playerUUID);
            this.m_6596_();
        }
    }

    public static MobEffect getRandomCurse() {
        List<MobEffect> curses = Arrays.asList((MobEffect)ModEffects.CURSE_OF_SLOTH.get(), (MobEffect)ModEffects.CURSE_OF_WRATH.get(), (MobEffect)ModEffects.CURSE_OF_OBESSSION.get(), (MobEffect)ModEffects.CURSE_OF_SHADOWS.get(), (MobEffect)ModEffects.CURSE_OF_GLUTTONY.get(), (MobEffect)ModEffects.CURSE_OF_ENDING.get(), (MobEffect)ModEffects.CURSE_OF_ENVY.get(), (MobEffect)ModEffects.CURSE_OF_FRAILTY.get(), (MobEffect)ModEffects.CURSE_OF_PESTILENCE.get(), (MobEffect)ModEffects.CURSE_OF_PRIDE.get(), (MobEffect)ModEffects.CURSE_OF_NATURE.get(), (MobEffect)ModEffects.CURSE_OF_AVARICE.get());
        return curses.get(new Random().nextInt(curses.size()));
    }

    public static int getRandomAmplifier(Player player) {
        int trialsCompleted = PlayerTrialData.getPlayerTrialsCompleted(player);
        List<Integer> weightedAmplifiers = CursedAltarBlockEntity.getWeightedAmplifier(trialsCompleted);
        if (weightedAmplifiers.isEmpty()) {
            System.out.println(Component.m_237113_((String)"No amplifiers available at this time.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        int count0 = 0;
        int count1 = 0;
        int count2 = 0;
        for (int amplifier : weightedAmplifiers) {
            switch (amplifier) {
                case 0: {
                    ++count0;
                    break;
                }
                case 1: {
                    ++count1;
                    break;
                }
                case 2: {
                    ++count2;
                    break;
                }
            }
        }
        int total = weightedAmplifiers.size();
        double chance0 = total > 0 ? (double)count0 * 100.0 / (double)total : 0.0;
        double chance1 = total > 0 ? (double)count1 * 100.0 / (double)total : 0.0;
        double chance2 = total > 0 ? (double)count2 * 100.0 / (double)total : 0.0;
        MutableComponent message = Component.m_237113_((String)"Trials Completed: ").m_7220_((Component)Component.m_237113_((String)String.valueOf(trialsCompleted)).m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"\nAmplifier Chances:\n")).m_7220_((Component)Component.m_237113_((String)"\u2022 Amplifier 0: ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)String.format("%.2f%%", chance0)).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\n\u2022 Amplifier 1: ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)String.format("%.2f%%", chance1)).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"\n\u2022 Amplifier 2: ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)String.format("%.2f%%", chance2)).m_130940_(ChatFormatting.GOLD));
        return weightedAmplifiers.get(ThreadLocalRandom.current().nextInt(weightedAmplifiers.size()));
    }

    @NotNull
    private static List<Integer> getWeightedAmplifier(int trialsCompleted) {
        int i;
        double completionFactor = Math.min((double)trialsCompleted / 25.0, 1.0);
        int amplifier0Weight = (int)Math.max(6.0 * (1.0 - completionFactor), 0.0);
        int amplifier1Weight = (int)Math.max(3.0 * (1.0 - completionFactor), 0.0);
        int amplifier2Weight = (int)Math.max(1.0 + 10.0 * completionFactor, 1.0);
        ArrayList<Integer> weightedAmplifiers = new ArrayList<Integer>();
        for (i = 0; i < amplifier0Weight; ++i) {
            weightedAmplifiers.add(0);
        }
        for (i = 0; i < amplifier1Weight; ++i) {
            weightedAmplifiers.add(1);
        }
        for (i = 0; i < amplifier2Weight; ++i) {
            weightedAmplifiers.add(2);
        }
        return weightedAmplifiers;
    }

    public Trial createTrialForCurse(Player player, MobEffect curseType, int curseDuration, int curseAmplifier) {
        if (curseType == ModEffects.CURSE_OF_AVARICE.get()) {
            return new FetchTrial(player, curseType, curseAmplifier, this);
        }
        if (curseType == ModEffects.CURSE_OF_ENDING.get()) {
            return new SurvivalTrial(player, curseType, curseAmplifier, curseDuration, this);
        }
        if (curseType == ModEffects.CURSE_OF_ENVY.get()) {
            return new EliminationTrial(player, curseType, curseAmplifier, this);
        }
        if (curseType == ModEffects.CURSE_OF_FRAILTY.get()) {
            return new EliminationTrial(player, curseType, curseAmplifier, this);
        }
        if (curseType == ModEffects.CURSE_OF_GLUTTONY.get()) {
            return new SurvivalTrial(player, curseType, curseAmplifier, curseDuration, this);
        }
        if (curseType == ModEffects.CURSE_OF_NATURE.get()) {
            return new FetchTrial(player, curseType, curseAmplifier, this);
        }
        if (curseType == ModEffects.CURSE_OF_OBESSSION.get()) {
            return new SurvivalTrial(player, curseType, curseAmplifier, curseDuration, this);
        }
        if (curseType == ModEffects.CURSE_OF_PESTILENCE.get()) {
            return new SurvivalTrial(player, curseType, curseAmplifier, curseDuration, this);
        }
        if (curseType == ModEffects.CURSE_OF_PRIDE.get()) {
            return new EliminationTrial(player, curseType, curseAmplifier, this);
        }
        if (curseType == ModEffects.CURSE_OF_SHADOWS.get()) {
            return new FetchTrial(player, curseType, curseAmplifier, this);
        }
        if (curseType == ModEffects.CURSE_OF_SLOTH.get()) {
            return new FetchTrial(player, curseType, curseAmplifier, this);
        }
        if (curseType == ModEffects.CURSE_OF_WRATH.get()) {
            return new EliminationTrial(player, curseType, curseAmplifier, this);
        }
        return null;
    }

    public void performGemUpgrade() {
        ItemStack upgradedGem;
        ItemStack gem1 = this.getGemInSlot(0);
        ItemStack gem2 = this.getGemInSlot(1);
        ItemStack gem3 = this.getGemInSlot(2);
        if (!gem1.m_41619_() && gem1.m_150930_(gem2.m_41720_()) && gem1.m_150930_(gem3.m_41720_()) && (upgradedGem = this.getUpgradedGem(gem1)) != null) {
            this.setGemInSlot(0, ItemStack.f_41583_);
            this.setGemInSlot(1, ItemStack.f_41583_);
            this.setGemInSlot(2, ItemStack.f_41583_);
            this.setGemInSlot(0, upgradedGem);
            this.m_6596_();
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public ItemStack getUpgradedGem(ItemStack gem) {
        Item upgradedItem = gemUpgradeMap.get(gem.m_41720_());
        if (upgradedItem != null) {
            return new ItemStack((ItemLike)upgradedItem);
        }
        return null;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CursedAltarBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void serverTick() {
        if (this.isAnimating) {
            long currentTime = System.currentTimeMillis();
            long animationDuration = 7800L;
            if (currentTime - this.getAnimationStartTime() >= animationDuration) {
                this.performGemUpgrade();
                this.stopAnimation();
            }
        }
    }

    private Trial reconstructTrialFromNBT(String trialType, CompoundTag trialData) {
        if (trialType.equals("SurvivalTrial")) {
            SurvivalTrial trial = new SurvivalTrial(this);
            trial.loadFromNBT(trialData);
            return trial;
        }
        if (trialType.equals("EliminationTrial")) {
            EliminationTrial trial = new EliminationTrial(this);
            trial.loadFromNBT(trialData);
            return trial;
        }
        return null;
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("IsAnimating", this.isAnimating);
        tag.m_128356_("AnimationStartTime", this.animationStartTime);
        tag.m_128365_("gems", (Tag)this.itemStackHandler.serializeNBT());
        ListTag activeTrialsList = new ListTag();
        for (Map.Entry<UUID, Trial> entry : this.playerTrials.entrySet()) {
            UUID playerUUID = entry.getKey();
            Trial trial = entry.getValue();
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("PlayerUUID", playerUUID);
            playerTag.m_128359_("TrialType", trial.getType());
            CompoundTag trialData = new CompoundTag();
            trial.saveToNBT(trialData);
            playerTag.m_128365_("TrialData", (Tag)trialData);
            activeTrialsList.add((Object)playerTag);
        }
        tag.m_128365_("ActiveTrials", (Tag)activeTrialsList);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.isAnimating = tag.m_128471_("IsAnimating");
        this.animationStartTime = tag.m_128454_("AnimationStartTime");
        if (tag.m_128441_("gems")) {
            this.itemStackHandler.deserializeNBT(tag.m_128469_("gems"));
        }
        ListTag activeTrialsList = tag.m_128437_("ActiveTrials", 10);
        this.playerTrials.clear();
        for (int i = 0; i < activeTrialsList.size(); ++i) {
            CompoundTag trialData;
            CompoundTag playerTag = activeTrialsList.m_128728_(i);
            UUID playerUUID = playerTag.m_128342_("PlayerUUID");
            String trialType = playerTag.m_128461_("TrialType");
            Trial trial = this.reconstructTrialFromNBT(trialType, trialData = playerTag.m_128469_("TrialData"));
            if (trial == null) continue;
            trial.setAltar(this);
            this.playerTrials.put(playerUUID, trial);
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    static {
        gemUpgradeMap.put((Item)ModItems.BROKEN_AMETHYST.get(), (Item)ModItems.POLISHED_AMETHYST.get());
        gemUpgradeMap.put((Item)ModItems.POLISHED_AMETHYST.get(), (Item)ModItems.PERFECT_AMETHYST.get());
        gemUpgradeMap.put((Item)ModItems.BROKEN_DIAMOND.get(), (Item)ModItems.POLISHED_DIAMOND.get());
        gemUpgradeMap.put((Item)ModItems.POLISHED_DIAMOND.get(), (Item)ModItems.PERFECT_DIAMOND.get());
        gemUpgradeMap.put((Item)ModItems.BROKEN_EMERALD.get(), (Item)ModItems.POLISHED_EMERALD.get());
        gemUpgradeMap.put((Item)ModItems.POLISHED_EMERALD.get(), (Item)ModItems.PERFECT_EMERALD.get());
        gemUpgradeMap.put((Item)ModItems.BROKEN_RUBY.get(), (Item)ModItems.POLISHED_RUBY.get());
        gemUpgradeMap.put((Item)ModItems.POLISHED_RUBY.get(), (Item)ModItems.PERFECT_RUBY.get());
        gemUpgradeMap.put((Item)ModItems.BROKEN_SAPPHIRE.get(), (Item)ModItems.POLISHED_SAPPHIRE.get());
        gemUpgradeMap.put((Item)ModItems.POLISHED_SAPPHIRE.get(), (Item)ModItems.PERFECT_SAPPHIRE.get());
        gemUpgradeMap.put((Item)ModItems.BROKEN_TOPAZ.get(), (Item)ModItems.POLISHED_TOPAZ.get());
        gemUpgradeMap.put((Item)ModItems.POLISHED_TOPAZ.get(), (Item)ModItems.PERFECT_TOPAZ.get());
    }
}

