/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.turtleboi.ancientcurses.block.entity.ModBlockEntities;
import net.turtleboi.ancientcurses.screen.LapidaristTableContainerMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LapidaristTableBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemStackHandler = new ItemStackHandler(7){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public static final int socketableItemSlot = 0;
    public static final int mainGem = 1;
    public static final int minorGem1 = 2;
    public static final int minorGem2 = 3;
    public static final int minorGem3 = 4;
    public static final int minorGem4 = 5;
    public static final int minorGem5 = 6;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData pData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return 0;
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 7;
        }
    };
    private boolean hasSocketableItem = false;

    public LapidaristTableBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.LAPIDARIST_TABLE_BE.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemStackHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemStackHandler.getSlots());
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemStackHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Lapidarist's Workbench");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new LapidaristTableContainerMenu(pContainerId, pPlayerInventory, this, this.pData);
    }

    public ItemStackHandler getInventory() {
        return this.itemStackHandler;
    }

    public void onSlotChanged() {
        ItemStack itemStack = this.getInventory().getStackInSlot(0);
        if (!itemStack.m_41619_() && itemStack.m_41782_() && itemStack.m_41783_().m_128471_("Socketable")) {
            if (!this.hasSocketableItem) {
                this.loadGemsFromItem();
                this.hasSocketableItem = true;
            }
            this.saveGemsToItem();
        } else {
            this.clearGemSlots();
            this.hasSocketableItem = false;
        }
        this.markForUpdate();
    }

    public void markForUpdate() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void clearGemSlots() {
        for (int i = 1; i <= 6; ++i) {
            this.getInventory().setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void saveGemsToItem() {
        ItemStack itemStack = this.getInventory().getStackInSlot(0);
        if (!itemStack.m_41619_() && itemStack.m_41782_() && itemStack.m_41783_().m_128471_("Socketable")) {
            CompoundTag amuletTag = itemStack.m_41784_();
            ItemStack mainGemStack = this.itemStackHandler.getStackInSlot(1);
            if (!mainGemStack.m_41619_()) {
                amuletTag.m_128365_("MainGem", (Tag)mainGemStack.serializeNBT());
            } else {
                amuletTag.m_128473_("MainGem");
            }
            ListTag minorGems = new ListTag();
            for (int i = 2; i <= 6; ++i) {
                ItemStack minorGemStack = this.getInventory().getStackInSlot(i);
                if (minorGemStack.m_41619_()) continue;
                minorGems.add((Object)minorGemStack.serializeNBT());
            }
            if (!minorGems.isEmpty()) {
                amuletTag.m_128365_("MinorGems", (Tag)minorGems);
            } else {
                amuletTag.m_128473_("MinorGems");
            }
            itemStack.m_41751_(amuletTag);
            this.markForUpdate();
        }
    }

    public void loadGemsFromItem() {
        ItemStack socketableItem = this.getInventory().getStackInSlot(0);
        if (!socketableItem.m_41619_()) {
            CompoundTag itemTag = socketableItem.m_41784_();
            if (itemTag.m_128441_("MainGem")) {
                CompoundTag mainGemTag = itemTag.m_128469_("MainGem");
                ItemStack mainGemStack = ItemStack.m_41712_((CompoundTag)mainGemTag);
                this.getInventory().setStackInSlot(1, mainGemStack);
            } else {
                this.getInventory().setStackInSlot(1, ItemStack.f_41583_);
            }
            if (itemTag.m_128441_("MinorGems")) {
                int i;
                ListTag minorGems = itemTag.m_128437_("MinorGems", 10);
                for (i = 0; i < minorGems.size(); ++i) {
                    CompoundTag minorGemTag = minorGems.m_128728_(i);
                    ItemStack minorGemStack = ItemStack.m_41712_((CompoundTag)minorGemTag);
                    this.getInventory().setStackInSlot(2 + i, minorGemStack);
                }
                for (i = minorGems.size(); i < 5; ++i) {
                    this.getInventory().setStackInSlot(2 + i, ItemStack.f_41583_);
                }
            } else {
                for (int i = 2; i <= 6; ++i) {
                    this.getInventory().setStackInSlot(i, ItemStack.f_41583_);
                }
            }
            this.markForUpdate();
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.getInventory().serializeNBT());
        this.saveGemsToItem();
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        ItemStack amulet = this.getInventory().getStackInSlot(0);
        this.getInventory().deserializeNBT(pTag.m_128469_("inventory"));
        if (!amulet.m_41619_()) {
            this.loadGemsFromItem();
        }
    }
}

