/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.turtleboi.ancientcurses.block.entity.CursedAltarBlockEntity;

public class CursedAltarRenderer
implements BlockEntityRenderer<CursedAltarBlockEntity> {
    public static final ResourceLocation BOOK_LOCATION = new ResourceLocation("ancientcurses", "textures/entity/ancient_book.png");
    private final BookModel bookModel;
    private final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();

    public CursedAltarRenderer(BlockEntityRendererProvider.Context pContext) {
        this.bookModel = new BookModel(pContext.m_173582_(ModelLayers.f_171271_));
    }

    private void renderGem(ItemStack gem, float hoverHeight, float orbitRadius, float baseAngle, float f1, float spinSpeed, float orbitSpeedMultiplier, PoseStack pPoseStack, int pPackedLight, int pPackedOverlay, MultiBufferSource pBuffer, BlockEntity pBlockEntity) {
        if (!gem.m_41619_()) {
            pPoseStack.m_85836_();
            pPoseStack.m_252880_(0.5f, hoverHeight, 0.5f);
            pPoseStack.m_252781_(Axis.f_252436_.m_252961_(spinSpeed));
            float normalizedTime = f1 % 360.0f;
            float adjustedOrbitSpeedMultiplier = orbitSpeedMultiplier * (1.0f / normalizedTime);
            float adjustedOrbitAngle = baseAngle + normalizedTime * adjustedOrbitSpeedMultiplier;
            adjustedOrbitAngle = (float)((double)adjustedOrbitAngle % (Math.PI * 2));
            pPoseStack.m_85837_((double)orbitRadius * Math.cos(adjustedOrbitAngle), 0.0, (double)orbitRadius * Math.sin(adjustedOrbitAngle));
            this.itemRenderer.m_269128_(gem, ItemDisplayContext.GROUND, pPackedLight, pPackedOverlay, pPoseStack, pBuffer, pBlockEntity.m_58904_(), 0);
            pPoseStack.m_85849_();
        }
    }

    private void renderGems(PoseStack pPoseStack, CursedAltarBlockEntity pBlockEntity, float f1, int pPackedLight, int pPackedOverlay, MultiBufferSource pBuffer, float orbitRadius, float orbitSpeedMultiplier) {
        ItemStack gem1 = pBlockEntity.getGemInSlot(0);
        ItemStack gem2 = pBlockEntity.getGemInSlot(1);
        ItemStack gem3 = pBlockEntity.getGemInSlot(2);
        float hoverHeight = 1.25f + Mth.m_14031_((float)(f1 * 0.1f)) * 0.05f;
        float spinSpeed1 = f1 % 360.0f * (float)Math.PI / 180.0f;
        float spinSpeed2 = (f1 + 120.0f + 120.0f) * (float)Math.PI / 180.0f;
        float spinSpeed3 = (f1 + 240.0f + 240.0f) * (float)Math.PI / 180.0f;
        int gemCount = (!gem1.m_41619_() ? 1 : 0) + (!gem2.m_41619_() ? 1 : 0) + (!gem3.m_41619_() ? 1 : 0);
        if (gemCount == 1) {
            this.renderGem(gem1, hoverHeight, 0.0f, 0.0f, f1, spinSpeed1, orbitSpeedMultiplier, pPoseStack, pPackedLight, pPackedOverlay, pBuffer, pBlockEntity);
        } else if (gemCount == 2) {
            this.renderGem(gem1, hoverHeight, orbitRadius, 0.0f, f1, spinSpeed1, orbitSpeedMultiplier, pPoseStack, pPackedLight, pPackedOverlay, pBuffer, pBlockEntity);
            this.renderGem(gem2, hoverHeight, orbitRadius, 1.5707964f - orbitSpeedMultiplier * (float)Math.PI * 2.0f, f1, spinSpeed2, orbitSpeedMultiplier, pPoseStack, pPackedLight, pPackedOverlay, pBuffer, pBlockEntity);
        } else if (gemCount == 3) {
            this.renderGem(gem1, hoverHeight, orbitRadius, 0.0f, f1, spinSpeed1, orbitSpeedMultiplier, pPoseStack, pPackedLight, pPackedOverlay, pBuffer, pBlockEntity);
            this.renderGem(gem2, hoverHeight, orbitRadius, 2.0943952f, f1, spinSpeed2, orbitSpeedMultiplier, pPoseStack, pPackedLight, pPackedOverlay, pBuffer, pBlockEntity);
            this.renderGem(gem3, hoverHeight, orbitRadius, 4.1887903f, f1, spinSpeed3, orbitSpeedMultiplier, pPoseStack, pPackedLight, pPackedOverlay, pBuffer, pBlockEntity);
        }
    }

    public void render(CursedAltarBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        float f2;
        float rotation;
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(0.5f, 0.75f, 0.5f);
        float f1 = (float)pBlockEntity.time + pPartialTick;
        pPoseStack.m_252880_(0.0f, 0.1f + Mth.m_14031_((float)(f1 * 0.1f)) * 0.01f, 0.0f);
        for (rotation = pBlockEntity.rot - pBlockEntity.oRot; rotation >= (float)Math.PI; rotation -= (float)Math.PI * 2) {
        }
        while (rotation < (float)(-Math.PI)) {
            rotation += (float)Math.PI * 2;
        }
        for (f2 = pBlockEntity.rot - pBlockEntity.oRot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        float f3 = pBlockEntity.oRot + f2 * pPartialTick;
        pPoseStack.m_252781_(Axis.f_252436_.m_252961_(-f3));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(80.0f));
        float f4 = Mth.m_14179_((float)pPartialTick, (float)pBlockEntity.oFlip, (float)pBlockEntity.flip);
        float f5 = Mth.m_14187_((float)(f4 + 0.25f)) * 1.6f - 0.3f;
        float f6 = Mth.m_14187_((float)(f4 + 0.75f)) * 1.6f - 0.3f;
        float f7 = Mth.m_14179_((float)pPartialTick, (float)pBlockEntity.oOpen, (float)pBlockEntity.open);
        this.bookModel.m_102292_(f1, Mth.m_14036_((float)f5, (float)0.0f, (float)1.0f), Mth.m_14036_((float)f6, (float)0.0f, (float)1.0f), f7);
        VertexConsumer vertexConsumer = pBuffer.m_6299_(RenderType.m_110452_((ResourceLocation)BOOK_LOCATION));
        this.bookModel.m_102316_(pPoseStack, vertexConsumer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
        float orbitRadius = 0.5f;
        float orbitSpeedMultiplier = 0.05f;
        if (pBlockEntity.isAnimating()) {
            long currentTime = System.currentTimeMillis();
            long animationDuration = currentTime - pBlockEntity.getAnimationStartTime();
            float animationProgress = Math.min((float)animationDuration / 8000.0f, 1.0f);
            float baseRadius = 0.5f;
            float maxRadius = 1.0f;
            orbitRadius = baseRadius + (maxRadius - baseRadius) * (1.0f - 4.0f * (animationProgress * 1.25f - 0.5f) * (animationProgress * 1.25f - 0.5f));
            orbitRadius = Math.max(0.0f, orbitRadius);
            orbitSpeedMultiplier = 0.05f + -(96.0f * (animationProgress * animationProgress));
        }
        this.renderGems(pPoseStack, pBlockEntity, f1, pPackedLight, pPackedOverlay, pBuffer, orbitRadius, orbitSpeedMultiplier);
    }
}

