/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.effect.effects;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.VoidPacketS2C;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;

public class CurseOfEndingEffect
extends MobEffect {
    public CurseOfEndingEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity.m_9236_().f_46443_ && pLivingEntity.f_19797_ % 20 == 0) {
            int effectColor = this.m_19484_();
            float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(effectColor & 0xFF) / 255.0f;
            for (int i = 0; i < 5; ++i) {
                pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
            }
        }
        if (!pLivingEntity.m_9236_().f_46443_ && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (pLivingEntity.f_19797_ % 20 == 0) {
                int effectColor = this.m_19484_();
                float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(effectColor & 0xFF) / 255.0f;
                for (int i = 0; i < 5; ++i) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
                }
            }
            int teleportCooldown = this.getTeleportCooldown(player);
            if (pAmplifier >= 1 && teleportCooldown <= 0) {
                CurseOfEndingEffect.randomTeleport(player, pAmplifier);
                CurseOfEndingEffect.giveConfusion(player, 100);
                int minTeleportTime = CurseOfEndingEffect.getMinTeleportTime(pAmplifier);
                int maxTeleportTime = CurseOfEndingEffect.getMaxTeleportTime(pAmplifier);
                teleportCooldown = minTeleportTime + player.m_217043_().m_188503_(maxTeleportTime - minTeleportTime + 1);
                this.setTeleportCooldown(player, teleportCooldown);
            } else {
                this.setTeleportCooldown(player, --teleportCooldown);
            }
            int voidTimer = CurseOfEndingEffect.getVoidTimer(player);
            int voidCooldown = CurseOfEndingEffect.getVoidCooldown(player);
            if (pAmplifier >= 2 && voidCooldown <= 0) {
                if (voidTimer > 0) {
                    MobEffectInstance levitationEffect = player.m_21124_(MobEffects.f_19620_);
                    if (levitationEffect == null) {
                        CurseOfEndingEffect.giveLevitation(player, voidTimer);
                    }
                    this.attractEntities(player);
                    this.setVoidTimer(player, voidTimer - 1);
                } else if (voidTimer == 0) {
                    this.resetVoid(player);
                } else {
                    this.startVoidEffect(player);
                }
            } else {
                this.setVoidCooldown(player, voidCooldown - 1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (CurseOfEndingEffect.isVoid(player)) {
                    ModNetworking.sendToPlayer(new VoidPacketS2C(true, CurseOfEndingEffect.getVoidTimer(player), CurseOfEndingEffect.getTotalVoidLifetime(player)), serverPlayer);
                } else {
                    ModNetworking.sendToPlayer(new VoidPacketS2C(false, 0, 0), serverPlayer);
                }
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            this.resetTeleportCooldown(player);
        }
    }

    public boolean m_6584_(int duration, int pAmplifier) {
        return true;
    }

    public static double getTeleportChance(int pAmplifier) {
        double[] teleportChanceValues = new double[]{0.25, 0.33, 0.5};
        int index = Math.min(pAmplifier, teleportChanceValues.length - 1);
        return teleportChanceValues[index];
    }

    private static int getMinTeleportTime(int pAmplifier) {
        int[] minTeleportTimeValues = new int[]{600, 300, 200};
        int index = Math.min(pAmplifier, minTeleportTimeValues.length - 1);
        return minTeleportTimeValues[index];
    }

    private static int getMaxTeleportTime(int pAmplifier) {
        int[] maxTeleportTimeValues = new int[]{2400, 1200, 600};
        int index = Math.min(pAmplifier, maxTeleportTimeValues.length - 1);
        return maxTeleportTimeValues[index];
    }

    private void setTeleportCooldown(Player player, int cooldown) {
        player.getPersistentData().m_128405_("teleportCooldown", cooldown);
    }

    private int getTeleportCooldown(Player player) {
        return player.getPersistentData().m_128451_("teleportCooldown");
    }

    private void resetTeleportCooldown(Player player) {
        player.getPersistentData().m_128473_("teleportCooldown");
    }

    private void setVoidCooldown(Player player, int cooldown) {
        player.getPersistentData().m_128405_("voidCooldown", cooldown);
    }

    private static int getVoidCooldown(Player player) {
        return player.getPersistentData().m_128451_("voidCooldown");
    }

    private void resetVoidCooldown(Player player) {
        player.getPersistentData().m_128473_("voidCooldown");
        this.setVoidCooldown(player, 300 + player.m_217043_().m_188503_(301));
    }

    public static int getTotalVoidLifetime(Player player) {
        return player.getPersistentData().m_128451_("totalVoidLifetime");
    }

    private void setVoidTimer(Player player, int timer) {
        player.getPersistentData().m_128405_("voidTimer", timer);
        if (!player.getPersistentData().m_128441_("totalVoidLifetime") || player.getPersistentData().m_128451_("totalVoidLifetime") == 0) {
            player.getPersistentData().m_128405_("totalVoidLifetime", timer);
        }
    }

    private static int getVoidTimer(Player player) {
        return player.getPersistentData().m_128451_("voidTimer");
    }

    public static boolean isVoid(Player player) {
        return CurseOfEndingEffect.getVoidTimer(player) > 0 && CurseOfEndingEffect.getVoidCooldown(player) <= 0;
    }

    private void resetVoidTimer(Player player) {
        player.getPersistentData().m_128473_("voidTimer");
        this.setVoidTimer(player, 100 + player.m_217043_().m_188503_(101));
    }

    private void startVoidEffect(Player player) {
        int totalVoidDuration = 100 + player.m_217043_().m_188503_(101);
        player.getPersistentData().m_128405_("totalVoidLifetime", totalVoidDuration);
        this.setVoidTimer(player, totalVoidDuration);
    }

    private void resetVoid(Player player) {
        this.resetVoidCooldown(player);
        this.resetVoidTimer(player);
        player.getPersistentData().m_128473_("totalVoidLifetime");
    }

    public static void randomTeleport(Player player, int pAmplifier) {
        for (int i = 0; i < 16; ++i) {
            double x = player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
            double y = Mth.m_14008_((double)(player.m_20186_() + (double)(player.m_217043_().m_188503_(16) - 8)), (double)0.0, (double)(player.m_9236_().m_151558_() - 1));
            double z = player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 16.0;
            if (player.m_20159_()) {
                player.m_8127_();
            }
            if (!player.m_20984_(x, y, z, true)) continue;
            player.m_9236_().m_6263_(null, player.f_19854_, player.f_19855_, player.f_19856_, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
            CurseOfEndingEffect.spawnEndermiteSwarm(player, pAmplifier);
            break;
        }
    }

    private static int getMaxEndermite(int pAmplifier) {
        int[] maxEndermiteValues = new int[]{2, 4, 8};
        int index = Math.min(pAmplifier, maxEndermiteValues.length - 1);
        return maxEndermiteValues[index];
    }

    private static double getEndermiteChance(int pAmplifier) {
        double[] endermiteChanceValues = new double[]{0.25, 0.5, 0.8};
        int index = Math.min(pAmplifier, endermiteChanceValues.length - 1);
        return endermiteChanceValues[index];
    }

    public static void spawnEndermiteSwarm(Player player, int pAmplifier) {
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        int endermiteCounter = 0;
        CurseOfEndingEffect.spawnSingleEndermite(player, serverLevel);
        ++endermiteCounter;
        if (pAmplifier >= 2) {
            CurseOfEndingEffect.spawnSingleEndermite(player, serverLevel);
            ++endermiteCounter;
        }
        int maxExtraMites = CurseOfEndingEffect.getMaxEndermite(pAmplifier);
        double spawnChance = CurseOfEndingEffect.getEndermiteChance(pAmplifier);
        for (int i = 1; i < maxExtraMites && player.m_217043_().m_188500_() < spawnChance; ++i) {
            CurseOfEndingEffect.spawnSingleEndermite(player, serverLevel);
            spawnChance *= 0.66;
            if (++endermiteCounter < 4 || !CurseOfEndingEffect.canSpawnEnderman(player, serverLevel)) continue;
            if (CurseOfEndingEffect.canSpawnEnderman(player, serverLevel)) {
                CurseOfEndingEffect.spawnEnderman(player, serverLevel);
            }
            endermiteCounter = 0;
        }
        if (endermiteCounter >= 4 && CurseOfEndingEffect.canSpawnEnderman(player, serverLevel)) {
            CurseOfEndingEffect.spawnEnderman(player, serverLevel);
        }
    }

    private static void spawnSingleEndermite(Player player, ServerLevel serverLevel) {
        Endermite endermite = (Endermite)EntityType.f_20567_.m_20615_((Level)serverLevel);
        if (endermite != null) {
            endermite.m_7678_(player.f_19854_, player.f_19855_, player.f_19856_, player.m_146908_(), player.m_146909_());
            serverLevel.m_7967_((Entity)endermite);
        }
    }

    private static boolean canSpawnEnderman(Player player, ServerLevel serverLevel) {
        int nearbyEndermenCount = serverLevel.m_45976_(EnderMan.class, player.m_20191_().m_82400_(18.0)).size();
        return nearbyEndermenCount < 3;
    }

    private static void spawnEnderman(Player player, ServerLevel serverLevel) {
        EnderMan enderman = (EnderMan)EntityType.f_20566_.m_20615_((Level)serverLevel);
        if (enderman != null) {
            enderman.m_7678_(player.f_19854_, player.f_19855_, player.f_19856_, player.m_146908_(), player.m_146909_());
            enderman.m_6710_((LivingEntity)player);
            enderman.m_21561_(true);
            serverLevel.m_7967_((Entity)enderman);
            serverLevel.m_6263_(null, enderman.m_20185_(), enderman.m_20186_(), enderman.m_20189_(), SoundEvents.f_11851_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    public static void giveConfusion(Player player, int durationTicks) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, durationTicks, 2, false, false, false));
    }

    public static void giveLevitation(Player player, int durationTicks) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, durationTicks, 2, false, false, false));
    }

    private void attractEntities(Player player) {
        Level level = player.m_9236_();
        List nearbyEntities = level.m_45933_((Entity)player, player.m_20191_().m_82400_(10.0));
        for (Entity entity : nearbyEntities) {
            if (entity == player) continue;
            Vec3 direction = new Vec3(player.m_20185_() - entity.m_20185_(), player.m_20186_() - entity.m_20186_(), player.m_20189_() - entity.m_20189_()).m_82541_();
            entity.m_20256_(entity.m_20184_().m_82549_(direction.m_82490_(0.25)));
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 5, 0.0, 0.0, 0.0, 0.1);
        }
    }
}

