/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.effect.effects;

import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.turtleboi.ancientcurses.item.ModItems;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;

public class CurseOfGluttonyEffect
extends MobEffect {
    private int starvationCounter = 0;

    public CurseOfGluttonyEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity.m_9236_().f_46443_ && pLivingEntity.f_19797_ % 20 == 0) {
            int effectColor = this.m_19484_();
            float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(effectColor & 0xFF) / 255.0f;
            for (int i = 0; i < 5; ++i) {
                pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
            }
        }
        if (!pLivingEntity.m_9236_().f_46443_ && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (pLivingEntity.f_19797_ % 20 == 0) {
                int effectColor = this.m_19484_();
                float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(effectColor & 0xFF) / 255.0f;
                for (int i = 0; i < 5; ++i) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
                }
            }
            this.adjustHunger(player, pAmplifier);
            this.spoilFoodInInventory(player, pAmplifier);
            this.checkStarvationDamage(player);
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
        }
    }

    public boolean m_6584_(int duration, int pAmplifier) {
        return true;
    }

    private void adjustHunger(Player player, int amplifier) {
        float extraExhaustion = this.getHungerMultiplier(amplifier);
        player.m_36399_(0.005f * extraExhaustion);
    }

    private float getHungerMultiplier(int pAmplifier) {
        float[] hungerDrainMultiplier = new float[]{10.0f, 17.5f, 25.0f};
        int index = Math.min(pAmplifier, hungerDrainMultiplier.length - 1);
        return hungerDrainMultiplier[index];
    }

    private void spoilFoodInInventory(Player player, int pAmplifier) {
        int spoilTime = this.getSpoilTimer(pAmplifier);
        for (ItemStack stack : player.m_150109_().f_35974_) {
            int currentSpoilTime;
            if (!stack.m_41614_() || stack.m_41720_().equals(ModItems.ROT_CLUMP.get())) continue;
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("SpoilTimer")) {
                stack.m_41784_().m_128405_("SpoilTimer", 0);
            }
            if ((currentSpoilTime = stack.m_41783_().m_128451_("SpoilTimer")) >= spoilTime) {
                stack.m_41774_(1);
                player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.ROT_CLUMP.get()));
                continue;
            }
            stack.m_41783_().m_128405_("SpoilTimer", currentSpoilTime + 1);
        }
    }

    private int getSpoilTimer(int pAmplifier) {
        int[] spoilTimeValues = new int[]{2400, 1200, 600};
        int index = Math.min(pAmplifier, spoilTimeValues.length - 1);
        return spoilTimeValues[index];
    }

    private void checkStarvationDamage(Player player) {
        FoodData foodData = player.m_36324_();
        Level level = player.m_9236_();
        int hungerLevel = foodData.m_38702_();
        if (hungerLevel <= 6) {
            player.m_5661_((Component)Component.m_237113_((String)"You feel ravenous...").m_130940_(ChatFormatting.RED), true);
            ++this.starvationCounter;
            int starvationInterval = 80;
            if (this.starvationCounter >= starvationInterval) {
                this.starvationCounter = 0;
                int starvationDamage = 1 + (6 - hungerLevel) / 2;
                player.m_6469_(level.m_269111_().m_269064_(), (float)starvationDamage);
            }
        } else {
            this.starvationCounter = 0;
        }
    }

    public static void modifyFoodRestoration(Player player, ItemStack foodStack, int pAmplifier) {
        FoodProperties foodProperties = foodStack.m_41720_().getFoodProperties(foodStack, (LivingEntity)player);
        if (foodProperties != null) {
            int baseHunger = foodProperties.m_38744_();
            float baseSaturation = foodProperties.m_38745_();
            float[] newRestorationValues = new float[]{1.0f, 0.66f, 0.33f};
            int index = Math.min(pAmplifier, newRestorationValues.length - 1);
            int newHunger = Math.round((float)baseHunger * newRestorationValues[index]);
            float newSaturation = baseSaturation * newRestorationValues[index];
            player.m_36324_().m_38707_(newHunger, newSaturation);
        }
    }
}

