/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.effect.effects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.turtleboi.ancientcurses.effect.ModEffects;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;

public class CurseOfPestilenceEffect
extends MobEffect {
    public CurseOfPestilenceEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity.m_9236_().f_46443_ && pLivingEntity.f_19797_ % 20 == 0) {
            int effectColor = this.m_19484_();
            float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(effectColor & 0xFF) / 255.0f;
            for (int i = 0; i < 5; ++i) {
                pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
            }
        }
        if (!pLivingEntity.m_9236_().f_46443_ && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (pLivingEntity.f_19797_ % 20 == 0) {
                int effectColor = this.m_19484_();
                float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(effectColor & 0xFF) / 255.0f;
                for (int i = 0; i < 5; ++i) {
                    pLivingEntity.m_9236_().m_7106_((ParticleOptions)ModParticleTypes.CURSED_PARTICLE.get(), pLivingEntity.m_20185_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), pLivingEntity.m_20186_() + pLivingEntity.m_217043_().m_188500_() * (double)pLivingEntity.m_20206_(), pLivingEntity.m_20189_() + (pLivingEntity.m_217043_().m_188500_() - 0.5) * (double)pLivingEntity.m_20205_(), (double)red, (double)green, (double)blue);
                }
            }
            int pestilenceCooldown = this.getPestilenceCooldown(player);
            int minTimeInterval = CurseOfPestilenceEffect.getMinTimeInterval(pAmplifier);
            int maxTimeInterval = CurseOfPestilenceEffect.getMaxTimeInterval(pAmplifier);
            if (pestilenceCooldown <= 0) {
                this.applyNewDebuff(player, pAmplifier);
                if (pAmplifier >= 1) {
                    this.upgradeExistingDebuff(player, pAmplifier);
                }
                this.setPestilenceCooldown(player, minTimeInterval + player.m_217043_().m_188503_(maxTimeInterval - minTimeInterval + 1));
            } else {
                this.setPestilenceCooldown(player, pestilenceCooldown - 1);
            }
            if (pAmplifier >= 2) {
                this.applyDebuffsToNearbyMobs(player);
            }
        }
        super.m_6742_(pLivingEntity, pAmplifier);
    }

    public void m_6386_(LivingEntity pLivingEntity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            this.removeCurseDebuffs(player);
            this.resetPestilenceCooldown(player);
        }
    }

    public boolean m_6584_(int duration, int pAmplifier) {
        return true;
    }

    private static int getMinTimeInterval(int pAmplifier) {
        int[] timeIntervalValues = new int[]{800, 400, 200};
        int index = Math.min(pAmplifier, timeIntervalValues.length - 1);
        return timeIntervalValues[index];
    }

    private static int getMaxTimeInterval(int pAmplifier) {
        int[] timeIntervalValues = new int[]{1200, 600, 300};
        int index = Math.min(pAmplifier, timeIntervalValues.length - 1);
        return timeIntervalValues[index];
    }

    private void setPestilenceCooldown(Player player, int cooldown) {
        player.getPersistentData().m_128405_("pestilenceCooldown", cooldown);
    }

    private int getPestilenceCooldown(Player player) {
        return player.getPersistentData().m_128451_("pestilenceCooldown");
    }

    private void resetPestilenceCooldown(Player player) {
        player.getPersistentData().m_128473_("pestilenceCooldown");
    }

    private void applyNewDebuff(Player player, int amplifier) {
        List<MobEffect> possibleDebuffs = Arrays.asList(MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19610_, MobEffects.f_19614_, MobEffects.f_19615_, MobEffects.f_19612_, MobEffects.f_19590_);
        MobEffectInstance curseEffect = player.m_21124_((MobEffect)ModEffects.CURSE_OF_PESTILENCE.get());
        if (curseEffect == null) {
            return;
        }
        int curseDuration = curseEffect.m_19557_();
        ArrayList<MobEffect> availableDebuffs = new ArrayList<MobEffect>(possibleDebuffs);
        int debuffsToApply = Math.min(amplifier + 1, availableDebuffs.size());
        int i = 0;
        while (i < debuffsToApply && !availableDebuffs.isEmpty()) {
            int randomIndex = player.m_217043_().m_188503_(availableDebuffs.size());
            MobEffect randomDebuff = (MobEffect)availableDebuffs.get(randomIndex);
            if (player.m_21124_(randomDebuff) == null) {
                player.m_7292_(new MobEffectInstance(randomDebuff, curseDuration, 0));
                ++i;
            }
            availableDebuffs.remove(randomIndex);
        }
    }

    private void upgradeExistingDebuff(Player player, int amplifier) {
        List<MobEffect> possibleDebuffs = Arrays.asList(MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19610_, MobEffects.f_19614_, MobEffects.f_19615_, MobEffects.f_19612_, MobEffects.f_19590_);
        ArrayList<MobEffectInstance> playerDebuffs = new ArrayList<MobEffectInstance>();
        for (MobEffect debuff : possibleDebuffs) {
            MobEffectInstance currentEffect = player.m_21124_(debuff);
            if (currentEffect == null) continue;
            playerDebuffs.add(currentEffect);
        }
        MobEffectInstance curseEffect = player.m_21124_((MobEffect)ModEffects.CURSE_OF_PESTILENCE.get());
        if (curseEffect == null) {
            return;
        }
        int curseDuration = curseEffect.m_19557_();
        if (!playerDebuffs.isEmpty()) {
            ArrayList debuffsToUpgrade = new ArrayList(playerDebuffs);
            int upgradesToApply = Math.min(amplifier, debuffsToUpgrade.size());
            for (int i = 0; i < upgradesToApply && !debuffsToUpgrade.isEmpty(); ++i) {
                int randomIndex = player.m_217043_().m_188503_(debuffsToUpgrade.size());
                MobEffectInstance selectedDebuff = (MobEffectInstance)debuffsToUpgrade.get(randomIndex);
                player.m_7292_(new MobEffectInstance(selectedDebuff.m_19544_(), curseDuration, selectedDebuff.m_19564_() + 1));
                debuffsToUpgrade.remove(randomIndex);
            }
        }
    }

    private void removeCurseDebuffs(Player player) {
        MobEffect[] curseDebuffs;
        for (MobEffect debuff : curseDebuffs = new MobEffect[]{MobEffects.f_19613_, MobEffects.f_19597_, MobEffects.f_19610_, MobEffects.f_19614_, MobEffects.f_19615_, MobEffects.f_19612_, MobEffects.f_19590_}) {
            if (!player.m_21023_(debuff)) continue;
            player.m_21195_(debuff);
        }
    }

    private void applyDebuffsToNearbyMobs(Player player) {
        Level level = player.m_9236_();
        List nearbyMobs = level.m_45976_(LivingEntity.class, player.m_20191_().m_82400_(25.0));
        for (LivingEntity mob : nearbyMobs) {
            if (mob instanceof Monster || mob == player) continue;
            this.applyMobDebuffs(mob, 200);
        }
    }

    private void applyMobDebuffs(LivingEntity mob, int duration) {
        MobEffectInstance[] possibleDebuffs;
        for (MobEffectInstance debuff : possibleDebuffs = new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19613_, duration, 0), new MobEffectInstance(MobEffects.f_19597_, duration, 0), new MobEffectInstance(MobEffects.f_19610_, duration, 0), new MobEffectInstance(MobEffects.f_19614_, duration, 0), new MobEffectInstance(MobEffects.f_19615_, duration, 0), new MobEffectInstance(MobEffects.f_19612_, duration, 0), new MobEffectInstance(MobEffects.f_19590_, duration, 0)}) {
            mob.m_7292_(debuff);
        }
    }
}

