/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.turtleboi.ancientcurses.client.ModRenderTypes;
import net.turtleboi.ancientcurses.client.PlayerClientData;
import net.turtleboi.ancientcurses.client.TrialEventBar;
import net.turtleboi.ancientcurses.effect.ModEffects;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.PortalOverlayPacketC2S;
import net.turtleboi.ancientcurses.network.packets.TrialOverlayPacketC2S;
import net.turtleboi.ancientcurses.util.ItemValueMap;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="ancientcurses", value={Dist.CLIENT})
public class ModClientEvents {
    private static final Random random = new Random();
    private static int ticksElapsed = 0;
    private static final ResourceLocation HUNGER_ICONS = new ResourceLocation("ancientcurses", "textures/gui/hunger_icons.png");

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Minecraft minecraft = Minecraft.m_91087_();
        if (player != null) {
            if (PlayerClientData.getPortalOverlayAlpha().floatValue() > 0.0f) {
                ModNetworking.sendToServer(new PortalOverlayPacketC2S(PlayerClientData.getPortalOverlayAlpha().floatValue()));
                ModClientEvents.renderCursedPortalOverlay(minecraft);
            }
            if (event.getOverlay() == VanillaGuiOverlay.FOOD_LEVEL.type() && player.m_21023_((MobEffect)ModEffects.CURSE_OF_GLUTTONY.get())) {
                event.setCanceled(true);
                ModClientEvents.renderCustomHungerBar(event.getGuiGraphics(), (Player)player);
            }
            if (PlayerClientData.hasTrial()) {
                int screenWidth = minecraft.m_91268_().m_85445_();
                TrialEventBar.render(event.getGuiGraphics(), (screenWidth - 192) / 2, 11, minecraft);
                ModNetworking.sendToServer(new TrialOverlayPacketC2S());
            }
            if (event.getOverlay() == VanillaGuiOverlay.BOSS_EVENT_PROGRESS.type() && PlayerClientData.hasTrial()) {
                event.setCanceled(true);
            }
            if (player.m_21023_((MobEffect)ModEffects.CURSE_OF_OBESSSION.get())) {
                ModClientEvents.renderPinkOverlay(event.getGuiGraphics());
            }
            if (player.m_21023_((MobEffect)ModEffects.CURSE_OF_ENDING.get())) {
                ModClientEvents.renderPurpleOverlay(event.getGuiGraphics());
            }
        }
    }

    @SubscribeEvent
    public static void onCustomizeBossEventProgress(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (PlayerClientData.hasTrial()) {
            int originalY = event.getY();
            event.setIncrement(event.getIncrement() + 9 + 5);
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        CompoundTag itemTag;
        Level level;
        ItemStack itemStack = event.getItemStack();
        Level level2 = level = event.getEntity() != null ? event.getEntity().m_9236_() : null;
        if (level != null) {
            int itemValue = ItemValueMap.getItemValue(itemStack, level);
            int n = itemValue * itemStack.m_41613_();
        }
        if (level != null && itemStack.m_41782_() && (itemTag = itemStack.m_41783_()) != null && itemTag.m_128471_("Socketable")) {
            if (itemTag != null) {
                if (itemTag.m_128441_("MainGem")) {
                    ItemStack mainGemStack = ItemStack.m_41712_((CompoundTag)itemTag.m_128469_("MainGem"));
                    event.getToolTip().add(Component.m_237113_((String)("Main Gem: " + mainGemStack.m_41786_().getString())).m_130940_(ChatFormatting.GOLD));
                } else {
                    event.getToolTip().add(Component.m_237113_((String)"Main Gem: None").m_130940_(ChatFormatting.GRAY));
                }
                if (itemTag.m_128441_("MinorGems")) {
                    ListTag minorGems = itemTag.m_128437_("MinorGems", 10);
                    if (!minorGems.isEmpty()) {
                        event.getToolTip().add(Component.m_237113_((String)"Minor Gems:").m_130940_(ChatFormatting.GREEN));
                        for (int i = 0; i < minorGems.size(); ++i) {
                            ItemStack minorGemStack = ItemStack.m_41712_((CompoundTag)minorGems.m_128728_(i));
                            event.getToolTip().add(Component.m_237113_((String)("  - " + minorGemStack.m_41786_().getString())).m_130940_(ChatFormatting.YELLOW));
                        }
                    } else {
                        event.getToolTip().add(Component.m_237113_((String)"Minor Gems: None").m_130940_(ChatFormatting.GRAY));
                    }
                } else {
                    event.getToolTip().add(Component.m_237113_((String)"Minor Gems: None").m_130940_(ChatFormatting.GRAY));
                }
            } else {
                event.getToolTip().add(Component.m_237113_((String)"Main Gem: None").m_130940_(ChatFormatting.GRAY));
                event.getToolTip().add(Component.m_237113_((String)"Minor Gems: None").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        Player player = event.getEntity();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        if (PlayerClientData.isVoid()) {
            ModClientEvents.renderLightBeams(player, poseStack, (MultiBufferSource)bufferSource, event.getPartialTick());
        }
        bufferSource.m_109911_();
    }

    @SubscribeEvent
    public static void onRenderTick(RenderLevelStageEvent event) {
        if (PlayerClientData.getCameraShakeDuration() > 0) {
            ModClientEvents.applyShake(event);
        }
    }

    private static void applyShake(RenderLevelStageEvent event) {
        if (PlayerClientData.getCameraShakeDuration() <= 0) {
            return;
        }
        if (++ticksElapsed > PlayerClientData.getCameraShakeDuration()) {
            PlayerClientData.setCameraShakeIntensity(0.0f);
            PlayerClientData.setCameraShakeDuration(0);
            ticksElapsed = 0;
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91073_ == null) {
            return;
        }
        float currentIntensity = PlayerClientData.getCameraShakeIntensity().floatValue() * (1.0f - (float)ticksElapsed / (float)PlayerClientData.getCameraShakeDuration().intValue());
        double offsetX = (random.nextDouble() - 0.5) * 2.0 * (double)currentIntensity;
        double offsetY = (random.nextDouble() - 0.5) * 2.0 * (double)currentIntensity;
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85837_(offsetX, offsetY, 0.0);
    }

    private static void renderCustomHungerBar(GuiGraphics guiGraphics, Player player) {
        Minecraft minecraft = Minecraft.m_91087_();
        FoodData foodData = player.m_36324_();
        int foodLevel = foodData.m_38702_();
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        int xStart = screenWidth / 2 + 91;
        int yStart = screenHeight - 39;
        boolean isGluttonous = player.m_21023_((MobEffect)ModEffects.CURSE_OF_GLUTTONY.get());
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            int x = xStart - i * 8 - 9;
            int y = yStart;
            if (isGluttonous && random.nextFloat() < 0.1f) {
                x += random.nextInt(3) - 1;
                y += random.nextInt(3) - 1;
            }
            guiGraphics.m_280163_(HUNGER_ICONS, x, y, 18.0f, 0.0f, 9, 9, 27, 9);
            if (i * 2 + 1 < foodLevel) {
                guiGraphics.m_280163_(HUNGER_ICONS, x, y, 0.0f, 0.0f, 9, 9, 27, 9);
                continue;
            }
            if (i * 2 + 1 != foodLevel) continue;
            guiGraphics.m_280163_(HUNGER_ICONS, x, y, 9.0f, 0.0f, 9, 9, 27, 9);
        }
    }

    private static void renderPinkOverlay(GuiGraphics guiGraphics) {
        if (PlayerClientData.isLusted()) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft minecraft = Minecraft.m_91087_();
            int screenWidth = minecraft.m_91268_().m_85445_();
            int screenHeight = minecraft.m_91268_().m_85446_();
            guiGraphics.m_280509_(0, 0, screenWidth, screenHeight, FastColor.ARGB32.m_13660_((int)8, (int)255, (int)20, (int)147));
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    private static void renderPurpleOverlay(GuiGraphics guiGraphics) {
        if (PlayerClientData.isVoid()) {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft minecraft = Minecraft.m_91087_();
            int screenWidth = minecraft.m_91268_().m_85445_();
            int screenHeight = minecraft.m_91268_().m_85446_();
            guiGraphics.m_280509_(0, 0, screenWidth, screenHeight, FastColor.ARGB32.m_13660_((int)4, (int)54, (int)1, (int)63));
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    public static void renderLightBeams(Player player, PoseStack poseStack, MultiBufferSource bufferSource, float pPartialTicks) {
        int totalLifetime = PlayerClientData.getTotalVoidTime();
        int currentLifetime = PlayerClientData.getVoidTimer();
        if (totalLifetime <= 0 || currentLifetime <= 0 || currentLifetime > totalLifetime) {
            return;
        }
        float beamLife = (float)(totalLifetime - currentLifetime) / (float)totalLifetime;
        float beamIntensity = beamLife * 2.0f;
        RandomSource randomsource = RandomSource.m_216335_((long)432L);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(ModRenderTypes.getPlayerBeam());
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, player.m_20206_() / 2.0f, 0.0f);
        float beamSpawnRate = 10.0f;
        int beamCount = Math.min(20, (int)((float)(totalLifetime - currentLifetime) / beamSpawnRate));
        long gameTime = player.m_9236_().m_46467_();
        for (int i = 0; i < beamCount; ++i) {
            float randomRotationX = randomsource.m_188501_() * 360.0f;
            float randomRotationY = randomsource.m_188501_() * 360.0f;
            float randomRotationZ = randomsource.m_188501_() * 360.0f;
            float timeRotationFactor = ((float)gameTime + pPartialTicks) * 1.5f;
            poseStack.m_252781_(Axis.f_252529_.m_252977_(randomRotationX + timeRotationFactor));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(randomRotationY + timeRotationFactor));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(randomRotationZ + timeRotationFactor));
            float baseBeamLength = 0.1f;
            float maxBeamLength = 5.0f;
            float baseBeamWidth = 0.1f;
            float maxBeamWidth = 2.0f;
            float beamLength = baseBeamLength + (maxBeamLength - baseBeamLength) * beamLife + randomsource.m_188501_() * 0.5f;
            float beamWidth = baseBeamWidth + (maxBeamWidth - baseBeamWidth) * beamLife + randomsource.m_188501_() * 0.2f;
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            int alpha = Mth.m_14045_((int)((int)(64.0f + 191.0f * beamIntensity)), (int)0, (int)255);
            ModClientEvents.vertex01(vertexconsumer, matrix4f, alpha);
            ModClientEvents.vertex2(vertexconsumer, matrix4f, beamLength, beamWidth);
            ModClientEvents.vertex3(vertexconsumer, matrix4f, beamLength, beamWidth);
            ModClientEvents.vertex01(vertexconsumer, matrix4f, alpha);
            ModClientEvents.vertex3(vertexconsumer, matrix4f, beamLength, beamWidth);
            ModClientEvents.vertex4(vertexconsumer, matrix4f, beamLength, beamWidth);
            ModClientEvents.vertex01(vertexconsumer, matrix4f, alpha);
            ModClientEvents.vertex4(vertexconsumer, matrix4f, beamLength, beamWidth);
            ModClientEvents.vertex2(vertexconsumer, matrix4f, beamLength, beamWidth);
        }
        poseStack.m_85849_();
    }

    private static void vertex01(VertexConsumer pConsumer, Matrix4f pMatrix, int pAlpha) {
        pConsumer.m_252986_(pMatrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, pAlpha).m_5752_();
    }

    private static void vertex2(VertexConsumer pConsumer, Matrix4f pMatrix, float pX, float pZ) {
        pConsumer.m_252986_(pMatrix, -1.0f * (float)(Math.sqrt(3.0) / 2.0) * pZ, pX, -0.5f * pZ).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer pConsumer, Matrix4f pMatrix, float pX, float pZ) {
        pConsumer.m_252986_(pMatrix, (float)(Math.sqrt(3.0) / 2.0) * pZ, pX, -0.5f * pZ).m_6122_(255, 0, 255, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer pConsumer, Matrix4f pMatrix, float pX, float pZ) {
        pConsumer.m_252986_(pMatrix, 0.0f, pX, pZ).m_6122_(255, 0, 255, 0).m_5752_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderCursedPortalOverlay(Minecraft minecraft) {
        float alpha = PlayerClientData.getPortalOverlayAlpha().floatValue();
        if (alpha <= 0.0f) {
            return;
        }
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        try {
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)alpha);
            ResourceLocation portalTexture = new ResourceLocation("minecraft", "textures/block/nether_portal.png");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)portalTexture);
            long time = minecraft.f_91073_.m_46467_();
            int totalFrames = 32;
            int frame = (int)(time % (long)totalFrames);
            float frameHeight = 1.0f / (float)totalFrames;
            float vMin = (float)frame * frameHeight;
            float vMax = vMin + frameHeight;
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, vMax).m_5752_();
            buffer.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, vMax).m_5752_();
            buffer.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, vMin).m_5752_();
            buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, vMin).m_5752_();
            Tesselator.m_85913_().m_85914_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            poseStack.m_85849_();
        }
    }
}

