/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.event;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.turtleboi.ancientcurses.ai.AnimalFollowPlayerGoal;
import net.turtleboi.ancientcurses.ai.FishFollowPlayerGoal;
import net.turtleboi.ancientcurses.block.entity.CursedAltarBlockEntity;
import net.turtleboi.ancientcurses.effect.CurseRegistry;
import net.turtleboi.ancientcurses.effect.ModEffects;
import net.turtleboi.ancientcurses.effect.effects.CurseOfAvariceEffect;
import net.turtleboi.ancientcurses.effect.effects.CurseOfEndingEffect;
import net.turtleboi.ancientcurses.effect.effects.CurseOfEnvyEffect;
import net.turtleboi.ancientcurses.effect.effects.CurseOfGluttonyEffect;
import net.turtleboi.ancientcurses.effect.effects.CurseOfNatureEffect;
import net.turtleboi.ancientcurses.effect.effects.CurseOfObessionEffect;
import net.turtleboi.ancientcurses.init.ModAttributes;
import net.turtleboi.ancientcurses.item.ModItems;
import net.turtleboi.ancientcurses.item.items.GoldenAmuletItem;
import net.turtleboi.ancientcurses.item.items.PreciousGemItem;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.SendParticlesS2C;
import net.turtleboi.ancientcurses.network.packets.SyncTrialDataS2C;
import net.turtleboi.ancientcurses.particle.ModParticleTypes;
import net.turtleboi.ancientcurses.trials.FetchTrial;
import net.turtleboi.ancientcurses.trials.PlayerTrialData;
import net.turtleboi.ancientcurses.trials.Trial;
import net.turtleboi.ancientcurses.trials.TrialRecord;
import net.turtleboi.ancientcurses.util.ItemValueMap;

@Mod.EventBusSubscriber(modid="ancientcurses")
public class ModEvents {
    private static final Random random = new Random();
    private static int tickCounter = random.nextInt(11) + 10;
    public static final TagKey<Block> StoneForge = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "stone"));
    public static final TagKey<Block> CobblestoneForge = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "cobblestone"));
    public static final TagKey<Block> OreForge = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "ores"));

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        BlockPos altarPos = PlayerTrialData.getCurrentAltarPos(player);
        if (altarPos == null) {
            return;
        }
        BlockEntity blockEntity = player.m_9236_().m_7702_(altarPos);
        if (!(blockEntity instanceof CursedAltarBlockEntity)) {
            return;
        }
        CursedAltarBlockEntity altar = (CursedAltarBlockEntity)blockEntity;
        altar.removePlayerFromTrial(player);
        MobEffect curseEffect = PlayerTrialData.getCurseEffect(player);
        if (curseEffect != null) {
            player.m_21195_(curseEffect);
            player.m_7292_(new MobEffectInstance(curseEffect, 2400, PlayerTrialData.getCurseAmplifier(player), false, false, true));
        }
        PlayerTrialData.clearCurrentAltarPos(player);
        PlayerTrialData.clearCurseEffect(player);
        PlayerTrialData.clearCurseAmplifier(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetworking.sendToPlayer(new SyncTrialDataS2C("None", "", 0, 0, 0L, 0L, "", 0, 0), serverPlayer);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!level.f_46443_) {
                for (Player player : level.m_6907_()) {
                    Monster monster;
                    MobEffectInstance lustCurse;
                    int amplifier;
                    MobEffectInstance wrathCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_WRATH.get());
                    if (wrathCurse != null && player.m_20270_((Entity)entity) <= 25.0f && (amplifier = wrathCurse.m_19564_()) >= 1) {
                        Piglin piglin;
                        if (mob instanceof Animal) {
                            Animal animal = (Animal)mob;
                            animal.m_21563_().m_24960_((Entity)player, 30.0f, 30.0f);
                            if (animal.f_21345_.m_25386_().noneMatch(goal -> goal.m_26015_() instanceof FollowMobGoal)) {
                                animal.f_21345_.m_25352_(1, (Goal)new AnimalFollowPlayerGoal(animal, player, 1.25, 25.0));
                            }
                            if ((double)animal.m_20270_((Entity)player) < 1.75 && tickCounter <= 0) {
                                player.m_6469_(level.m_269111_().m_269333_((LivingEntity)animal), 1.0f);
                            }
                        }
                        if (mob instanceof AbstractFish) {
                            AbstractFish fish = (AbstractFish)mob;
                            fish.m_21563_().m_24960_((Entity)player, 30.0f, 30.0f);
                            if (fish.f_21345_.m_25386_().noneMatch(goal -> goal.m_26015_() instanceof FollowMobGoal)) {
                                fish.f_21345_.m_25352_(1, (Goal)new FishFollowPlayerGoal(fish, player, 1.25, 25.0));
                            }
                            if ((double)fish.m_20270_((Entity)player) < 1.75 && tickCounter <= 0) {
                                player.m_6469_(level.m_269111_().m_269333_((LivingEntity)fish), 1.0f);
                            }
                        }
                        if (mob instanceof NeutralMob) {
                            NeutralMob neutralMob = (NeutralMob)mob;
                            if (neutralMob instanceof Monster && !(neutralMob instanceof Piglin) || neutralMob instanceof EnderMan) {
                                return;
                            }
                            if (neutralMob.m_5448_() != player) {
                                neutralMob.m_6710_((LivingEntity)player);
                            }
                        }
                        if (mob instanceof TamableAnimal) {
                            TamableAnimal tameableAnimal = (TamableAnimal)mob;
                            if (!tameableAnimal.m_21824_()) {
                                if (tameableAnimal.m_5448_() != player) {
                                    tameableAnimal.m_6710_((LivingEntity)player);
                                }
                            } else if (tameableAnimal.m_21824_() && tameableAnimal.m_5448_() == player) {
                                tameableAnimal.m_6710_(null);
                            }
                        }
                        if (mob instanceof Piglin && !(piglin = (Piglin)mob).m_5912_() && piglin.m_5448_() != player) {
                            piglin.m_6710_((LivingEntity)player);
                        }
                        if (mob instanceof IronGolem) {
                            IronGolem golem = (IronGolem)mob;
                            if (!golem.m_28876_()) {
                                if (golem.m_5448_() != player) {
                                    golem.m_6710_((LivingEntity)player);
                                }
                            } else if (golem.m_28876_() && golem.m_5448_() == player) {
                                golem.m_6710_(null);
                            }
                        }
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            if (tickCounter <= 0) {
                                ModNetworking.sendToPlayer(new SendParticlesS2C((ParticleOptions)ParticleTypes.f_123792_, mob.m_20185_(), mob.m_20188_() + 0.25, mob.m_20189_(), 0.1, 0.25, 0.1, 3, 1.0), serverPlayer);
                                tickCounter = random.nextInt(11) + 10;
                            } else {
                                --tickCounter;
                            }
                        }
                    }
                    if (!(mob instanceof Monster) || (lustCurse = (monster = (Monster)mob).m_21124_((MobEffect)ModEffects.CURSE_OF_OBESSSION.get())) == null || !(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (tickCounter <= 0) {
                        ModNetworking.sendToPlayer(new SendParticlesS2C((ParticleOptions)ParticleTypes.f_123750_, mob.m_20185_(), mob.m_20188_() + 0.25, mob.m_20189_(), 0.1, 0.25, 0.1, 3, 1.0), serverPlayer);
                        tickCounter = random.nextInt(11) + 10;
                        continue;
                    }
                    --tickCounter;
                }
                if (mob.getPersistentData().m_128441_("curseoflustgiveruuid")) {
                    UUID curseGiverUUID = mob.getPersistentData().m_128342_("curseoflustgiveruuid");
                    Player curseGiver = mob.m_9236_().m_46003_(curseGiverUUID);
                    if (curseGiver == null || curseGiver.m_21224_()) {
                        CurseOfObessionEffect.removeTarget(mob);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAttack(LivingAttackEvent event) {
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            MobEffectInstance lustCurse;
            AttributeInstance hitChanceAttribute;
            Player player = (Player)entity;
            MobEffectInstance envyCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_ENVY.get());
            if (envyCurse != null) {
                EquipmentSlot slot;
                ItemStack DiscardItem;
                double itemDropOnUseChance = CurseOfEnvyEffect.getItemDropOnUseChance(envyCurse.m_19564_());
                double randomValue2 = player.m_217043_().m_188500_();
                if (randomValue2 < itemDropOnUseChance && (DiscardItem = player.m_6844_(slot = EquipmentSlot.MAINHAND)) != ItemStack.f_41583_ && !player.m_9236_().f_46443_) {
                    player.m_36176_(DiscardItem, false);
                    player.m_8061_(slot, ItemStack.f_41583_);
                }
            }
            if ((hitChanceAttribute = player.m_21051_((Attribute)ModAttributes.HIT_CHANCE.get())) != null) {
                double hitChance = hitChanceAttribute.m_22135_();
                double randomValue = player.m_217043_().m_188500_();
                if (randomValue > hitChance) {
                    event.setCanceled(true);
                }
                LivingEntity target = event.getEntity();
                Level level = target.m_9236_();
                if (event.isCanceled() && target != null) {
                    double x = target.m_20185_();
                    double y = target.m_20186_() + (double)target.m_20206_() / 2.0;
                    double z = target.m_20189_();
                    for (int i = 0; i < 10; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x + (player.m_217043_().m_188500_() - 0.5), y + (player.m_217043_().m_188500_() - 0.5), z + (player.m_217043_().m_188500_() - 0.5), 0.0, 0.0, 0.0);
                    }
                }
            }
            if ((lustCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_OBESSSION.get())) != null) {
                int amplifier = lustCurse.m_19564_();
                float damage = event.getAmount();
                float reflectDamage = damage * (0.1f + 0.1f * (float)amplifier);
                reflectDamage = Math.max(1.0f, reflectDamage);
                player.m_6469_(new DamageSource(player.m_9236_().m_269111_().m_269264_().m_269150_()), reflectDamage);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack itemStack = event.getItem();
            if (itemStack.m_41614_()) {
                FoodProperties foodProperties = itemStack.m_41720_().getFoodProperties(itemStack, (LivingEntity)player);
                MobEffectInstance curseEffect = player.m_21124_((MobEffect)ModEffects.CURSE_OF_GLUTTONY.get());
                if (curseEffect != null && foodProperties != null) {
                    int baseHunger = foodProperties.m_38744_();
                    float baseSaturation = foodProperties.m_38745_();
                    int amplifier = curseEffect.m_19564_();
                    player.m_36324_().m_38707_(-baseHunger, -baseSaturation);
                    CurseOfGluttonyEffect.modifyFoodRestoration(player, itemStack, amplifier);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void EntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getEntity() instanceof Player) {
            ItemEntity itemEntity = event.getItem();
            ItemStack itemStack = itemEntity.m_32055_();
            Player player = event.getEntity();
            Level level = player.m_9236_();
            MobEffectInstance greedCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_AVARICE.get());
            if (greedCurse != null) {
                double itemDestroyChance;
                CurseOfAvariceEffect.resetInventoryValue(player);
                int amplifier = greedCurse.m_19564_();
                if (amplifier >= 0) {
                    int itemValue = ItemValueMap.getItemValue(itemStack, player.m_9236_());
                    int stackSize = itemStack.m_41613_();
                    int valueBasedAmplifier = Math.min(itemValue * stackSize / 100 - 1, 4);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60 * (1 + valueBasedAmplifier), valueBasedAmplifier, false, true));
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60 * (1 + valueBasedAmplifier), valueBasedAmplifier, false, true));
                }
                if (amplifier >= 1 && (itemDestroyChance = CurseOfAvariceEffect.getItemDestroyChance(amplifier)) != 0.0) {
                    int stackSize = itemStack.m_41613_();
                    for (int i = 0; i < stackSize; ++i) {
                        double randomValue = player.m_217043_().m_188500_();
                        if (!(randomValue <= itemDestroyChance)) continue;
                        itemStack.m_41774_(1);
                        double x = player.m_20185_();
                        double y = player.m_20186_() + (double)player.m_20206_() / 2.0;
                        double z = player.m_20189_();
                        for (int j = 0; j < 10; ++j) {
                            level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x + (player.m_217043_().m_188500_() - 0.5), y + (player.m_217043_().m_188500_() - 0.5), z + (player.m_217043_().m_188500_() - 0.5), 0.0, 0.1, 0.0);
                        }
                        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.AMBIENT, 1.0f, 1.0f);
                        player.m_150109_().m_36054_(new ItemStack((ItemLike)ModItems.ROT_CLUMP.get()));
                        player.m_5661_((Component)Component.m_237113_((String)"How unlucky...").m_130940_(ChatFormatting.RED), true);
                    }
                    if (itemStack.m_41619_()) {
                        itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        CurseOfAvariceEffect.resetInventoryValue(player);
    }

    @SubscribeEvent
    public static void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) {
        Player player = event.getEntity();
        CurseOfAvariceEffect.resetInventoryValue(player);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void BreakEvent(BlockEvent.BreakEvent event) {
        MobEffectInstance fortuneFavor;
        MobEffectInstance natureCurse;
        Player player = event.getPlayer();
        Level level = player.m_9236_();
        BlockPos blockPos = event.getPos();
        MobEffectInstance envyCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_ENVY.get());
        if (envyCurse != null) {
            EquipmentSlot slot;
            ItemStack DiscardItem;
            double itemDropOnUseChance = CurseOfEnvyEffect.getItemDropOnUseChance(envyCurse.m_19564_());
            double randomValue2 = player.m_217043_().m_188500_();
            if (randomValue2 < itemDropOnUseChance && (DiscardItem = player.m_6844_(slot = EquipmentSlot.MAINHAND)) != ItemStack.f_41583_ && !player.m_9236_().f_46443_) {
                player.m_36176_(DiscardItem, false);
                player.m_8061_(slot, ItemStack.f_41583_);
            }
        }
        if ((natureCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_NATURE.get())) != null) {
            double silverFishSpawnChance;
            double randomValue;
            int amplifier = natureCurse.m_19564_();
            Block brokenBlock = level.m_8055_(blockPos).m_60734_();
            if (amplifier >= 0 && ModEvents.isStoneTypeBlock(brokenBlock) && (randomValue = player.m_217043_().m_188500_()) < (silverFishSpawnChance = CurseOfNatureEffect.getSilverFishSpawnChance(amplifier))) {
                Silverfish silverfish = new Silverfish(EntityType.f_20523_, level);
                silverfish.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                level.m_7967_((Entity)silverfish);
                silverfish.m_21373_();
            }
        }
        if ((fortuneFavor = player.m_21124_((MobEffect)ModEffects.FORTUNES_FAVOR.get())) != null) {
            double chance = 0.33;
            BlockState state = event.getState();
            BlockPos pos = event.getPos();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams.Builder lootBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_287239_((float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_()));
            List drops = state.m_287290_(lootBuilder);
            boolean isFortuneAffected = drops.stream().anyMatch(stack -> !stack.m_150930_(state.m_60734_().m_5456_()));
            if (!isFortuneAffected) {
                return;
            }
            int multiplier = 2;
            if (random.nextDouble() < chance) {
                multiplier = 3;
            }
            for (ItemStack stack2 : drops) {
                if (stack2.m_41619_()) continue;
                ItemStack duplicatedStack = stack2.m_41777_();
                duplicatedStack.m_41764_(stack2.m_41613_() * (multiplier - 1));
                ItemEntity itemEntity = new ItemEntity((Level)serverLevel, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), duplicatedStack);
                serverLevel.m_7967_((Entity)itemEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MobEffectInstance fortuneFavor = player.m_21124_((MobEffect)ModEffects.FORTUNES_FAVOR.get());
        if (fortuneFavor != null) {
            double chance = 0.33;
            for (ItemEntity itemEntity : event.getDrops()) {
                ItemStack original = itemEntity.m_32055_();
                ItemStack multiplied = original.m_41777_();
                int multiplier = 2;
                if (random.nextDouble() < chance) {
                    multiplier = 3;
                }
                multiplied.m_41764_(original.m_41613_() * multiplier);
                itemEntity.m_32045_(multiplied);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void RightClickItemuseOnBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        MobEffectInstance envyCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_ENVY.get());
        if (envyCurse != null) {
            InteractionHand hand;
            EquipmentSlot slot;
            ItemStack DiscardItem;
            double itemDropOnUseChance = CurseOfEnvyEffect.getItemDropOnUseChance(envyCurse.m_19564_());
            double randomValue2 = player.m_217043_().m_188500_();
            if (randomValue2 < itemDropOnUseChance && (DiscardItem = player.m_6844_(slot = (hand = event.getHand()) == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND)) != ItemStack.f_41583_ && !player.m_9236_().f_46443_) {
                player.m_36176_(DiscardItem, false);
                player.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        MobEffectInstance prideCurse;
        Player player = event.getEntity();
        if (event.getTarget() instanceof Villager && (prideCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_PRIDE.get())) != null) {
            event.setCanceled(true);
            player.m_5661_((Component)Component.m_237113_((String)"You're better than them!").m_130940_(ChatFormatting.RED), true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onItemRightClick(LivingEntityUseItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            MobEffectInstance envyCurse;
            Player player = (Player)livingEntity;
            if (event instanceof LivingEntityUseItemEvent.Start && (envyCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_ENVY.get())) != null) {
                InteractionHand hand;
                EquipmentSlot slot;
                ItemStack DiscardItem;
                double itemDropOnUseChance = CurseOfEnvyEffect.getItemDropOnUseChance(envyCurse.m_19564_());
                double randomValue2 = player.m_217043_().m_188500_();
                if (randomValue2 < itemDropOnUseChance && (DiscardItem = player.m_6844_(slot = (hand = event.getEntity().m_7655_()) == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND)) != ItemStack.f_41583_ && !player.m_9236_().f_46443_) {
                    player.m_36176_(DiscardItem, false);
                    player.m_8061_(slot, ItemStack.f_41583_);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityHurt(LivingDamageEvent event) {
        Entity attacker = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        if (attacker instanceof Mob) {
            Mob mob = (Mob)attacker;
            if (target instanceof Player) {
                MobEffectInstance lustCurse;
                MobEffectInstance endCurse;
                MobEffectInstance envyCurse;
                MobEffectInstance invisibilityEffect;
                Player player = (Player)target;
                Level level = mob.m_9236_();
                if (level.f_46443_) return;
                MobEffectInstance shadowCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_SHADOWS.get());
                if (shadowCurse != null && (invisibilityEffect = mob.m_21124_(MobEffects.f_19609_)) != null) {
                    mob.m_21195_(MobEffects.f_19609_);
                }
                if ((envyCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_ENVY.get())) != null) {
                    int amplifier = envyCurse.m_19564_();
                    if (amplifier >= 1) {
                        float healingPercentage = CurseOfEnvyEffect.getHealPercentage(amplifier);
                        float healing = event.getAmount() * healingPercentage;
                        mob.m_5634_(healing);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            ModNetworking.sendToPlayer(new SendParticlesS2C((ParticleOptions)ModParticleTypes.HEAL_PARTICLE.get(), mob.m_20185_(), mob.m_20188_() + 0.5, mob.m_20189_(), 0.1, 0.25, 0.1, 10, 1.0), serverPlayer);
                        }
                    }
                    if (amplifier >= 2) {
                        ItemStack mobItem;
                        EquipmentSlot[] slots;
                        EquipmentSlot slot;
                        ItemStack playerItem;
                        double itemDropChance = CurseOfEnvyEffect.getItemDropOnUseChance(amplifier);
                        double randomValue = player.m_217043_().m_188500_();
                        if (randomValue < itemDropChance && !(playerItem = player.m_6844_(slot = (slots = EquipmentSlot.values())[player.m_217043_().m_188503_(slots.length)])).m_41619_() && (mobItem = mob.m_6844_(slot)).m_41619_()) {
                            player.m_8061_(slot, ItemStack.f_41583_);
                            mob.m_8061_(slot, playerItem.m_41777_());
                            mob.m_21508_(slot);
                            level.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), SoundEvents.f_12019_, SoundSource.HOSTILE, 1.0f, 1.0f);
                        }
                    }
                }
                if ((endCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_ENDING.get())) != null) {
                    int pAmplifier = endCurse.m_19564_();
                    if (!player.m_9236_().f_46443_) {
                        double teleportChance = CurseOfEndingEffect.getTeleportChance(pAmplifier);
                        if (player.m_217043_().m_188500_() < teleportChance) {
                            CurseOfEndingEffect.randomTeleport(player, endCurse.m_19564_());
                            if (pAmplifier >= 1) {
                                CurseOfEndingEffect.giveConfusion(player, 100);
                            }
                        }
                        if (CurseOfEndingEffect.isVoid(player)) {
                            event.setAmount(1.0f);
                        }
                    }
                }
                if ((lustCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_OBESSSION.get())) == null) return;
                if (!CurseOfObessionEffect.hasLustTarget(player)) return;
                CurseOfObessionEffect.resetLustCooldown(player, lustCurse.m_19564_());
                return;
            }
        }
        if (target instanceof Player) {
            MobEffectInstance hardening;
            Player player = (Player)target;
            AttributeInstance dodgeChanceAttribute = player.m_21051_((Attribute)ModAttributes.DODGE_CHANCE.get());
            if (dodgeChanceAttribute != null) {
                double hitChance = dodgeChanceAttribute.m_22135_();
                double randomValue = player.m_217043_().m_188500_();
                if (randomValue > hitChance) {
                    event.setCanceled(true);
                }
                Level level = player.m_9236_();
                if (event.isCanceled() && player != null) {
                    double x = player.m_20185_();
                    double y = player.m_20186_() + (double)player.m_20206_() / 2.0;
                    double z = player.m_20189_();
                    for (int i = 0; i < 10; ++i) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x + (player.m_217043_().m_188500_() - 0.5), y + (player.m_217043_().m_188500_() - 0.5), z + (player.m_217043_().m_188500_() - 0.5), 0.0, 0.0, 0.0);
                    }
                }
            }
            if ((hardening = player.m_21124_((MobEffect)ModEffects.CRYSTALLINE_HARDENING.get())) == null) return;
            boolean isBlocking = player.m_21254_();
            if (isBlocking) {
                if (!(random.nextFloat() <= 0.5f)) return;
                event.setAmount(0.0f);
                return;
            }
            if (!(random.nextFloat() <= 0.2f)) return;
            event.setAmount(0.0f);
            return;
        }
        if (!(attacker instanceof Player)) return;
        Player player = (Player)attacker;
        ItemStack activeAmulet = ItemStack.f_41583_;
        CompoundTag playerData = player.getPersistentData();
        UUID activeAmuletUUID = null;
        if (playerData.m_128425_("ActiveAmuletUUID", 11)) {
            activeAmuletUUID = playerData.m_128342_("ActiveAmuletUUID");
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            UUID amuletUUID;
            if (!(stack.m_41720_() instanceof GoldenAmuletItem) || (amuletUUID = GoldenAmuletItem.getUUID(stack)) == null || !amuletUUID.equals(activeAmuletUUID)) continue;
            activeAmulet = stack;
            break;
        }
        if (activeAmulet.m_41619_()) return;
        CompoundTag amuletTag = activeAmulet.m_41783_();
        if (amuletTag == null) return;
        if (!amuletTag.m_128441_("MainGem")) return;
        ItemStack mainGemStack = ItemStack.m_41712_((CompoundTag)amuletTag.m_128469_("MainGem"));
        if (mainGemStack.m_41720_() == ModItems.PERFECT_RUBY.get()) {
            ItemStack mainHandItem = player.m_21205_();
            double normalDamage = player.m_21204_().m_22181_(Attributes.f_22281_) + (double)mainHandItem.m_41773_() + (double)EnchantmentHelper.m_44833_((ItemStack)mainHandItem, (MobType)event.getEntity().m_6336_());
            if (!((double)event.getAmount() > normalDamage)) return;
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.CRITICAL_FURY.get(), 200, 0));
            return;
        }
        if (mainGemStack.m_41720_() != ModItems.PERFECT_TOPAZ.get()) return;
        if (!player.m_21023_((MobEffect)ModEffects.FRENZIED_BLOWS.get())) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FRENZIED_BLOWS.get(), 100, 0));
            return;
        }
        int effectAmplifier = Objects.requireNonNull(player.m_21124_((MobEffect)ModEffects.FRENZIED_BLOWS.get())).m_19564_();
        if (effectAmplifier < 2) {
            player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FRENZIED_BLOWS.get(), 100, effectAmplifier + 1));
            return;
        }
        if (effectAmplifier != 2) return;
        player.m_7292_(new MobEffectInstance((MobEffect)ModEffects.FRENZIED_BLOWS.get(), 100, 2));
    }

    private static boolean isStoneTypeBlock(Block block) {
        return block.m_49966_().m_204336_(OreForge) || block.m_49966_().m_204336_(CobblestoneForge) || block.m_49966_().m_204336_(StoneForge);
    }

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        Level level = entity.m_9236_();
        if (entity instanceof Mob) {
            Mob mob = entity;
            if (level instanceof ServerLevel) {
                for (Player player : level.m_6907_()) {
                    MobEffectInstance wrathCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_WRATH.get());
                    if (wrathCurse == null || !(player.m_20270_((Entity)entity) <= 25.0f)) continue;
                    int amplifier = wrathCurse.m_19564_();
                    double healthBoost = 1.5;
                    double damageBoost = 1.5;
                    if (amplifier == 1) {
                        healthBoost = 2.0;
                        damageBoost = 2.0;
                    } else if (amplifier >= 2) {
                        healthBoost = 3.0;
                        damageBoost = 3.0;
                    }
                    if (mob.m_21051_(Attributes.f_22276_) != null) {
                        mob.m_21051_(Attributes.f_22276_).m_22100_((double)mob.m_21233_() * healthBoost);
                        mob.m_21153_(mob.m_21233_());
                    }
                    if (mob.m_21051_(Attributes.f_22281_) == null) continue;
                    mob.m_21051_(Attributes.f_22281_).m_22100_(mob.m_21051_(Attributes.f_22281_).m_22135_() * damageBoost);
                }
            }
        }
        if (entity instanceof Monster && !level.f_46443_) {
            for (Player player : level.m_6907_()) {
                MobEffectInstance shadowCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_SHADOWS.get());
                if (shadowCurse == null) continue;
                int amplifier = shadowCurse.m_19564_();
                if (!(player.m_20280_((Entity)entity) < 2500.0)) continue;
                double spawnRateMultiplier = 1.0 + 0.5 * (double)amplifier;
                if (!((double)level.f_46441_.m_188501_() < spawnRateMultiplier)) continue;
                BlockPos spawnPos = new BlockPos((int)(entity.m_20185_() + (double)level.f_46441_.m_188503_(6) - 3.0), (int)entity.m_20186_(), (int)(entity.m_20189_() + (double)level.f_46441_.m_188503_(6) - 3.0));
                Monster newMob = (Monster)entity.m_6095_().m_20615_(level);
                if (newMob == null) continue;
                newMob.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
                level.m_7967_((Entity)newMob);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        CursedAltarBlockEntity altar;
        BlockEntity blockEntity;
        Player player;
        MobEffectInstance wrathCurse;
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player && (wrathCurse = (player = (Player)source).m_21124_((MobEffect)ModEffects.CURSE_OF_WRATH.get())) != null && wrathCurse.m_19564_() >= 2) {
            double explosionRadius = 4.0;
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, (1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f) * 0.7f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModNetworking.sendToPlayer(new SendParticlesS2C((ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 3.0, 3.0, 3.0, 4, explosionRadius), serverPlayer);
            }
            if ((double)player.m_20270_((Entity)entity) <= explosionRadius) {
                player.m_6469_(new DamageSource(level.m_269111_().m_269264_().m_269150_()), player.m_20270_((Entity)entity) * 2.0f);
            }
        }
        if (source instanceof ServerPlayer) {
            player = (ServerPlayer)source;
            UUID playerUUID = player.m_20148_();
            if (PlayerTrialData.isPlayerCursed(player)) {
                BlockPos altarPos = PlayerTrialData.getCurrentAltarPos(player);
                if (altarPos == null) {
                    return;
                }
                blockEntity = player.m_9236_().m_7702_(altarPos);
                if (!(blockEntity instanceof CursedAltarBlockEntity)) {
                    return;
                }
                altar = (CursedAltarBlockEntity)blockEntity;
                Trial trial = altar.getPlayerTrial(playerUUID);
                if (trial != null) {
                    trial.onEntityKilled(player, (Entity)entity);
                }
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            List nearbyMobs = level.m_45976_(Mob.class, player.m_20191_().m_82400_(64.0));
            for (Mob mob : nearbyMobs) {
                if (mob.m_5448_() != player) continue;
                CurseOfObessionEffect.removeTarget(mob);
            }
            BlockPos altarPos = PlayerTrialData.getCurrentAltarPos(player);
            if (altarPos == null) {
                return;
            }
            blockEntity = player.m_9236_().m_7702_(altarPos);
            if (!(blockEntity instanceof CursedAltarBlockEntity)) {
                return;
            }
            altar = (CursedAltarBlockEntity)blockEntity;
            if (!altar.hasPlayerCompletedTrial(player)) {
                altar.removePlayerFromTrial(player);
            }
            PlayerTrialData.clearPlayerCurse(player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModNetworking.sendToPlayer(new SyncTrialDataS2C("None", "", 0, 0, 0L, 0L, "", 0, 0), serverPlayer);
            }
            player.m_5661_((Component)Component.m_237113_((String)"The Altars Feed on your soul...").m_130940_(ChatFormatting.DARK_RED), true);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)ModEffects.CURSE_OF_SHADOWS.get())) {
            player.m_5661_((Component)Component.m_237113_((String)"It's too dark to sleep...").m_130940_(ChatFormatting.RED), true);
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        Player player;
        MobEffectInstance prideCurse;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && (prideCurse = (player = (Player)entity).m_21124_((MobEffect)ModEffects.CURSE_OF_PRIDE.get())) != null) {
            int amplifier = prideCurse.m_19564_();
            if (event.getDistance() > 1.5f) {
                event.setDamageMultiplier(1.5f + 0.5f * (float)amplifier);
            } else {
                event.setDamageMultiplier(1.0f);
            }
            if (amplifier == 1) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 0));
            } else if (amplifier > 1) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, amplifier + 1));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        Player player;
        MobEffectInstance prideCurse;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (prideCurse = (player = (Player)livingEntity).m_21124_((MobEffect)ModEffects.CURSE_OF_PRIDE.get())) != null) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMobEffectApplicable(MobEffectEvent.Applicable event) {
        MobEffectInstance addedEffect;
        Player player;
        MobEffectInstance prideCurse;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (prideCurse = (player = (Player)livingEntity).m_21124_((MobEffect)ModEffects.CURSE_OF_PRIDE.get())) != null && prideCurse.m_19564_() >= 1 && (addedEffect = event.getEffectInstance()).m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL) {
            event.setResult(Event.Result.DENY);
            player.m_5661_((Component)Component.m_237113_((String)"Help is for the weak!").m_130940_(ChatFormatting.RED), true);
        }
    }

    @SubscribeEvent
    public static void onPlayerEquip(LivingEquipmentChangeEvent event) {
        Player player;
        MobEffectInstance prideCurse;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (prideCurse = (player = (Player)livingEntity).m_21124_((MobEffect)ModEffects.CURSE_OF_PRIDE.get())) != null && prideCurse.m_19564_() >= 2) {
            EquipmentSlot slot = event.getSlot();
            ItemStack newStack = event.getTo();
            if (!(slot.m_20743_() != EquipmentSlot.Type.ARMOR && slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND || newStack.m_41619_() || player.m_150109_().m_36054_(newStack))) {
                player.m_36176_(newStack, false);
            }
        }
    }

    @SubscribeEvent
    public static void onPotionEffectAdded(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            double magicAmp;
            Player player = (Player)entity;
            MobEffectInstance newEffect = event.getEffectInstance();
            if (newEffect.m_19544_().m_19486_() && (magicAmp = player.m_21133_((Attribute)ModAttributes.MAGIC_AMP.get())) > 1.0) {
                int originalDuration = newEffect.m_19557_();
                int increasedDuration = (int)((double)originalDuration * magicAmp);
                newEffect.m_19558_(new MobEffectInstance(newEffect.m_19544_(), increasedDuration, newEffect.m_19564_(), newEffect.m_19571_(), newEffect.m_19572_(), newEffect.m_19575_()));
            }
        }
    }

    @SubscribeEvent
    public static void onPotionEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MobEffectInstance curseEffect = event.getEffectInstance();
            if (curseEffect != null) {
                MobEffect effect = curseEffect.m_19544_();
                if (CurseRegistry.getCurses().contains(effect) && PlayerTrialData.isPlayerCursed(player)) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        ItemEntity entity = event.getEntity();
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = entity;
        Item tossedItem = itemEntity.m_32055_().m_41720_();
        int itemCount = itemEntity.m_32055_().m_41613_();
        BlockPos itemPos = itemEntity.m_20183_();
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!PlayerTrialData.isPlayerCursed(player)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        for (TrialRecord trialRecord : PlayerTrialData.getActiveTrialsByType(player, "FetchTrial")) {
            FetchTrial fetchTrial;
            Item requiredItem;
            CursedAltarBlockEntity altar;
            Trial trial;
            BlockEntity blockEntity;
            BlockPos altarPos = trialRecord.getAltarPos();
            BlockPos lowerBound = altarPos.m_6630_(1);
            BlockPos upperBound = altarPos.m_6630_(3);
            boolean isWithinHeight = itemPos.m_123342_() >= lowerBound.m_123342_() && itemPos.m_123342_() <= upperBound.m_123342_();
            boolean isWithinRadius = altarPos.m_252807_().m_82509_((Position)itemEntity.m_20182_(), 3.0);
            if (!isWithinHeight || !isWithinRadius || !((blockEntity = serverLevel.m_7702_(altarPos)) instanceof CursedAltarBlockEntity) || !((trial = (altar = (CursedAltarBlockEntity)blockEntity).getPlayerTrial(player.m_20148_())) instanceof FetchTrial) || !tossedItem.equals(requiredItem = (fetchTrial = (FetchTrial)trial).getRequiredItem())) continue;
            fetchTrial.incrementFetchCount(itemCount);
            itemEntity.m_146870_();
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.CURSED_FLAME_PARTICLE.get()), (double)altarPos.m_123341_() + 0.5, (double)altarPos.m_123342_() + 1.0, (double)altarPos.m_123343_() + 0.5, 100, 0.2, 2.0, 0.2, 0.01);
            serverLevel.m_6263_(null, (double)altarPos.m_123341_() + 0.5, (double)altarPos.m_123342_() + 1.0, (double)altarPos.m_123343_() + 0.5, SoundEvents.f_11923_, SoundSource.HOSTILE, 1.0f, 0.5f);
            trial.trackProgress(player);
            if (!fetchTrial.isTrialCompleted(player)) break;
            fetchTrial.concludeTrial(player);
            break;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        MobEffectInstance lustCurse;
        MobEffectInstance prideCurse;
        int amplifier;
        MobEffectInstance shadowCurse;
        Player player = event.player;
        Level level = player.m_9236_();
        CompoundTag playerData = player.getPersistentData();
        UUID activeAmuletUUID = null;
        if (playerData.m_128425_("ActiveAmuletUUID", 11)) {
            activeAmuletUUID = playerData.m_128342_("ActiveAmuletUUID");
        }
        ItemStack activeAmulet = ItemStack.f_41583_;
        if (!level.f_46443_ && event.phase == TickEvent.Phase.END) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                UUID amuletUUID;
                if (!(stack.m_41720_() instanceof GoldenAmuletItem) || (amuletUUID = GoldenAmuletItem.getUUID(stack)) == null || !amuletUUID.equals(activeAmuletUUID)) continue;
                activeAmulet = stack;
                break;
            }
            if (!activeAmulet.m_41619_()) {
                GoldenAmuletItem amuletItem = (GoldenAmuletItem)activeAmulet.m_41720_();
                amuletItem.applyGemBonuses(player, activeAmulet);
            } else {
                PreciousGemItem.removeBonus(player);
                player.getPersistentData().m_128473_("ActiveAmuletUUID");
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    Item item = stack.m_41720_();
                    if (!(item instanceof GoldenAmuletItem)) continue;
                    GoldenAmuletItem amuletItem = (GoldenAmuletItem)item;
                    UUID newUUID = GoldenAmuletItem.getOrCreateUUID(stack);
                    player.getPersistentData().m_128362_("ActiveAmuletUUID", newUUID);
                    amuletItem.applyGemBonuses(player, stack);
                    break;
                }
            }
        }
        if ((shadowCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_SHADOWS.get())) != null && shadowCurse.m_19564_() >= 1 && !level.f_46443_ && player.f_19797_ % (24000 / ((amplifier = shadowCurse.m_19564_()) + 1)) == 0 && (double)level.f_46441_.m_188501_() < 0.25) {
            BlockPos spawnPos = player.m_20183_().m_6630_(15);
            Phantom phantom = (Phantom)EntityType.f_20509_.m_20615_(level);
            if (phantom != null) {
                phantom.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
                level.m_7967_((Entity)phantom);
            }
        }
        if ((prideCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_PRIDE.get())) != null && !level.f_46443_) {
            if (player.m_20142_()) {
                player.m_6858_(false);
                if (prideCurse.m_19564_() >= 1) {
                    player.m_6469_(player.m_9236_().m_269111_().m_269264_(), 1.0f);
                    player.m_5661_((Component)Component.m_237113_((String)"Running is for the pathetic!").m_130940_(ChatFormatting.RED), true);
                }
            }
            if (prideCurse.m_19564_() >= 2) {
                ItemStack offHandItem;
                ItemStack mainHandItem = player.m_21205_();
                if (!mainHandItem.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    player.m_36176_(mainHandItem, false);
                }
                if (!(offHandItem = player.m_21206_()).m_41619_()) {
                    player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                    player.m_36176_(offHandItem, false);
                }
            }
        }
        if ((lustCurse = player.m_21124_((MobEffect)ModEffects.CURSE_OF_OBESSSION.get())) != null) {
            int amplifier2 = lustCurse.m_19564_();
            double aggroDistanceMultiplier = 2.0 + (double)amplifier2;
            List nearbyMonsters = level.m_45976_(Monster.class, player.m_20191_().m_82400_(aggroDistanceMultiplier * 16.0));
            for (Monster monster : nearbyMonsters) {
                if (monster.m_5448_() != null) continue;
                monster.m_6710_((LivingEntity)player);
            }
        }
        if (event.phase == TickEvent.Phase.END && !player.m_9236_().m_5776_() && PlayerTrialData.isPlayerCursed(player)) {
            BlockPos altarPos = PlayerTrialData.getCurrentAltarPos(player);
            if (altarPos == null) {
                return;
            }
            BlockEntity blockEntity = player.m_9236_().m_7702_(altarPos);
            if (!(blockEntity instanceof CursedAltarBlockEntity)) {
                return;
            }
            CursedAltarBlockEntity altar = (CursedAltarBlockEntity)blockEntity;
            Trial trial = altar.getPlayerTrial(player.m_20148_());
            if (trial != null) {
                trial.onPlayerTick(player);
            }
        }
    }
}

