/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.network.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SendParticlesS2C {
    private final double x;
    private final double y;
    private final double z;
    private final double dx;
    private final double dy;
    private final double dz;
    private final ParticleOptions particleType;
    private final int particleCount;
    private final double particleSpread;

    public SendParticlesS2C(ParticleOptions particleType, double x, double y, double z, double dx, double dy, double dz, int particleCount, double particleSpread) {
        this.particleType = particleType;
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.particleCount = particleCount;
        this.particleSpread = particleSpread;
    }

    public SendParticlesS2C(FriendlyByteBuf buf) {
        ParticleType type = (ParticleType)buf.readRegistryId();
        this.particleType = type.m_123743_().m_6507_(type, buf);
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.dx = buf.readDouble();
        this.dy = buf.readDouble();
        this.dz = buf.readDouble();
        this.particleCount = buf.readInt();
        this.particleSpread = buf.readDouble();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeRegistryId(ForgeRegistries.PARTICLE_TYPES, (Object)this.particleType.m_6012_());
        this.particleType.m_7711_(buf);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.dx);
        buf.writeDouble(this.dy);
        buf.writeDouble(this.dz);
        buf.writeInt(this.particleCount);
        buf.writeDouble(this.particleSpread);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                for (int i = 0; i < this.particleCount; ++i) {
                    double xPos = this.x + (Minecraft.m_91087_().f_91073_.f_46441_.m_188500_() - 0.5) * this.particleSpread;
                    double yPos = this.y + (Minecraft.m_91087_().f_91073_.f_46441_.m_188500_() - 0.5) * this.particleSpread;
                    double zPos = this.z + (Minecraft.m_91087_().f_91073_.f_46441_.m_188500_() - 0.5) * this.particleSpread;
                    double xSpeed = this.dx * (Minecraft.m_91087_().f_91073_.f_46441_.m_188500_() - 0.5);
                    double ySpeed = this.dy * (Minecraft.m_91087_().f_91073_.f_46441_.m_188500_() - 0.5);
                    double zSpeed = this.dz * (Minecraft.m_91087_().f_91073_.f_46441_.m_188500_() - 0.5);
                    Minecraft.m_91087_().f_91073_.m_7106_(this.particleType, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
                }
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

