/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.network.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.turtleboi.ancientcurses.client.PlayerClientData;

public class SyncTrialDataS2C {
    private final String trialType;
    private final String eliminationTarget;
    private final int eliminationKills;
    private final int eliminationKillsRequired;
    private final long trialDurationElapsed;
    private final long trialDurationTotal;
    private final String fetchItem;
    private final int fetchItems;
    private final int fetchItemsRequired;

    public SyncTrialDataS2C(String trialType, String eliminationTarget, int eliminationKills, int eliminationKillsRequired, long trialDurationElapsed, long trialDurationTotal, String fetchItem, int fetchItems, int fetchItemsRequired) {
        this.trialType = trialType;
        this.eliminationTarget = eliminationTarget;
        this.eliminationKills = eliminationKills;
        this.eliminationKillsRequired = eliminationKillsRequired;
        this.trialDurationElapsed = trialDurationElapsed;
        this.trialDurationTotal = trialDurationTotal;
        this.fetchItem = fetchItem;
        this.fetchItems = fetchItems;
        this.fetchItemsRequired = fetchItemsRequired;
    }

    public SyncTrialDataS2C(FriendlyByteBuf buf) {
        this.trialType = buf.m_130277_();
        this.eliminationTarget = buf.m_130277_();
        this.eliminationKills = buf.readInt();
        this.eliminationKillsRequired = buf.readInt();
        this.trialDurationElapsed = buf.readLong();
        this.trialDurationTotal = buf.readLong();
        this.fetchItem = buf.m_130277_();
        this.fetchItems = buf.readInt();
        this.fetchItemsRequired = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.trialType);
        buf.m_130070_(this.eliminationTarget);
        buf.writeInt(this.eliminationKills);
        buf.writeInt(this.eliminationKillsRequired);
        buf.writeLong(this.trialDurationElapsed);
        buf.writeLong(this.trialDurationTotal);
        buf.m_130070_(this.fetchItem);
        buf.writeInt(this.fetchItems);
        buf.writeInt(this.fetchItemsRequired);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            PlayerClientData.setTrialType(this.trialType);
            if (this.trialType == null || this.trialType.equals("None")) {
                PlayerClientData.trialType = "None";
            } else {
                PlayerClientData.setEliminationTarget(this.eliminationTarget);
                PlayerClientData.setEliminationKills(this.eliminationKills);
                PlayerClientData.setEliminationKillsRequired(this.eliminationKillsRequired);
                PlayerClientData.setTrialDurationElapsed(this.trialDurationElapsed);
                PlayerClientData.setTrialDurationTotal(this.trialDurationTotal);
                PlayerClientData.setFetchItem(this.fetchItem);
                PlayerClientData.setFetchItems(this.fetchItems);
                PlayerClientData.setFetchItemsRequired(this.fetchItemsRequired);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

