/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.trials;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.turtleboi.ancientcurses.block.entity.CursedAltarBlockEntity;
import net.turtleboi.ancientcurses.entity.CursedPortalEntity;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.CameraShakeS2C;
import net.turtleboi.ancientcurses.network.packets.SyncTrialDataS2C;
import net.turtleboi.ancientcurses.trials.PlayerTrialData;
import net.turtleboi.ancientcurses.trials.Trial;

public class EliminationTrial
implements Trial {
    private UUID playerUUID;
    private EntityType<?> eliminationTarget;
    private String eliminationTargetString;
    private int eliminationKills;
    private int eliminationKillsRequired;
    public static final String eliminationCount = "EliminationCount";
    public static final String eliminationRequirement = "EliminationRequirement";
    private CursedAltarBlockEntity altar;
    private MobEffect effect;
    private boolean completed;

    public EliminationTrial(Player player, MobEffect effect, int amplifier, CursedAltarBlockEntity altar) {
        this.playerUUID = player.m_20148_();
        this.altar = altar;
        this.effect = effect;
        this.eliminationTarget = this.selectRandomTargetMob();
        this.eliminationKillsRequired = this.calculateRequiredKillCount(amplifier);
        this.eliminationKills = 0;
        this.completed = false;
        PlayerTrialData.setCurseEffect(player, effect);
    }

    public EliminationTrial(CursedAltarBlockEntity altar) {
        this.altar = altar;
        this.completed = false;
    }

    public boolean isTrialActive() {
        return this.altar.getPlayerTrial(this.playerUUID) != null;
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        tag.m_128362_("PlayerUUID", this.playerUUID);
        tag.m_128359_("Effect", Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)this.effect)).toString());
        tag.m_128359_("EliminationTarget", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(this.eliminationTarget)).toString());
        tag.m_128405_(eliminationCount, this.eliminationKills);
        tag.m_128405_(eliminationRequirement, this.eliminationKillsRequired);
        tag.m_128379_("Completed", this.completed);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        this.playerUUID = tag.m_128342_("PlayerUUID");
        String effectName = tag.m_128461_("Effect");
        this.effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
        String targetName = tag.m_128461_("EliminationTarget");
        this.eliminationTarget = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(targetName));
        this.eliminationKills = tag.m_128451_(eliminationCount);
        this.eliminationKillsRequired = tag.m_128451_(eliminationRequirement);
        this.completed = tag.m_128471_("Completed");
    }

    @Override
    public String getType() {
        return "EliminationTrial";
    }

    @Override
    public void setAltar(CursedAltarBlockEntity altar) {
        this.altar = altar;
    }

    @Override
    public MobEffect getEffect() {
        return this.effect;
    }

    public Player getPlayer() {
        Level level = this.altar.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_46003_(this.playerUUID);
        }
        return null;
    }

    @Override
    public boolean isTrialCompleted(Player player) {
        return this.eliminationKills >= this.eliminationKillsRequired;
    }

    @Override
    public void onEntityKilled(Player player, Entity entity) {
        if (!this.isTrialActive()) {
            return;
        }
        if (entity.m_6095_() == this.eliminationTarget) {
            this.incrementEliminationCount();
            if (this.isTrialCompleted(player)) {
                this.concludeTrial(player);
            } else {
                this.trackProgress(player);
            }
        }
    }

    @Override
    public void onPlayerTick(Player player) {
    }

    private EntityType<?> selectRandomTargetMob() {
        List<WeightedMob> mobList = MobList.ELIMINATION_TRIAL_MOBS;
        double totalWeight = mobList.stream().mapToDouble(WeightedMob::getWeight).sum();
        double randomValue = ThreadLocalRandom.current().nextDouble(totalWeight);
        double cumulativeWeight = 0.0;
        for (WeightedMob wm : mobList) {
            if (!(randomValue <= (cumulativeWeight += wm.getWeight()))) continue;
            this.eliminationTargetString = wm.getMobType().m_20676_().getString();
            return wm.getMobType();
        }
        return mobList.get(mobList.size() - 1).getMobType();
    }

    private int calculateRequiredKillCount(int amplifier) {
        int randomMultiplier = ThreadLocalRandom.current().nextInt(8, 13);
        int baseKillCount = randomMultiplier * (amplifier + 1);
        if (this.eliminationTarget.equals((Object)EntityType.f_20453_) || this.eliminationTarget.equals((Object)EntityType.f_20497_) || this.eliminationTarget.equals((Object)EntityType.f_20495_) || this.eliminationTarget.equals((Object)EntityType.f_20568_)) {
            baseKillCount = Math.max(1, baseKillCount / 2);
        } else if (this.eliminationTarget.equals((Object)EntityType.f_20554_) || this.eliminationTarget.equals((Object)EntityType.f_20526_) || this.eliminationTarget.equals((Object)EntityType.f_20468_)) {
            baseKillCount *= 2;
        }
        if (ThreadLocalRandom.current().nextDouble() <= 0.01) {
            this.eliminationTarget = EntityType.f_20492_;
            baseKillCount *= 2;
        }
        return baseKillCount;
    }

    @Override
    public void trackProgress(Player player) {
        if (player != null) {
            float progressPercentage = Math.min((float)this.eliminationKills / (float)this.eliminationKillsRequired, 1.0f);
            ModNetworking.sendToPlayer(new SyncTrialDataS2C("EliminationTrial", this.eliminationTargetString, this.eliminationKills, this.eliminationKillsRequired, 0L, 0L, "", 0, 0), (ServerPlayer)player);
        }
    }

    @Override
    public void concludeTrial(Player player) {
        ModNetworking.sendToPlayer(new SyncTrialDataS2C("EliminationTrial", this.eliminationTargetString, this.eliminationKillsRequired, this.eliminationKillsRequired, 0L, 0L, "", 0, 0), (ServerPlayer)player);
        PlayerTrialData.clearCurseAmplifier(player);
        player.m_21195_(this.effect);
        PlayerTrialData.clearCurseEffect(player);
        ModNetworking.sendToPlayer(new CameraShakeS2C(0.05f, 1000), (ServerPlayer)player);
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), (SoundEvent)SoundEvents.f_12325_.get(), SoundSource.AMBIENT, 1.0f, 0.25f);
        }
        CursedPortalEntity.spawnPortalNearPlayer(player, this.altar.m_58899_(), this.altar.m_58904_(), (Object)this.altar);
        this.altar.setPlayerTrialCompleted(player);
        this.setCompleted(true);
    }

    public void incrementEliminationCount() {
        ++this.eliminationKills;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public static class MobList {
        public static final List<WeightedMob> ELIMINATION_TRIAL_MOBS = Arrays.asList(new WeightedMob(EntityType.f_20501_, 20.0), new WeightedMob(EntityType.f_20524_, 20.0), new WeightedMob(EntityType.f_20558_, 15.0), new WeightedMob(EntityType.f_20479_, 15.0), new WeightedMob(EntityType.f_20513_, 10.0), new WeightedMob(EntityType.f_20493_, 10.0), new WeightedMob(EntityType.f_20456_, 10.0), new WeightedMob(EntityType.f_20531_, 10.0), new WeightedMob(EntityType.f_20512_, 10.0), new WeightedMob(EntityType.f_20562_, 10.0), new WeightedMob(EntityType.f_20455_, 5.0), new WeightedMob(EntityType.f_20509_, 5.0), new WeightedMob(EntityType.f_20526_, 15.0), new WeightedMob(EntityType.f_20468_, 15.0), new WeightedMob(EntityType.f_20554_, 5.0), new WeightedMob(EntityType.f_20495_, 3.0), new WeightedMob(EntityType.f_20568_, 3.0), new WeightedMob(EntityType.f_20497_, 2.0), new WeightedMob(EntityType.f_20453_, 1.0), new WeightedMob(EntityType.f_20551_, 2.0), new WeightedMob(EntityType.f_20458_, 3.0), new WeightedMob(EntityType.f_20481_, 3.0));

        public WeightedMob selectRandomTargetMobWithWeight() {
            List<WeightedMob> mobList = ELIMINATION_TRIAL_MOBS;
            double totalWeight = mobList.stream().mapToDouble(WeightedMob::getWeight).sum();
            double randomValue = ThreadLocalRandom.current().nextDouble(totalWeight);
            double cumulativeWeight = 0.0;
            for (WeightedMob wm : mobList) {
                if (!(randomValue <= (cumulativeWeight += wm.getWeight()))) continue;
                return wm;
            }
            return mobList.get(mobList.size() - 1);
        }
    }

    public static class WeightedMob {
        private final EntityType<?> mobType;
        private final double weight;

        public WeightedMob(EntityType<?> mobType, double weight) {
            this.mobType = mobType;
            this.weight = weight;
        }

        public EntityType<?> getMobType() {
            return this.mobType;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

