/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.trials;

import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.turtleboi.ancientcurses.block.entity.CursedAltarBlockEntity;
import net.turtleboi.ancientcurses.network.ModNetworking;
import net.turtleboi.ancientcurses.network.packets.CameraShakeS2C;
import net.turtleboi.ancientcurses.network.packets.SyncTrialDataS2C;
import net.turtleboi.ancientcurses.trials.PlayerTrialData;
import net.turtleboi.ancientcurses.trials.Trial;

public class FetchTrial
implements Trial {
    private UUID playerUUID;
    private Item requiredItem;
    private String itemName;
    private int requiredCount;
    private int collectedCount;
    private CursedAltarBlockEntity altar;
    private MobEffect effect;
    public static final String fetchCount = "FetchCount";
    public static final String fetchRequirement = "FetchRequirement";
    public static final String fetchItem = "FetchItem";
    private boolean completed;

    public FetchTrial(Player player, MobEffect effect, int amplifier, CursedAltarBlockEntity altar) {
        this.playerUUID = player.m_20148_();
        this.altar = altar;
        this.effect = effect;
        this.completed = false;
        this.requiredItem = this.selectRandomItem();
        ItemStack stack = new ItemStack((ItemLike)this.requiredItem);
        Component itemNameComponent = stack.m_41611_();
        this.itemName = itemNameComponent.getString();
        this.collectedCount = 0;
        this.requiredCount = this.calculateRequiredCount(amplifier);
        PlayerTrialData.setCurseEffect(player, effect);
    }

    public FetchTrial(CursedAltarBlockEntity altar) {
        this.altar = altar;
        this.completed = false;
    }

    private Item selectRandomItem() {
        Item[] possibleItems = new Item[]{(Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "iron_ingot")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "gold_ingot")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "copper_ingot")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "raw_iron")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "raw_gold")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "raw_copper")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "lapis_lazuli")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "redstone")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "rotten_flesh")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "bone")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "ender_pearl")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "gunpowder")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "spider_eye")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "glowstone_dust")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "sugar")), (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "string"))};
        Item[] filteredItems = (Item[])Arrays.stream(possibleItems).filter(Objects::nonNull).toArray(Item[]::new);
        if (filteredItems.length == 0) {
            System.err.println("Fetch Trial: No valid items found in possibleItems list.");
            return Items.f_41852_;
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(filteredItems.length);
        return filteredItems[randomIndex];
    }

    private int calculateRequiredCount(int amplifier) {
        int effectiveAmplifier = Math.max(amplifier, 1);
        Random random = new Random();
        int base = random.nextInt(9) + 8;
        return base * (effectiveAmplifier * 2);
    }

    public boolean isTrialActive() {
        return this.altar.getPlayerTrial(this.playerUUID) != null && !this.completed;
    }

    @Override
    public void saveToNBT(CompoundTag tag) {
        tag.m_128362_("PlayerUUID", this.playerUUID);
        tag.m_128359_(fetchItem, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.requiredItem)).toString());
        tag.m_128405_(fetchCount, this.collectedCount);
        tag.m_128405_(fetchRequirement, this.requiredCount);
        tag.m_128379_("Completed", this.completed);
    }

    @Override
    public void loadFromNBT(CompoundTag tag) {
        this.playerUUID = tag.m_128342_("PlayerUUID");
        String itemName = tag.m_128461_(fetchItem);
        this.requiredItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        this.collectedCount = tag.m_128451_(fetchCount);
        this.requiredCount = tag.m_128451_(fetchRequirement);
        this.completed = tag.m_128471_("Completed");
    }

    @Override
    public String getType() {
        return "FetchTrial";
    }

    @Override
    public void setAltar(CursedAltarBlockEntity altar) {
        this.altar = altar;
    }

    @Override
    public boolean isCompleted() {
        return false;
    }

    @Override
    public MobEffect getEffect() {
        return this.effect;
    }

    public Player getPlayer() {
        Level level = this.altar.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_46003_(this.playerUUID);
        }
        return null;
    }

    @Override
    public boolean isTrialCompleted(Player player) {
        return this.completed || this.collectedCount >= this.requiredCount;
    }

    @Override
    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Override
    public void onEntityKilled(Player player, Entity entity) {
    }

    @Override
    public void onPlayerTick(Player player) {
    }

    @Override
    public void trackProgress(Player player) {
        if (player != null) {
            float progressPercentage = Math.min((float)this.collectedCount / (float)this.requiredCount, 1.0f);
            ModNetworking.sendToPlayer(new SyncTrialDataS2C("FetchTrial", "", 0, 0, 0L, 0L, this.itemName, this.collectedCount, this.requiredCount), (ServerPlayer)player);
        }
    }

    @Override
    public void concludeTrial(Player player) {
        ModNetworking.sendToPlayer(new SyncTrialDataS2C("FetchTrial", "", 0, 0, 0L, 0L, this.itemName, this.requiredCount, this.requiredCount), (ServerPlayer)player);
        PlayerTrialData.clearCurseAmplifier(player);
        player.m_21195_(this.effect);
        PlayerTrialData.clearCurseEffect(player);
        ModNetworking.sendToPlayer(new CameraShakeS2C(0.125f, 1000), (ServerPlayer)player);
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), (SoundEvent)SoundEvents.f_12325_.get(), SoundSource.AMBIENT, 1.0f, 0.25f);
        }
        PlayerTrialData.setTrialCompleted(player, this.altar.m_58899_());
        this.completed = true;
        this.altar.setPlayerTrialCompleted(player);
    }

    public void incrementFetchCount(int itemCount) {
        this.collectedCount += itemCount;
    }

    public Item getRequiredItem() {
        return this.requiredItem;
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public int getCollectedCount() {
        return this.collectedCount;
    }
}

