/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.ancientcurses.trials;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import net.turtleboi.ancientcurses.trials.TrialRecord;

public class PlayerTrialData {
    private static final String curseEffect = "CurseEffect";
    private static final String curseAmplifier = "CurseAmplifier";
    private static final String currentAltarPos = "CurrentAltarPos";
    private static final String trialRecords = "TrialRecords";
    public static final String eliminationTrial = "EliminationTrial";
    public static final String survivalTrial = "SurvivalTrial";
    public static final String fetchTrial = "FetchTrial";
    public static final String seekTrial = "SeekTrial";

    public static boolean isPlayerCursed(Player player) {
        return player.getPersistentData().m_128441_(curseEffect) && player.getPersistentData().m_128441_(curseAmplifier);
    }

    public static void clearPlayerCurse(Player player) {
        PlayerTrialData.clearCurseEffect(player);
        PlayerTrialData.clearCurseAmplifier(player);
        PlayerTrialData.clearCurrentAltarPos(player);
    }

    public static void setCurrentAltarPos(Player player, BlockPos altarPos) {
        player.getPersistentData().m_128356_(currentAltarPos, altarPos.m_121878_());
    }

    public static BlockPos getCurrentAltarPos(Player player) {
        if (player.getPersistentData().m_128441_(currentAltarPos)) {
            long posLong = player.getPersistentData().m_128454_(currentAltarPos);
            return BlockPos.m_122022_((long)posLong);
        }
        return null;
    }

    public static void clearCurrentAltarPos(Player player) {
        player.getPersistentData().m_128473_(currentAltarPos);
    }

    public static void addOrUpdateTrialRecord(Player player, TrialRecord trialRecord) {
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        boolean found = false;
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag existingTag = trialRecordsList.m_128728_(i);
            TrialRecord existingRecord = new TrialRecord();
            existingRecord.deserializeNBT(existingTag);
            if (!existingRecord.getAltarPos().equals((Object)trialRecord.getAltarPos())) continue;
            existingRecord.setTrialType(trialRecord.getTrialType());
            existingRecord.setCompleted(trialRecord.isCompleted());
            existingRecord.setRewardCollected(trialRecord.isRewardCollected());
            trialRecordsList.set(i, (Tag)existingRecord.serializeNBT());
            found = true;
            break;
        }
        if (!found) {
            trialRecordsList.add((Object)trialRecord.serializeNBT());
        }
        player.getPersistentData().m_128365_(trialRecords, (Tag)trialRecordsList);
    }

    public static void setTrialCompleted(Player player, BlockPos altarPos) {
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag existingTag = trialRecordsList.m_128728_(i);
            TrialRecord existingRecord = new TrialRecord();
            existingRecord.deserializeNBT(existingTag);
            if (!existingRecord.getAltarPos().equals((Object)altarPos)) continue;
            existingRecord.setCompleted(true);
            trialRecordsList.set(i, (Tag)existingRecord.serializeNBT());
            break;
        }
        player.getPersistentData().m_128365_(trialRecords, (Tag)trialRecordsList);
    }

    public static boolean hasCompletedTrial(Player player, BlockPos altarPos) {
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag existingTag = trialRecordsList.m_128728_(i);
            TrialRecord existingRecord = new TrialRecord();
            existingRecord.deserializeNBT(existingTag);
            if (!existingRecord.getAltarPos().equals((Object)altarPos)) continue;
            return existingRecord.isCompleted();
        }
        return false;
    }

    public static void setRewardCollected(Player player, BlockPos altarPos) {
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag existingTag = trialRecordsList.m_128728_(i);
            TrialRecord existingRecord = new TrialRecord();
            existingRecord.deserializeNBT(existingTag);
            if (!existingRecord.getAltarPos().equals((Object)altarPos)) continue;
            existingRecord.setRewardCollected(true);
            trialRecordsList.set(i, (Tag)existingRecord.serializeNBT());
            break;
        }
        player.getPersistentData().m_128365_(trialRecords, (Tag)trialRecordsList);
    }

    public static boolean hasCollectedReward(Player player, BlockPos altarPos) {
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag existingTag = trialRecordsList.m_128728_(i);
            TrialRecord existingRecord = new TrialRecord();
            existingRecord.deserializeNBT(existingTag);
            if (!existingRecord.getAltarPos().equals((Object)altarPos)) continue;
            return existingRecord.isRewardCollected();
        }
        return false;
    }

    public static int getPlayerTrialsCompleted(Player player) {
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        int count = 0;
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag existingTag = trialRecordsList.m_128728_(i);
            TrialRecord existingRecord = new TrialRecord();
            existingRecord.deserializeNBT(existingTag);
            if (!existingRecord.isCompleted()) continue;
            ++count;
        }
        return count;
    }

    public static void resetAltarAtPos(Player player, BlockPos altarPos) {
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        ListTag updatedTrialRecords = new ListTag();
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag existingTag = trialRecordsList.m_128728_(i);
            TrialRecord existingRecord = new TrialRecord();
            existingRecord.deserializeNBT(existingTag);
            if (!existingRecord.getAltarPos().equals((Object)altarPos)) {
                updatedTrialRecords.add((Object)existingTag.m_6426_());
                continue;
            }
            existingRecord.setCompleted(false);
            existingRecord.setRewardCollected(false);
            updatedTrialRecords.add((Object)existingRecord.serializeNBT());
        }
        player.getPersistentData().m_128365_(trialRecords, (Tag)updatedTrialRecords);
    }

    public static TrialRecord getTrialRecord(Player player, BlockPos altarPos) {
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag existingTag = trialRecordsList.m_128728_(i);
            TrialRecord existingRecord = new TrialRecord();
            existingRecord.deserializeNBT(existingTag);
            if (!existingRecord.getAltarPos().equals((Object)altarPos)) continue;
            return existingRecord;
        }
        return null;
    }

    public static List<TrialRecord> getActiveTrialsByType(Player player, String trialType) {
        ArrayList<TrialRecord> activeTrials = new ArrayList<TrialRecord>();
        ListTag trialRecordsList = player.getPersistentData().m_128437_(trialRecords, 10);
        for (int i = 0; i < trialRecordsList.size(); ++i) {
            CompoundTag trialTag = trialRecordsList.m_128728_(i);
            TrialRecord trialRecord = new TrialRecord();
            trialRecord.deserializeNBT(trialTag);
            if (!trialRecord.getTrialType().equals(trialType) || trialRecord.isCompleted()) continue;
            activeTrials.add(trialRecord);
        }
        return activeTrials;
    }

    public static void clearCurseEffect(Player player) {
        player.getPersistentData().m_128473_(curseEffect);
    }

    public static MobEffect getCurseEffect(Player player) {
        if (player.getPersistentData().m_128441_(curseEffect)) {
            String effectName = player.getPersistentData().m_128461_(curseEffect);
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
        }
        return null;
    }

    public static void setCurseEffect(Player player, MobEffect effect) {
        ResourceLocation effectKey;
        if (effect != null && ForgeRegistries.MOB_EFFECTS.containsValue((Object)effect) && (effectKey = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect)) != null) {
            player.getPersistentData().m_128359_(curseEffect, effectKey.toString());
        }
    }

    public static void clearCurseAmplifier(Player player) {
        player.getPersistentData().m_128473_(curseAmplifier);
    }

    public static int getCurseAmplifier(Player player) {
        return player.getPersistentData().m_128451_(curseAmplifier);
    }

    public static void setCurseAmplifier(Player player, int amplifier) {
        player.getPersistentData().m_128405_(curseAmplifier, amplifier);
    }
}

