/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.capability;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.fishing_plus.capability.PlayerFishStats;
import net.mint_gaming_studios.fishing_plus.fish.FishStats;
import net.mint_gaming_studios.fishing_plus.tags.ModTags;

public class DefaultPlayerFishStats
implements PlayerFishStats {
    private int timesFished;
    private final Map<Item, FishStats> fishStatsMap = new LinkedHashMap<Item, FishStats>();

    @Override
    public int getTimesFished() {
        return this.timesFished;
    }

    @Override
    public void incrementTimesFished() {
        ++this.timesFished;
    }

    @Override
    public void setTimesFished(int timesFished) {
        this.timesFished = timesFished;
    }

    @Override
    public boolean hasCaughtAllFish() {
        List allFish = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_7968_().m_204117_(ModTags.FISHES)).collect(Collectors.toList());
        return this.fishStatsMap.keySet().containsAll(allFish);
    }

    @Override
    public void updateFishStats(Item fishItem, int size, int weight, ItemStack fishStack) {
        FishStats currentStats = this.fishStatsMap.getOrDefault(fishItem, new FishStats(0, 0, 0, ItemStack.f_41583_));
        int newLargestSize = Math.max(currentStats.largestSize(), size);
        int newHeaviestWeight = Math.max(currentStats.heaviestWeight(), weight);
        int newTotalCaught = currentStats.totalCaught() + 1;
        ItemStack newLargestFishStack = currentStats.largestFishStack();
        if (size > currentStats.largestSize() || size == currentStats.largestSize() && weight > currentStats.heaviestWeight()) {
            newLargestFishStack = fishStack.m_41777_();
            newLargestFishStack.m_41764_(1);
        }
        this.fishStatsMap.put(fishItem, new FishStats(newLargestSize, newHeaviestWeight, newTotalCaught, newLargestFishStack));
    }

    @Override
    public Map<Item, FishStats> getFishStats() {
        return this.fishStatsMap;
    }

    @Override
    public void copyFrom(PlayerFishStats source) {
        this.setTimesFished(source.getTimesFished());
        source.getFishStats().forEach((item, stats) -> this.fishStatsMap.put((Item)item, new FishStats(stats.largestSize(), stats.heaviestWeight(), stats.totalCaught(), stats.largestFishStack().m_41777_())));
    }

    @Override
    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128405_("times_fished", this.timesFished);
        ListTag listTag = new ListTag();
        this.fishStatsMap.forEach((item, stats) -> {
            CompoundTag fishStatTag = new CompoundTag();
            fishStatTag.m_128359_("fish_item", ForgeRegistries.ITEMS.getKey(item).toString());
            fishStatTag.m_128405_("largest_size", stats.largestSize());
            fishStatTag.m_128405_("heaviest_weight", stats.heaviestWeight());
            fishStatTag.m_128405_("total_caught", stats.totalCaught());
            fishStatTag.m_128365_("largest_fish_stack", (Tag)stats.largestFishStack().m_41739_(new CompoundTag()));
            listTag.add((Object)fishStatTag);
        });
        nbt.m_128365_("player_fish_stats", (Tag)listTag);
    }

    @Override
    public void loadNBTData(CompoundTag nbt) {
        if (nbt.m_128425_("player_fish_stats", 9)) {
            ListTag listTag = nbt.m_128437_("player_fish_stats", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag fishStatTag = listTag.m_128728_(i);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(fishStatTag.m_128461_("fish_item")));
                if (item == null) continue;
                int largestSize = fishStatTag.m_128451_("largest_size");
                int heaviestWeight = fishStatTag.m_128451_("heaviest_weight");
                int totalCaught = fishStatTag.m_128451_("total_caught");
                ItemStack largestFishStack = ItemStack.m_41712_((CompoundTag)fishStatTag.m_128469_("largest_fish_stack"));
                this.fishStatsMap.put(item, new FishStats(largestSize, heaviestWeight, totalCaught, largestFishStack));
            }
        }
    }
}

