/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.client.gui;

import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.mint_gaming_studios.fishing_plus.client.ModMenuTypes;
import net.mint_gaming_studios.fishing_plus.fish.FishData;
import net.mint_gaming_studios.fishing_plus.item.custom.FishBagItem;
import net.mint_gaming_studios.fishing_plus.item.custom.FishBagUpgradeItem;
import net.mint_gaming_studios.fishing_plus.network.packet.FishBagActionC2SPacket;

public class FishBagContainer
extends AbstractContainerMenu {
    private final ItemStack fishBag;
    private final IItemHandler itemHandler;
    private final ContainerData containerData;
    private static final int SLOTS_PER_PAGE = 54;
    private static final int SLOTS_PER_ROW = 9;
    private static final int UPGRADE_HANDLER_INDEX = 540;

    public FishBagContainer(int containerId, Inventory playerInventory, ItemStack fishBag) {
        this(containerId, playerInventory, fishBag, (ContainerData)new SimpleContainerData(2));
    }

    public FishBagContainer(int containerId, Inventory playerInventory, FriendlyByteBuf data) {
        this(containerId, playerInventory, data.m_130267_(), (ContainerData)new SimpleContainerData(2));
    }

    private FishBagContainer(int containerId, Inventory playerInventory, ItemStack fishBag, ContainerData containerData) {
        super((MenuType)ModMenuTypes.FISH_BAG_MENU.get(), containerId);
        this.fishBag = fishBag;
        FishBagContainer.m_38886_((ContainerData)containerData, (int)2);
        this.containerData = containerData;
        this.m_38884_(containerData);
        this.itemHandler = (IItemHandler)this.fishBag.getCapability(ForgeCapabilities.ITEM_HANDLER).orElseThrow(() -> new IllegalStateException("FishBag hat keinen ItemHandler"));
        for (int i = 0; i < 54; ++i) {
            this.m_38897_(new FishBagSlot(this.itemHandler, i, 8 + i % 9 * 18, 18 + i / 9 * 18, this));
        }
        this.m_38897_((Slot)new FishBagUpgradeSlot(this.itemHandler, 540, 182, 20));
        int playerInvY = 140;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, playerInvY + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, playerInvY + 58));
        }
        if (playerInventory.f_35978_.m_9236_().f_46443_) {
            this.updateSlots();
        } else {
            this.containerData.m_8050_(0, 0);
            this.containerData.m_8050_(1, FishBagItem.getCurrentUpgradeLevel(this.fishBag));
        }
    }

    public void m_38946_() {
        int serverUpgradeLevel = FishBagItem.getCurrentUpgradeLevel(this.fishBag);
        if (this.getUpgradeLevel() != serverUpgradeLevel) {
            this.containerData.m_8050_(1, serverUpgradeLevel);
        }
        this.fishBag.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            int occupiedSlots = 0;
            for (int i = 0; i < handler.getSlots() - 1; ++i) {
                if (handler.getStackInSlot(i).m_41619_()) continue;
                ++occupiedSlots;
            }
            this.fishBag.m_41784_().m_128405_("OccupiedSlots", occupiedSlots);
        });
        super.m_38946_();
        this.updateSlots();
    }

    private void updateSlots() {
        for (int i = 0; i < 54; ++i) {
            Object object = this.f_38839_.get(i);
            if (!(object instanceof FishBagSlot)) continue;
            FishBagSlot fishBagSlot = (FishBagSlot)((Object)object);
            int newSlotIndex = this.getCurrentPage() * 54 + i;
            fishBagSlot.updateSlotIndex(newSlotIndex);
        }
    }

    public void handleAction(FishBagActionC2SPacket.Action action) {
        switch (action) {
            case NEXT_PAGE: {
                if (this.getCurrentPage() >= this.getUpgradeLevel()) break;
                this.containerData.m_8050_(0, this.getCurrentPage() + 1);
                break;
            }
            case PREV_PAGE: {
                if (this.getCurrentPage() <= 0) break;
                this.containerData.m_8050_(0, this.getCurrentPage() - 1);
                break;
            }
            case APPLY_UPGRADE: {
                Slot upgradeSlot;
                int currentUpgradeLevel = this.getUpgradeLevel();
                if (currentUpgradeLevel >= 9 || !(upgradeSlot = (Slot)this.f_38839_.get(54)).m_6657_() || !(upgradeSlot.m_7993_().m_41720_() instanceof FishBagUpgradeItem)) break;
                FishBagItem.setCurrentUpgradeLevel(this.fishBag, currentUpgradeLevel + 1);
                upgradeSlot.m_6201_(1);
            }
        }
    }

    public int getCurrentPage() {
        return this.containerData.m_6413_(0);
    }

    public int getUpgradeLevel() {
        return this.containerData.m_6413_(1);
    }

    public int getMaxPages() {
        return this.getUpgradeLevel() + 1;
    }

    public boolean m_6875_(Player player) {
        return player.m_150109_().f_35974_.contains((Object)this.fishBag) || player.m_150109_().f_35976_.contains((Object)this.fishBag);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack sourceStack = ItemStack.f_41583_;
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot != null && sourceSlot.m_6657_()) {
            int fishSlotsCount;
            ItemStack copyOfSourceStack = sourceSlot.m_7993_();
            sourceStack = copyOfSourceStack.m_41777_();
            int upgradeSlotContainerIndex = fishSlotsCount = 54;
            int playerInvStart = upgradeSlotContainerIndex + 1;
            int playerInvEnd = playerInvStart + 36;
            if (index <= upgradeSlotContainerIndex ? !this.m_38903_(copyOfSourceStack, playerInvStart, playerInvEnd, true) : index >= playerInvStart && (copyOfSourceStack.m_41720_() instanceof FishBagUpgradeItem ? !this.m_38903_(copyOfSourceStack, upgradeSlotContainerIndex, upgradeSlotContainerIndex + 1, false) : (FishData.isFish(copyOfSourceStack.m_41720_()) ? !this.m_38903_(copyOfSourceStack, 0, fishSlotsCount, false) : (index < playerInvEnd - 9 ? !this.m_38903_(copyOfSourceStack, playerInvEnd - 9, playerInvEnd, false) : !this.m_38903_(copyOfSourceStack, playerInvStart, playerInvEnd - 9, false))))) {
                return ItemStack.f_41583_;
            }
            if (copyOfSourceStack.m_41619_()) {
                sourceSlot.m_5852_(ItemStack.f_41583_);
            } else {
                sourceSlot.m_6654_();
            }
        }
        return sourceStack;
    }

    private int getTotalAvailableSlots() {
        return (this.getUpgradeLevel() + 1) * 54;
    }

    public static class FishBagSlot
    extends Slot {
        private final IItemHandler itemHandler;
        private int handlerIndex;
        private final FishBagContainer menu;

        public FishBagSlot(IItemHandler itemHandler, int initialHandlerIndex, int x, int y, FishBagContainer menu) {
            super((Container)new SimpleContainer(1), 0, x, y);
            this.itemHandler = itemHandler;
            this.handlerIndex = initialHandlerIndex;
            this.menu = menu;
        }

        public void updateSlotIndex(int newIndex) {
            this.handlerIndex = newIndex;
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return this.m_6659_() && FishData.isFish(stack.m_41720_());
        }

        public ItemStack m_7993_() {
            return this.m_6659_() ? this.itemHandler.getStackInSlot(this.handlerIndex) : ItemStack.f_41583_;
        }

        public boolean m_6657_() {
            return !this.m_7993_().m_41619_();
        }

        public void m_5852_(@Nonnull ItemStack stack) {
            IItemHandler iItemHandler = this.itemHandler;
            if (iItemHandler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable modifiable = (IItemHandlerModifiable)iItemHandler;
                modifiable.setStackInSlot(this.handlerIndex, stack);
            }
            this.m_6654_();
        }

        public int m_6641_() {
            return this.itemHandler.getSlotLimit(this.handlerIndex);
        }

        @Nonnull
        public ItemStack m_6201_(int amount) {
            return this.itemHandler.extractItem(this.handlerIndex, amount, false);
        }

        public boolean m_6659_() {
            return this.handlerIndex < this.menu.getTotalAvailableSlots();
        }
    }

    public static class FishBagUpgradeSlot
    extends SlotItemHandler {
        public FishBagUpgradeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return stack.m_41720_() instanceof FishBagUpgradeItem;
        }

        public int m_6641_() {
            return 1;
        }
    }
}

