/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mint_gaming_studios.fishing_plus.advancements.ModAdvancements;
import net.mint_gaming_studios.fishing_plus.fish.FishData;
import net.mint_gaming_studios.fishing_plus.item.ModItems;
import net.mint_gaming_studios.fishing_plus.item.custom.FishBagItem;

@Mod.EventBusSubscriber(modid="fishing_plus")
public class FishBagEvents {
    @SubscribeEvent
    public static void onPlayerPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        ItemStack pickedUpStack = event.getItem().m_32055_();
        if (!FishData.isFish(pickedUpStack.m_41720_()) || !FishBagEvents.hasFishingTag(pickedUpStack)) {
            return;
        }
        ItemStack fishBagStack = player.m_21120_(InteractionHand.OFF_HAND);
        if (!(fishBagStack.m_41720_() instanceof FishBagItem)) {
            return;
        }
        ItemStack finalFishBagStack = fishBagStack;
        ItemStack finalPickedUpStack = pickedUpStack.m_41777_();
        finalFishBagStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            ItemStack remainder = FishBagItem.insertItemIntoFishBag(handler, finalFishBagStack, finalPickedUpStack);
            if (remainder.m_41613_() < finalPickedUpStack.m_41613_()) {
                int occupiedSlots = 0;
                for (int i = 0; i < handler.getSlots() - 1; ++i) {
                    if (handler.getStackInSlot(i).m_41619_()) continue;
                    ++occupiedSlots;
                }
                finalFishBagStack.m_41784_().m_128405_("OccupiedSlots", occupiedSlots);
                player.m_6330_(SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                event.getItem().m_32045_(remainder);
            }
        });
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player;
        if (event.getCrafting().m_41720_() == ModItems.FISH_BAG.get() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModAdvancements.CRAFTED_FISH_BAG.trigger(player2);
        }
    }

    private static boolean hasFishingTag(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return tag != null && tag.m_128441_("FishingPlus");
    }
}

