/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.event;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.fishing_plus.capability.PlayerFishStatsProvider;
import net.mint_gaming_studios.fishing_plus.config.ModConfig;
import net.mint_gaming_studios.fishing_plus.fish.FishData;
import net.mint_gaming_studios.fishing_plus.fish.FishStats;
import net.mint_gaming_studios.fishing_plus.network.ModMessages;
import net.mint_gaming_studios.fishing_plus.network.packet.OpenFishingMinigameS2CPacket;

public class FishingEventHandler {
    private static final Map<UUID, FishingHook> activeFishingHooks = new ConcurrentHashMap<UUID, FishingHook>();
    private static final Map<UUID, List<ItemStack>> determinedLoots = new ConcurrentHashMap<UUID, List<ItemStack>>();

    public static void startMinigame(ServerPlayer serverPlayer, FishingHook hook, List<ItemStack> possibleLoot) {
        if (possibleLoot.isEmpty()) {
            return;
        }
        activeFishingHooks.put(serverPlayer.m_20148_(), hook);
        for (ItemStack stack : possibleLoot) {
            FishData.FishProperties props;
            if (!FishData.isFish(stack.m_41720_()) || (props = FishData.generateFishProperties(stack.m_41720_())) == null) continue;
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("FishSize", props.getSize());
            tag.m_128405_("FishWeight", props.getWeight());
            tag.m_128359_("FishRarity", props.calculateRarity().name());
            tag.m_128379_("FishingPlus", true);
        }
        determinedLoots.put(serverPlayer.m_20148_(), possibleLoot);
        Item caughtFishItem = null;
        ResourceLocation fishResourceLocation = new ResourceLocation("minecraft", "cod");
        boolean isFish = false;
        int size = 0;
        int weight = 0;
        ItemStack displayStack = possibleLoot.get(0);
        if (FishData.isFish(displayStack.m_41720_())) {
            isFish = true;
            caughtFishItem = displayStack.m_41720_();
            fishResourceLocation = ForgeRegistries.ITEMS.getKey((Object)caughtFishItem);
            CompoundTag tag = displayStack.m_41783_();
            if (tag != null) {
                size = tag.m_128451_("FishSize");
                weight = tag.m_128451_("FishWeight");
            }
        }
        int difficulty = 1 + serverPlayer.m_217043_().m_188503_(3);
        AtomicInteger totalCaught = new AtomicInteger(0);
        AtomicInteger recordSize = new AtomicInteger(0);
        AtomicInteger recordWeight = new AtomicInteger(0);
        if (isFish && caughtFishItem != null) {
            Item finalCaughtFishItem = caughtFishItem;
            serverPlayer.getCapability(PlayerFishStatsProvider.PLAYER_FISH_STATS).ifPresent(stats -> {
                FishStats fishStats = stats.getFishStats().get(finalCaughtFishItem);
                if (fishStats != null) {
                    totalCaught.set(fishStats.totalCaught());
                    recordSize.set(fishStats.largestSize());
                    recordWeight.set(fishStats.heaviestWeight());
                }
            });
        }
        ModMessages.sendToPlayer(new OpenFishingMinigameS2CPacket(difficulty, fishResourceLocation, isFish, size, weight, totalCaught.get(), recordSize.get(), recordWeight.get()), serverPlayer);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onVanillaFishCaught(ItemFishedEvent event) {
        if (!((Boolean)ModConfig.COMMON.ENABLE_MINIGAME.get()).booleanValue() || event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        event.setCanceled(true);
        NonNullList loot = event.getDrops();
        FishingEventHandler.startMinigame(serverPlayer, event.getHookEntity(), (List<ItemStack>)loot);
    }

    private static ItemStack getRodInHand(Player player) {
        TagKey fishingRodsTag = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/fishing_rods"));
        ItemStack mainHandStack = player.m_21205_();
        ItemStack offHandStack = player.m_21206_();
        if (!mainHandStack.m_41619_() && (mainHandStack.m_41611_().getString().toLowerCase().contains("fishing rod") || mainHandStack.m_204117_(fishingRodsTag) || mainHandStack.m_41720_() instanceof FishingRodItem)) {
            return mainHandStack;
        }
        if (!offHandStack.m_41619_() && (offHandStack.m_41611_().getString().toLowerCase().contains("fishing rod") || offHandStack.m_204117_(fishingRodsTag) || offHandStack.m_41720_() instanceof FishingRodItem)) {
            return offHandStack;
        }
        return ItemStack.f_41583_;
    }

    public static FishingHook getActiveFishingHook(Player player) {
        return activeFishingHooks.get(player.m_20148_());
    }

    public static void clearActiveFishingHook(Player player) {
        activeFishingHooks.remove(player.m_20148_());
    }

    public static List<ItemStack> getDeterminedLoot(Player player) {
        return determinedLoots.get(player.m_20148_());
    }

    public static void clearDeterminedLoot(Player player) {
        determinedLoots.remove(player.m_20148_());
    }
}

