/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.item.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;
import net.mint_gaming_studios.fishing_plus.item.custom.FishBagItem;

public class FishBagItemHandler
extends ItemStackHandler
implements INBTSerializable<CompoundTag> {
    private final ItemStack container;
    private static final int MAX_SLOTS = 541;

    public FishBagItemHandler(ItemStack container) {
        super(541);
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    protected void onContentsChanged(int slot) {
        CompoundTag nbt = this.serializeNBT();
        this.container.m_41784_().m_128365_("Items", nbt.m_128423_("Items"));
        int count = 0;
        for (int i = 0; i < this.getSlots() - 1; ++i) {
            if (this.getStackInSlot(i).m_41619_()) continue;
            ++count;
        }
        this.container.m_41784_().m_128405_("OccupiedSlots", count);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag items = new ListTag();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            stack.m_41739_(itemTag);
            items.add((Object)itemTag);
        }
        nbt.m_128365_("Items", (Tag)items);
        nbt.m_128405_("Size", this.getSlots());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.setStackInSlot(i, ItemStack.f_41583_);
        }
        ListTag items = nbt.m_128437_("Items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag itemTag = items.m_128728_(i);
            int slot = itemTag.m_128451_("Slot");
            if (slot < 0 || slot >= this.getSlots()) continue;
            this.setStackInSlot(slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
    }

    public int getSlotLimit(int slot) {
        if (slot == this.getSlots() - 1) {
            return 1;
        }
        return 64;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int upgradeLevel = FishBagItem.getCurrentUpgradeLevel(this.container);
        int totalAvailableSlots = 54 * (upgradeLevel + 1);
        if (slot < totalAvailableSlots || slot == this.getSlots() - 1) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int upgradeLevel = FishBagItem.getCurrentUpgradeLevel(this.container);
        int totalAvailableSlots = 54 * (upgradeLevel + 1);
        if (slot < totalAvailableSlots || slot == this.getSlots() - 1) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public boolean isSlotAccessible(int slot) {
        int upgradeLevel = FishBagItem.getCurrentUpgradeLevel(this.container);
        int totalAvailableSlots = 54 * (upgradeLevel + 1);
        return slot < totalAvailableSlots || slot == this.getSlots() - 1;
    }
}

