/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.item.custom;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.fishing_plus.advancements.ModAdvancements;
import net.mint_gaming_studios.fishing_plus.capability.PlayerFishStatsProvider;
import net.mint_gaming_studios.fishing_plus.client.FishBookMenuProvider;
import net.mint_gaming_studios.fishing_plus.fish.FishStats;
import net.mint_gaming_studios.fishing_plus.tags.ModTags;

public class FishBook
extends Item {
    public FishBook(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            serverPlayer.getCapability(PlayerFishStatsProvider.PLAYER_FISH_STATS).ifPresent(stats -> {
                if (stats.hasCaughtAllFish()) {
                    ModAdvancements.CATCH_ALL_FISH.trigger(serverPlayer);
                }
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new FishBookMenuProvider(), buf -> {
                    Map<Item, FishStats> playerStats = stats.getFishStats();
                    List pages = ForgeRegistries.ITEMS.getValues().stream().filter(item -> (item.m_7968_().m_204117_(ModTags.FISHES) || item.m_7968_().m_204117_(ItemTags.f_13156_) || item.m_7968_().m_204117_(ModTags.RAW_FISHES)) && !ForgeRegistries.ITEMS.getKey(item).m_135815_().contains("cooked")).collect(Collectors.toList());
                    pages.sort(Comparator.comparing(i -> ForgeRegistries.ITEMS.getKey(i).toString()));
                    buf.writeInt(pages.size());
                    for (Item fishItem : pages) {
                        FishStats fishStat = playerStats.get(fishItem);
                        buf.m_130085_(ForgeRegistries.ITEMS.getKey((Object)fishItem));
                        if (fishStat != null) {
                            buf.writeInt(fishStat.largestSize());
                            buf.writeInt(fishStat.heaviestWeight());
                            buf.writeInt(fishStat.totalCaught());
                            buf.m_130055_(fishStat.largestFishStack());
                            continue;
                        }
                        buf.writeInt(0);
                        buf.writeInt(0);
                        buf.writeInt(0);
                        buf.m_130055_(ItemStack.f_41583_);
                    }
                });
            });
        }
        return InteractionResultHolder.m_19092_((Object)pPlayer.m_21120_(pUsedHand), (boolean)pLevel.m_5776_());
    }
}

