/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.mixin;

import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.items.TideFishingRodItem;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.mint_gaming_studios.fishing_plus.config.ModConfig;
import net.mint_gaming_studios.fishing_plus.event.FishingEventHandler;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TideFishingRodItem.class}, remap=false)
public abstract class TideFishingRodItemMixin {
    private static final Logger LOGGER = LogUtils.getLogger();

    public TideFishingRodItemMixin() {
        LOGGER.info("*****************************************************************");
        LOGGER.info("* Fishing+ Tides Compatibility Mixin successfully loaded!       *");
        LOGGER.info("* If you see this, the Mixin configuration is working correctly.  *");
        LOGGER.info("*****************************************************************");
    }

    @Shadow
    public abstract boolean isHookActive(Player var1);

    @Shadow
    public abstract TideFishingHook getHook(Player var1);

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void fishingPlus$interceptTidesRodUse(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        TideFishingHook hook;
        if (level.f_46443_ || !((Boolean)ModConfig.COMMON.ENABLE_MINIGAME.get()).booleanValue()) {
            return;
        }
        if (this.isHookActive(player) && (hook = this.getHook(player)) != null && hook.getCatchType() == TideFishingHook.CatchType.FISH) {
            cir.cancel();
            List loot = hook.getHookedItems();
            ItemStack rodStack = player.m_21120_(hand);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                hook.m_6074_();
                FishingHook dummyHook = new FishingHook((Player)serverPlayer, serverPlayer.m_9236_(), 0, 0);
                dummyHook.m_146884_(hook.m_20182_());
                FishingEventHandler.startMinigame(serverPlayer, dummyHook, loot);
                if (!rodStack.m_41619_()) {
                    rodStack.m_41622_(1, (LivingEntity)serverPlayer, p -> p.m_21190_(hand));
                }
            }
            cir.setReturnValue((Object)InteractionResultHolder.m_19090_((Object)rodStack));
        }
    }
}

