/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.network.packet;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkEvent;
import net.mint_gaming_studios.fishing_plus.advancements.ModAdvancements;
import net.mint_gaming_studios.fishing_plus.capability.PlayerFishStatsProvider;
import net.mint_gaming_studios.fishing_plus.event.FishingEventHandler;
import net.mint_gaming_studios.fishing_plus.fish.FishData;
import net.mint_gaming_studios.fishing_plus.item.custom.FishBagItem;

public class FishingSuccessC2SPacket {
    private final boolean success;

    public FishingSuccessC2SPacket(boolean success) {
        this.success = success;
    }

    public FishingSuccessC2SPacket(FriendlyByteBuf buf) {
        this.success = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.success);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            FishingHook hook;
            ServerPlayer player = context.getSender();
            if (player != null && this.success && (hook = FishingEventHandler.getActiveFishingHook((Player)player)) != null) {
                List<ItemStack> loot = FishingEventHandler.getDeterminedLoot((Player)player);
                if (loot == null) {
                    hook.m_146870_();
                    FishingEventHandler.clearActiveFishingHook((Player)player);
                    return;
                }
                int experience = 1 + player.m_9236_().f_46441_.m_188503_(6);
                player.m_9236_().m_7967_((Entity)new ExperienceOrb(player.m_9236_(), player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, experience));
                for (ItemStack itemstack : loot) {
                    ItemStack itemToProcess;
                    CompoundTag tag;
                    if (FishData.isFish(itemstack.m_41720_()) && (tag = itemstack.m_41783_()) != null && tag.m_128441_("FishSize")) {
                        int size = tag.m_128451_("FishSize");
                        int weight = tag.m_128451_("FishWeight");
                        player.getCapability(PlayerFishStatsProvider.PLAYER_FISH_STATS).ifPresent(stats -> {
                            if (stats.getTimesFished() == 0) {
                                ModAdvancements.FIRST_FISH_CAUGHT.trigger(player);
                            }
                            stats.incrementTimesFished();
                            stats.updateFishStats(itemstack.m_41720_(), size, weight, itemstack);
                        });
                    }
                    if (FishData.isFish((itemToProcess = itemstack.m_41777_()).m_41720_())) {
                        Inventory playerInventory = player.m_150109_();
                        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                            ItemStack potentialBag = playerInventory.m_8020_(i);
                            if (!(potentialBag.m_41720_() instanceof FishBagItem)) continue;
                            ItemStack bag = potentialBag;
                            ItemStack finalItemToProcess = itemToProcess;
                            itemToProcess = bag.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> FishBagItem.insertItemIntoFishBag(handler, bag, finalItemToProcess)).orElse(itemToProcess);
                            if (itemToProcess.m_41619_()) break;
                        }
                    }
                    if (itemToProcess.m_41613_() < itemstack.m_41613_()) {
                        player.m_6330_(SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                    }
                    if (itemToProcess.m_41619_() || player.m_150109_().m_36054_(itemToProcess)) continue;
                    ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), itemToProcess);
                    player.m_9236_().m_7967_((Entity)itemEntity);
                }
                hook.m_146870_();
                FishingEventHandler.clearActiveFishingHook((Player)player);
                FishingEventHandler.clearDeterminedLoot((Player)player);
            }
        });
        return true;
    }
}

