/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.fishing_plus.network.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.mint_gaming_studios.fishing_plus.client.gui.FishCaughtScreen;

public class OpenFishCaughtScreenS2CPacket {
    private final ItemStack fishStack;
    private final int fishSize;
    private final int fishWeight;
    private final int totalCaught;
    private final int recordSize;
    private final int recordWeight;

    public OpenFishCaughtScreenS2CPacket(ItemStack fishStack, int fishSize, int fishWeight, int totalCaught, int recordSize, int recordWeight) {
        this.fishStack = fishStack;
        this.fishSize = fishSize;
        this.fishWeight = fishWeight;
        this.totalCaught = totalCaught;
        this.recordSize = recordSize;
        this.recordWeight = recordWeight;
    }

    public OpenFishCaughtScreenS2CPacket(FriendlyByteBuf buf) {
        this.fishStack = buf.m_130267_();
        this.fishSize = buf.readInt();
        this.fishWeight = buf.readInt();
        this.totalCaught = buf.readInt();
        this.recordSize = buf.readInt();
        this.recordWeight = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130055_(this.fishStack);
        buf.writeInt(this.fishSize);
        buf.writeInt(this.fishWeight);
        buf.writeInt(this.totalCaught);
        buf.writeInt(this.recordSize);
        buf.writeInt(this.recordWeight);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new FishCaughtScreen(this.fishStack, this.fishSize, this.fishWeight, this.totalCaught, this.recordSize, this.recordWeight))));
        return true;
    }
}

