/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client;

import com.mojang.datafixers.util.Either;
import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.client.ClientShapeTooltip;
import dev.tazer.clutternomore.client.ShapeSwitcherOverlay;
import dev.tazer.clutternomore.common.event.DatamapHandler;
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
import dev.tazer.clutternomore.common.networking.ShapeTooltip;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="clutternomore", value={Dist.CLIENT})
public class ClientEvents {
    private static ShapeSwitcherOverlay OVERLAY = null;
    private static boolean showTooltip = false;
    public static final Lazy<KeyMapping> SHAPE_KEY = Lazy.of(() -> new KeyMapping("key.clutternomore.change_block_shape", 342, "key.categories.inventory"));

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)SHAPE_KEY.get());
    }

    @SubscribeEvent
    public static void registerTooltipComponent(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ShapeTooltip.class, ClientShapeTooltip::new);
    }

    @SubscribeEvent
    public static void onItemTooltips(ItemTooltipEvent event) {
        Item item = event.getItemStack().getItem();
        List tooltip = event.getToolTip();
        boolean hasShapes = DatamapHandler.SHAPES_DATAMAP.containsKey(item);
        boolean isShape = DatamapHandler.INVERSE_SHAPES_DATAMAP.containsKey(item);
        if (!showTooltip && (hasShapes || isShape)) {
            MutableComponent component = ((Component)tooltip.getFirst()).copy().append((Component)Component.literal((String)" [+]").withStyle(ChatFormatting.DARK_GRAY));
            tooltip.removeFirst();
            tooltip.addFirst(component);
        }
    }

    @SubscribeEvent
    public static void onRenderTooltip(RenderTooltipEvent.GatherComponents event) {
        List tooltipElements = event.getTooltipElements();
        for (Either element : new ArrayList(tooltipElements)) {
            element.ifRight(tooltipComponent -> {
                if (tooltipComponent instanceof ShapeTooltip && !showTooltip) {
                    tooltipElements.remove(element);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        int action = event.getAction();
        if (event.getKey() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClientEvents.onKeyInput(action);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.MouseButton.Post event) {
        int action = event.getAction();
        if (event.getButton() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClientEvents.onKeyInput(action);
        }
    }

    @SubscribeEvent
    public static void onMouseScrolling(InputEvent.MouseScrollingEvent event) {
        int direction = (int)event.getScrollDeltaY();
        if (OVERLAY != null) {
            OVERLAY.onMouseScrolled(direction);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onScreenScroll(ScreenEvent.MouseScrolled.Post event) {
        ItemStack heldStack;
        AbstractContainerScreen screen;
        Slot slot;
        Screen screen2;
        if (showTooltip && (screen2 = event.getScreen()) instanceof AbstractContainerScreen && (slot = (screen = (AbstractContainerScreen)screen2).getSlotUnderMouse()) != null && (DatamapHandler.SHAPES_DATAMAP.containsKey((heldStack = slot.getItem()).getItem()) || DatamapHandler.INVERSE_SHAPES_DATAMAP.containsKey(heldStack.getItem()))) {
            ClientEvents.switchShapeInSlot((Player)screen.getMinecraft().player, screen.getMenu().containerId, slot.getSlotIndex(), heldStack, (int)event.getScrollDeltaY());
        }
    }

    @SubscribeEvent
    public static void onScreenInput(ScreenEvent.KeyPressed.Post event) {
        if (event.getKeyCode() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClientEvents.onKeyPress(event.getScreen());
        }
    }

    @SubscribeEvent
    public static void onScreenInput(ScreenEvent.MouseButtonPressed.Post event) {
        if (event.getButton() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClientEvents.onKeyPress(event.getScreen());
        }
    }

    @SubscribeEvent
    public static void onScreenInput(ScreenEvent.KeyReleased.Post event) {
        if (event.getKeyCode() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClientEvents.onKeyRelease();
        }
    }

    @SubscribeEvent
    public static void onScreenInput(ScreenEvent.MouseButtonReleased.Post event) {
        if (event.getButton() == ((KeyMapping)SHAPE_KEY.get()).getKey().getValue()) {
            ClientEvents.onKeyRelease();
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        if (OVERLAY != null && ClientEvents.OVERLAY.render) {
            OVERLAY.render(event.getGuiGraphics(), event.getPartialTick().getGameTimeDeltaTicks());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        if (OVERLAY != null && !OVERLAY.shouldStayOpenThisTick()) {
            OVERLAY = null;
        }
    }

    public static void onKeyInput(int action) {
        ItemStack heldStack;
        LocalPlayer player;
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen == null && (player = minecraft.player) != null && (DatamapHandler.SHAPES_DATAMAP.containsKey((heldStack = player.getItemInHand(InteractionHand.MAIN_HAND)).getItem()) || DatamapHandler.INVERSE_SHAPES_DATAMAP.containsKey(heldStack.getItem()))) {
            switch ((CNMConfig.InputType)((Object)CNMConfig.HOLD.get())) {
                case HOLD: {
                    if (OVERLAY == null && action == 1) {
                        OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                        break;
                    }
                    if (action != 0) break;
                    OVERLAY = null;
                    break;
                }
                case TOGGLE: {
                    if (action != 1) break;
                    if (OVERLAY == null) {
                        OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, true);
                        break;
                    }
                    OVERLAY = null;
                    break;
                }
                case PRESS: {
                    if (action != 1) break;
                    if (OVERLAY == null) {
                        OVERLAY = new ShapeSwitcherOverlay(minecraft, heldStack, false);
                    }
                    OVERLAY.onMouseScrolled(-1);
                    OVERLAY = null;
                }
            }
        }
    }

    public static void onKeyPress(Screen screen) {
        ItemStack heldStack;
        AbstractContainerScreen containerScreen;
        Slot slot;
        if (screen instanceof AbstractContainerScreen && (slot = (containerScreen = (AbstractContainerScreen)screen).getSlotUnderMouse()) != null && (DatamapHandler.SHAPES_DATAMAP.containsKey((heldStack = slot.getItem()).getItem()) || DatamapHandler.INVERSE_SHAPES_DATAMAP.containsKey(heldStack.getItem()))) {
            switch ((CNMConfig.InputType)((Object)CNMConfig.HOLD.get())) {
                case HOLD: {
                    showTooltip = true;
                    break;
                }
                case TOGGLE: {
                    showTooltip = !showTooltip;
                    break;
                }
                case PRESS: {
                    ClientEvents.switchShapeInSlot((Player)screen.getMinecraft().player, containerScreen.getMenu().containerId, slot.getSlotIndex(), heldStack, -1);
                }
            }
        }
    }

    public static void onKeyRelease() {
        if (CNMConfig.HOLD.get() == CNMConfig.InputType.HOLD) {
            showTooltip = false;
        }
    }

    public static void switchShapeInSlot(Player player, int containerId, int slotId, ItemStack heldStack, int direction) {
        Item item = DatamapHandler.INVERSE_SHAPES_DATAMAP.getOrDefault(heldStack.getItem(), heldStack.getItem());
        int count = heldStack.getCount();
        ArrayList<Item> shapes = new ArrayList<Item>((Collection)DatamapHandler.SHAPES_DATAMAP.get(item));
        shapes.addFirst(item);
        int selectedIndex = shapes.indexOf(heldStack.getItem());
        int maxIndex = shapes.size() - 1;
        if ((selectedIndex -= direction) < 0) {
            selectedIndex = maxIndex;
        }
        if (selectedIndex > maxIndex) {
            selectedIndex = 0;
        }
        Item nextItem = (Item)shapes.get(selectedIndex);
        ItemStack next = nextItem.getDefaultInstance();
        next.setCount(count);
        player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.3f, 1.5f);
        if (slotId < 9) {
            slotId += 36;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeStackPayload(containerId, slotId, next), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

