/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.networking.ShapeTooltip;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import org.joml.Matrix4f;

public class ClientShapeTooltip
implements ClientTooltipComponent {
    public final List<Item> shapes;
    public int selectedIndex;

    public ClientShapeTooltip(ShapeTooltip shapeTooltip) {
        this.shapes = shapeTooltip.shapes();
        this.selectedIndex = shapeTooltip.selectedIndex();
    }

    public int getHeight() {
        return 22;
    }

    public int getWidth(Font font) {
        return this.shapes.size() * 22;
    }

    public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        super.renderText(font, mouseX, mouseY, matrix, bufferSource);
    }

    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics guiGraphics) {
        ResourceLocation selected = ClutterNoMore.location("textures/gui/selected_shape_inventory.png");
        int spacing = 22;
        int startX = mouseX + 2;
        for (int index = 0; index < this.shapes.size(); ++index) {
            int x = startX + index * spacing;
            guiGraphics.renderItem(this.shapes.get(index).getDefaultInstance(), x, mouseY);
        }
        RenderSystem.enableBlend();
        guiGraphics.blit(selected, Mth.floor((float)(startX + this.selectedIndex * spacing)) - 3, mouseY - 3, 0.0f, 0.0f, 22, 22, 22, 22);
        RenderSystem.disableBlend();
    }
}

