/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tazer.clutternomore.CNMConfig;
import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.event.DatamapHandler;
import dev.tazer.clutternomore.common.networking.ChangeStackPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShapeSwitcherOverlay {
    public final Minecraft minecraft;
    public final boolean render;
    public final int selected;
    public int count;
    public final List<Item> shapes;
    public int selectedIndex;
    public float currentIndex;

    public ShapeSwitcherOverlay(Minecraft minecraft, ItemStack heldStack, boolean render) {
        this.minecraft = minecraft;
        this.render = render;
        this.selected = minecraft.player.getInventory().selected;
        Item item = DatamapHandler.INVERSE_SHAPES_DATAMAP.getOrDefault(heldStack.getItem(), heldStack.getItem());
        this.count = heldStack.getCount();
        this.shapes = new ArrayList<Item>((Collection)DatamapHandler.SHAPES_DATAMAP.get(item));
        this.shapes.addFirst(item);
        this.selectedIndex = this.shapes.indexOf(heldStack.getItem());
        this.currentIndex = this.selectedIndex;
    }

    public void render(GuiGraphics guiGraphics, float partialTick) {
        ResourceLocation background = ClutterNoMore.location("textures/gui/shape_background.png");
        ResourceLocation selected = ClutterNoMore.location("textures/gui/selected_shape.png");
        int y = guiGraphics.guiHeight() / 2 + 20;
        int centreX = guiGraphics.guiWidth() / 2 - 8;
        int spacing = 22;
        float smoothing = 1.0f - (float)Math.exp(-5.0f * partialTick);
        this.currentIndex = Mth.lerp((float)smoothing, (float)this.currentIndex, (float)this.selectedIndex);
        if (((Boolean)CNMConfig.SCROLLING.get()).booleanValue()) {
            int startX = Mth.floor((float)((float)centreX - this.currentIndex * (float)spacing));
            for (int index = 0; index < this.shapes.size(); ++index) {
                int x = startX + index * spacing;
                guiGraphics.renderItem(this.shapes.get(index).getDefaultInstance(), x, y);
                RenderSystem.enableBlend();
                guiGraphics.blit(background, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            RenderSystem.enableBlend();
            guiGraphics.blit(selected, centreX - 3, y - 3, 0.0f, 0.0f, 22, 22, 22, 22);
        } else {
            int startX = Mth.floor((float)((float)centreX - (float)this.shapes.size() / 2.0f * (float)spacing)) + spacing / 2;
            for (int index = 0; index < this.shapes.size(); ++index) {
                int x = startX + index * spacing;
                guiGraphics.renderItem(this.shapes.get(index).getDefaultInstance(), x, y);
                RenderSystem.enableBlend();
                guiGraphics.blit(background, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            RenderSystem.enableBlend();
            guiGraphics.blit(selected, Mth.floor((float)((float)startX + this.currentIndex * (float)spacing)) - 3, y - 3, 0.0f, 0.0f, 22, 22, 22, 22);
        }
        RenderSystem.disableBlend();
    }

    public void onMouseScrolled(int direction) {
        int maxIndex = this.shapes.size() - 1;
        this.selectedIndex -= direction;
        if (this.selectedIndex < 0) {
            this.selectedIndex = maxIndex;
        }
        if (this.selectedIndex > maxIndex) {
            this.selectedIndex = 0;
        }
        Item nextItem = this.shapes.get(this.selectedIndex);
        ItemStack next = nextItem.getDefaultInstance();
        next.setCount(this.count);
        Player player = (Player)Objects.requireNonNull(this.minecraft.player);
        player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.3f, 1.5f);
        player.setItemInHand(InteractionHand.MAIN_HAND, next);
        PacketDistributor.sendToServer((CustomPacketPayload)new ChangeStackPayload(-1, -1, next), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean shouldStayOpenThisTick() {
        int selected = this.minecraft.player.getInventory().selected;
        ItemStack heldStack = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
        this.count = heldStack.getCount();
        return this.shapes.contains(heldStack.getItem()) && selected == this.selected;
    }
}

