/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client.assets;

import dev.tazer.clutternomore.ClutterNoMore;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;

public interface AssetGenerator {
    default public void initialize(ResourceManager manager, ResourceSink sink) {
    }

    default public void generate(Item item, ResourceManager manager, ResourceSink sink) {
    }

    default public void translate(AfterLanguageLoadEvent languageEvent) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    default public String getModel(ResourceManager manager, ResourceLocation blockstate) {
        Optional file = manager.getResource(blockstate.withPath(path -> "blockstates/" + path + ".json"));
        if (file.isEmpty()) {
            return null;
        }
        try (BufferedReader reader = ((Resource)file.get()).openAsReader();){
            String line = reader.readLine();
            while (line != null) {
                int idx = line.indexOf("\"model\":");
                if (idx >= 0) {
                    int start = line.indexOf(34, idx + 8) + 1;
                    int end = line.indexOf(34, start);
                    if (start > 0 && end > start) {
                        String string = line.substring(start, end);
                        return string;
                    }
                }
                line = reader.readLine();
            }
            return null;
        }
        catch (IOException e) {
            ClutterNoMore.LOGGER.catching((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

