/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.client.assets;

import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.client.assets.AssetGenerator;
import dev.tazer.clutternomore.client.assets.StepGenerator;
import dev.tazer.clutternomore.client.assets.VerticalSlabGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicClientResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModList;

public class DynamicClientResources
extends DynamicClientResourceProvider {
    private static final List<AssetGenerator> GENERATORS = List.of(new VerticalSlabGenerator(), new StepGenerator());

    public static void register() {
        RegHelper.registerDynamicResourceProvider((DynamicResourcesProvider)new DynamicClientResources());
    }

    protected DynamicClientResources() {
        super(ClutterNoMore.location("generated_pack"), PackGenerationStrategy.runOnce());
    }

    protected Collection<String> gatherSupportedNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>(List.of("minecraft", "clutternomore"));
        ModList.get().getMods().forEach(info -> namespaces.add(info.getNamespace()));
        return namespaces;
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((resourceManager, sink) -> {
            for (AssetGenerator generator : GENERATORS) {
                generator.initialize(resourceManager, sink);
                List items = BuiltInRegistries.ITEM.stream().toList();
                for (Item item : items) {
                    generator.generate(item, resourceManager, sink);
                }
            }
        });
    }

    public void addDynamicTranslations(AfterLanguageLoadEvent languageEvent) {
        for (AssetGenerator generator : GENERATORS) {
            generator.translate(languageEvent);
        }
    }
}

