/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.data;

import dev.tazer.clutternomore.common.data.DataGenerator;
import dev.tazer.clutternomore.common.registry.BlockSetRegistry;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class LootGenerator
implements DataGenerator {
    @Override
    public void generate(Block block, ResourceManager manager, ResourceSink sink) {
        StaticResource lootTable;
        ResourceLocation id;
        BlockSetRegistry.ShapeSet set = null;
        if (block.asItem() != Items.AIR) {
            set = (BlockSetRegistry.ShapeSet)BlockSetAPI.getBlockTypeOf((ItemLike)block, BlockSetRegistry.ShapeSet.class);
        }
        if (set == null || block != set.mainChild()) {
            return;
        }
        if (set.hasChild("vertical_slab_block")) {
            Block verticalSlab = (Block)set.getChild("vertical_slab_block");
            ResourceLocation verticalSlabId = BuiltInRegistries.ITEM.getKey((Object)verticalSlab.asItem());
            id = BuiltInRegistries.ITEM.getKey((Object)block.asItem());
            lootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)id.withPath(path -> "loot_table/blocks/" + path + ".json"));
            if (lootTable != null) {
                sink.addSimilarJsonResource(manager, lootTable, t -> t, path -> path.replace(id.getPath(), verticalSlabId.getPath()));
            }
        }
        if (set.hasChild("step_block")) {
            Block step = (Block)set.getChild("step_block");
            ResourceLocation stepId = BuiltInRegistries.ITEM.getKey((Object)step.asItem());
            id = BuiltInRegistries.ITEM.getKey((Object)block.asItem());
            lootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)id.withPath(path -> "loot_table/blocks/" + path + ".json"));
            if (lootTable != null) {
                sink.addSimilarJsonResource(manager, lootTable, t -> t, path -> path.replace(id.getPath(), stepId.getPath()));
            }
        }
        set.getChildren().forEach(entry -> {
            if (((String)entry.getKey()).startsWith("vertical_slab") || ((String)entry.getKey()).startsWith("step")) {
                return;
            }
            Object patt0$temp = entry.getValue();
            if (patt0$temp instanceof Item) {
                Item item = (Item)patt0$temp;
                ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)block.asItem());
                StaticResource lootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)id.withPath(path -> "loot_table/blocks/" + path + ".json"));
                if (lootTable != null) {
                    Function<String, String> pathTransform = path -> path.replace(id.getPath(), itemId.getPath());
                    ResourceLocation fullPath = lootTable.location;
                    StringBuilder builder = new StringBuilder();
                    String[] partial = fullPath.getPath().split("/");
                    for (int i = 0; i < partial.length; ++i) {
                        if (i != 0) {
                            builder.append("/");
                        }
                        if (i == partial.length - 1) {
                            builder.append(pathTransform.apply(partial[i]));
                            continue;
                        }
                        builder.append(partial[i]);
                    }
                    ResourceLocation newRes = ResourceLocation.fromNamespaceAndPath((String)fullPath.getNamespace(), (String)builder.toString());
                    StaticResource newTable = StaticResource.create((byte[])lootTable.data, (ResourceLocation)newRes);
                    sink.addResource(newTable);
                }
            }
        });
    }
}

