/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.data;

import dev.tazer.clutternomore.ClutterNoMore;
import dev.tazer.clutternomore.common.data.DataGenerator;
import dev.tazer.clutternomore.common.registry.BlockSetRegistry;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class TagsGenerator
implements DataGenerator {
    public SimpleTagBuilder verticalSlabItems;
    public SimpleTagBuilder stepItems;
    public SimpleTagBuilder verticalSlabBlocks;
    public SimpleTagBuilder stepBlocks;
    public SimpleTagBuilder woodenVerticalSlabItems;
    public SimpleTagBuilder woodenStepItems;
    public SimpleTagBuilder woodenVerticalSlabBlocks;
    public SimpleTagBuilder woodenStepBlocks;
    public SimpleTagBuilder pickaxeMineable;

    @Override
    public void initialize(ResourceManager manager, ResourceSink sink) {
        this.verticalSlabItems = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("vertical_slabs"));
        this.stepItems = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("steps"));
        this.verticalSlabBlocks = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("vertical_slabs"));
        this.stepBlocks = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("steps"));
        this.woodenVerticalSlabItems = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("wooden_vertical_slabs"));
        this.woodenStepItems = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("wooden_steps"));
        this.woodenVerticalSlabBlocks = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("wooden_vertical_slabs"));
        this.woodenStepBlocks = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("wooden_steps"));
        this.pickaxeMineable = SimpleTagBuilder.of((ResourceLocation)ClutterNoMore.location("mineable/pickaxe"));
    }

    @Override
    public void generate(Item item, ResourceManager manager, ResourceSink sink) {
        WoodType woodType;
        boolean wood;
        BlockSetRegistry.ShapeSet set = (BlockSetRegistry.ShapeSet)BlockSetAPI.getBlockTypeOf((ItemLike)item, BlockSetRegistry.ShapeSet.class);
        if (set == null || item != set.mainChild().asItem()) {
            return;
        }
        String id = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
        boolean bl = wood = id.contains("wood") || id.contains("planks");
        if (!wood && (woodType = (WoodType)BlockSetAPI.getBlockTypeOf((ItemLike)item, WoodType.class)) != null) {
            wood = true;
        }
        if (set.hasChild("vertical_slab")) {
            Item verticalSlab = (Item)set.getChild("vertical_slab");
            this.verticalSlabItems.addEntry((Object)verticalSlab);
            if (wood) {
                this.woodenVerticalSlabItems.addEntry((Object)verticalSlab);
            } else {
                this.pickaxeMineable.addEntry((Object)verticalSlab);
            }
        }
        if (set.hasChild("step")) {
            Item step = (Item)set.getChild("step");
            this.stepItems.addEntry((Object)step);
            if (wood) {
                this.woodenStepItems.addEntry((Object)step);
            } else {
                this.pickaxeMineable.addEntry((Object)step);
            }
        }
    }

    @Override
    public void generate(Block block, ResourceManager manager, ResourceSink sink) {
        WoodType woodType;
        boolean wood;
        BlockSetRegistry.ShapeSet set = null;
        if (block.asItem() != Items.AIR) {
            set = (BlockSetRegistry.ShapeSet)BlockSetAPI.getBlockTypeOf((ItemLike)block, BlockSetRegistry.ShapeSet.class);
        }
        if (set == null || block != set.mainChild()) {
            return;
        }
        String id = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        boolean bl = wood = id.contains("wood") || id.contains("planks");
        if (!wood && (woodType = (WoodType)BlockSetAPI.getBlockTypeOf((ItemLike)block, WoodType.class)) != null) {
            wood = true;
        }
        if (set.hasChild("vertical_slab_block")) {
            Block verticalSlab = (Block)set.getChild("vertical_slab_block");
            this.verticalSlabBlocks.addEntry((Object)verticalSlab);
            if (wood) {
                this.woodenVerticalSlabBlocks.addEntry((Object)verticalSlab);
            } else {
                this.pickaxeMineable.addEntry((Object)verticalSlab);
            }
        }
        if (set.hasChild("step_block")) {
            Block step = (Block)set.getChild("step_block");
            this.stepBlocks.addEntry((Object)step);
            if (wood) {
                this.woodenStepBlocks.addEntry((Object)step);
            } else {
                this.pickaxeMineable.addEntry((Object)step);
            }
        }
    }

    @Override
    public void finish(ResourceManager manager, ResourceSink sink) {
        sink.addTag(this.verticalSlabItems, Registries.ITEM);
        sink.addTag(this.verticalSlabBlocks, Registries.BLOCK);
        sink.addTag(this.woodenVerticalSlabItems, Registries.ITEM);
        sink.addTag(this.woodenVerticalSlabBlocks, Registries.BLOCK);
        SimpleTagBuilder builder = SimpleTagBuilder.of((TagKey)BlockTags.SLABS);
        builder.addTag(this.verticalSlabBlocks);
        sink.addTag(builder, Registries.BLOCK);
        builder = SimpleTagBuilder.of((TagKey)ItemTags.SLABS);
        builder.addTag(this.verticalSlabItems);
        sink.addTag(builder, Registries.ITEM);
        builder = SimpleTagBuilder.of((TagKey)BlockTags.WOODEN_SLABS);
        builder.addTag(this.woodenVerticalSlabBlocks);
        sink.addTag(builder, Registries.BLOCK);
        builder = SimpleTagBuilder.of((TagKey)ItemTags.WOODEN_SLABS);
        builder.addTag(this.woodenVerticalSlabItems);
        sink.addTag(builder, Registries.ITEM);
        sink.addTag(this.stepItems, Registries.ITEM);
        sink.addTag(this.stepBlocks, Registries.BLOCK);
        sink.addTag(this.woodenStepItems, Registries.ITEM);
        sink.addTag(this.woodenStepBlocks, Registries.BLOCK);
        builder = SimpleTagBuilder.of((TagKey)BlockTags.STAIRS);
        builder.addTag(this.stepBlocks);
        sink.addTag(builder, Registries.BLOCK);
        builder = SimpleTagBuilder.of((TagKey)ItemTags.STAIRS);
        builder.addTag(this.stepItems);
        sink.addTag(builder, Registries.ITEM);
        builder = SimpleTagBuilder.of((TagKey)BlockTags.WOODEN_STAIRS);
        builder.addTag(this.woodenStepBlocks);
        sink.addTag(builder, Registries.BLOCK);
        builder = SimpleTagBuilder.of((TagKey)ItemTags.WOODEN_STAIRS);
        builder.addTag(this.woodenStepItems);
        sink.addTag(builder, Registries.ITEM);
        builder = SimpleTagBuilder.of((TagKey)BlockTags.MINEABLE_WITH_PICKAXE);
        builder.merge(this.pickaxeMineable);
        sink.addTag(builder, Registries.BLOCK);
    }
}

