/*
 * Decompiled with CFR 0.152.
 */
package dev.tazer.clutternomore.common.event;

import dev.tazer.clutternomore.common.event.DatamapHandler;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public record CReloadListener(ReloadableServerResources resources) implements ResourceManagerReloadListener
{
    public void onResourceManagerReload(ResourceManager resourceManager) {
        boolean changed = false;
        RecipeManager recipeManager = this.resources.getRecipeManager();
        HolderLookup.Provider registries = this.resources.getRegistryLookup();
        ArrayList originalRecipes = new ArrayList(recipeManager.getRecipes());
        ArrayList<RecipeHolder> newRecipes = new ArrayList<RecipeHolder>();
        for (RecipeHolder recipeHolder : originalRecipes) {
            Recipe recipe = recipeHolder.value();
            Item result = recipe.getResultItem(registries).getItem();
            if (DatamapHandler.INVERSE_SHAPES_DATAMAP.containsKey(result)) continue;
            NonNullList ingredients = recipe.getIngredients();
            for (Ingredient ingredient : new ArrayList(ingredients)) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (ItemStack stack : ingredient.getItems()) {
                    Item item = stack.getItem();
                    if (DatamapHandler.INVERSE_SHAPES_DATAMAP.containsKey(item)) {
                        ItemStack originalStack = DatamapHandler.INVERSE_SHAPES_DATAMAP.get(item).getDefaultInstance();
                        originalStack.setCount(stack.getCount());
                        stacks.add(originalStack);
                        changed = true;
                        continue;
                    }
                    stacks.add(stack);
                }
                Stream newStacks = stacks.stream();
                if (!changed) continue;
                int index = ingredients.indexOf((Object)ingredient);
                ingredients.set(index, (Object)Ingredient.of(newStacks));
            }
            RecipeHolder newHolder = new RecipeHolder(recipeHolder.id(), recipe);
            newRecipes.add(newHolder);
        }
        if (changed) {
            recipeManager.replaceRecipes(newRecipes);
        }
    }
}

